<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        exclude-result-prefixes="sitemap ametys resolver odf escaper">

    <xsl:import href="skin://stylesheets/content/common/zone/header.xsl" />
    <xsl:import href="skin://stylesheets/content/program/tool/check-admission.xsl" />
    
    <xsl:template name="main-banner">
        <xsl:variable name="imgUrl"><xsl:call-template name="main-banner-illustration-url"/></xsl:variable>
        <div class="ametys-main-banner-alt" style="background-image: url({ametys:escapeURLforCSS($imgUrl)}); min-height: 360px;">

            <div class="container position-relative g-z-index-3">
                <xsl:call-template name="main-banner-breadcrumb"/>
            </div>
            
            <div class="container position-relative g-z-index-4">
                <xsl:call-template name="main-banner-category"/>
                <xsl:call-template name="main-banner-title"/>
                <xsl:call-template name="main-banner-subtitle"/>
                
                <xsl:call-template name="main-banner-subprograms"/>
            </div>
            
            <xsl:call-template name="main-banner-label"/>
            
            <xsl:call-template name="main-banner-footer"/>
        </div>
    </xsl:template>
    
    <!-- +
         | This template is for banner illustration. The banner is selected in order of priority among :
         | * the illustration of the program if not empty 
         | * or the illustration of the orgunit if not empty
         | * or the banner linked to the domain's code if domain is not empty (see resources/templates/common/img/banners/[CODE].png)
         | * or a default banner of the skin (see resources/templates/common/img/banners/default.png)
         + -->
    <xsl:template name="main-banner-illustration-url">
        <xsl:variable name="orgunitId" select="ametys:contentAttribute(@id, 'orgUnit')/@id"/>
        
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <xsl:call-template name="get-image-uri">
                    <xsl:with-param name="img" select="metadata/illustration/image"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$orgunitId and ametys:hasValue($orgunitId, 'illustration/image')">
                <xsl:call-template name="get-image-uri-from-attribute">
                    <xsl:with-param name="id" select="$orgunitId"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="metadata/domain">
                <xsl:variable name="code" select="ametys:contentAttribute(metadata/domain/@id, 'code')"/>
                <xsl:variable name="domainImgPath" select="concat('templates/common/img/banners/', $code, '.png')"/>
                <xsl:choose>
                    <xsl:when test="ametys:skinResources($domainImgPath)">
                        <xsl:value-of select="ametys:skinURL($domainImgPath)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="main-banner-illustration-default-url"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:call-template name="main-banner-illustration-default-url"/></xsl:otherwise><!-- default image -->
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-banner-illustration-default-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/default.png')"/>
    </xsl:template>
    
    <!-- +
         | Template to display a category above the the program's title.
         | By default, display the domain(s) if not empty.
         + -->
    <xsl:template name="main-banner-category">
        <div class="ametys-main-banner-alt__category">
            <xsl:choose>
                <xsl:when test="normalize-space(metadata/domain/@title ) != ''">
                    <xsl:for-each select="metadata/domain">
                        <xsl:value-of select="@title"/><xsl:if test="position() != last()">, </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <!-- +
         | Template to display a subtitle under the program's title.
         | By default, display the mention if not empty.
         + -->
    <xsl:template name="main-banner-subtitle">
        <xsl:if test="normalize-space(metadata/mention/@title ) != ''">
            <div class="ametys-main-banner-alt__subtitle">
                <xsl:value-of select="metadata/mention/@title"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template to display the available subprograms
         + -->
    <xsl:template name="main-banner-subprograms">
        <xsl:variable name="structure" select="odf:getProgramStructure(@id, 1)"/>
        <xsl:variable name="count" select="count($structure/subprogram)"/>
        <xsl:variable name="programId" select="@id"/>
        
        <xsl:if test="$count &gt; 0">
	        <div class="ametys-dropdown d-inline-block">
	            <a id="hiddenCoursesInvoker" class="ametys-main-banner-alt__btn" href="#" aria-haspopup="true" aria-expanded="false"
	               data-dropdown-event="hover"
	               data-dropdown-target="#hiddenCourses"
	               data-dropdown-type="css-animation"
	               data-dropdown-duration="200"
	               data-dropdown-delay="0"
	               data-dropdown-hide-on-scroll="false"
	               data-dropdown-animation-in="fadeIn"
	               data-dropdown-animation-out="fadeOut">
	                <span class="ametys-main-banner-alt__btn-icon ametys-icon-path"></span>
                    <xsl:value-of select="$count"/><xsl:text> </xsl:text>
                    <xsl:choose>
                        <xsl:when test="$count = 1">
                            <i18n:text i18n:key="PROGRAM_HEADER_AVAILABLE_SUBPROGRAM" i18n:catalogue="skin.{$skin}"/>
                        </xsl:when>
                        <xsl:otherwise>
        	                <i18n:text i18n:key="PROGRAM_HEADER_AVAILABLE_SUBPROGRAMS" i18n:catalogue="skin.{$skin}"/>
                        </xsl:otherwise>
                    </xsl:choose>
	            </a>
	            
	            <div id="hiddenCourses" class="ametys-dropdown-content-alt ametys-dropdown-content-alt--left u-dropdown--hidden w-300px w-lg-395px" aria-labelledby="hiddenCoursesInvoker">
	                
	                <ul class="ametys-external-links-list">
	                    <xsl:for-each select="$structure/subprogram">
	                        <li class="ametys-external-links-list__item">
                                <a class="ametys-external-links-list__link" href="{resolver:resolve('odf', concat(@id, ';', $programId))}">
                                    <span class="ametys-external-links-list__link-text"><xsl:value-of select="@title"/></span>
                                </a>
		                    </li>
	                    </xsl:for-each>
	                </ul>
	            
	            </div>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-banner-label">
        <xsl:variable name="label" select="odf:getCertificationLabel(@id)"/>
        
        <xsl:if test="$label != ''">
            <div class="ametys-main-banner-label">
                <div class="ametys-main-banner-label-inner">
                    <xsl:variable name="labelImgPath" select="concat('templates/common/img/labels/', $label, '.svg')"/>
                    <img class="ametys-main-banner-label__img" src="{ametys:skinURL($labelImgPath)}" alt="" />
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>