<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver odf">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="skin://templates/index/stylesheets/benefits.xsl" />
    <xsl:import href="skin://templates/index/stylesheets/categories.xsl" />
    <xsl:import href="skin://templates/index/stylesheets/orgunits.xsl" />
    
    <xsl:template name="additionnal-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/education/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/education/scss/print.css')}"/>
    </xsl:template>

    <xsl:template name="main-banner">
        <div class="ametys-main-banner"
            style="background-image: url({ametys:skinURL('templates/common/img/banners/banner-1.jpg')});">
    
            <div class="ametys-main-banner-inner">
                <div class="container">
                
                    <zone name="header" level="1"/>

                    <!-- Domain carousel -->                    
                    <xsl:call-template name="categories-carousel">
                        <xsl:with-param name="items" select="odf:getTableRefItems('odf-enumeration.Domain', $lang)"/>
                        <xsl:with-param name="metadataName" select="'domain'"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="benefits" />
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-content">
        <div class="ametys-main-content home">
            <xsl:call-template name="orgunits-carousel"/>
            
            <zone name="default" level="1"/>
        </div>
    </xsl:template>
</xsl:stylesheet>