(function ($) {
	$(function () {
		
		var search = '#search',
			target = null;
		
		$(search + ' [data-autocomplete-target]').on('focus keyup', function () {
			
			var $this = $(this);
			
			target = $this.data('autocomplete-target');
			
			var $target = $(target),
				
				$pages = $('#autocompleteFormations'),
				$skills = $('#autocompleteCompetences'),
				$tags = $('#autocompleteEtiquettes'),
				
				pages = [],
				skills = [],
				tags = [],
				
				dataJSON = './resources/zones/courses/json/data.json';
			
			// Show / Hide
			if ($this.val().length > 2) {
				
				// Fetch data
				$.getJSON(dataJSON, {title: $this.val()}).done(function (data) {
					
					if (data.pages && $pages) {
						
						$.each(data.pages, function (i) {
							
							pages.push('<li class="ametys-search-form-dropdown-content-list__item">' +
								'<a class="ametys-search-form-dropdown-content-list__link" href="' + data.pages[i].id + '" target="_blank">' +
								'<span class="ametys-search-form-dropdown-content-list__item-icon fas fa-share"></span>' + data.pages[i].title + '' +
								'</a>' +
								'</li>');
							
						});
						
						$pages.html(pages.join(''));
						
					}
					
					if (data.skills && $skills) {
						
						$.each(data.skills, function (i) {
							
							skills.push('<li class="ametys-search-form-dropdown-content-list__item">' +
								'<a class="ametys-search-form-dropdown-content-list__link" href="' + data.skills[i].id + '" target="_blank">' + data.skills[i].title + '</a>' +
								'</li>');
							
						});
						
						$skills.html(skills.join(''));
						
					}
					
					if (data.tags && $tags) {
						
						$.each(data.tags, function (i) {
							
							tags.push('<li class="ametys-checkbox-badge ametys-checkbox-badge--bordered ametys-checkbox-badge--pilled">' +
								'<a class="ametys-checkbox-badge__label" href="' + data.tags[i].id + '" target="_blank">' + data.tags[i].title + '</a>' +
								'</li>');
							
						});
						
						$tags.html(tags.join(''));
						
					}
					
				});
				
				// End Fetch data
				
				$target.fadeIn(200);
				
			} else {
				
				pages = [];
				skills = [];
				tags = [];
				
				$target.fadeOut(200, function () {
					
					if ($pages) $pages.html('');
					
					if ($skills) $skills.html('');
					
					if ($tags) $tags.html('');
					
				});
				
			}
			
			// End Show / Hide
			
		});
		
		// Hide
		$(document).on('click', 'body', function (e) {
			
			var $target = $(e.target).parents(target),
				$search = $(e.target).parents(search);
			
			if (($target.length === 1) || ($search.length === 1)) {
				
				return 0;
				
			} else {
				
				$(target).fadeOut(200);
				
			}
			
		});
		
		// End Hide
		
	});
})(jQuery);
