;(function ($) {
  'use strict';

  var AmetysResultMap = window.AmetysResultMap || {};

  AmetysResultMap = (function () {

    function AmetysResultMap(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysResultMap.defaults, options);

      this.initialize();

    }

    return AmetysResultMap;

  }());

  AmetysResultMap.defaults = {
    searchMapDialogId: null,
    searchMapDialogSelector: null,
    mapTargetSelector: null,
    popupBaseClsPrefix: 'ametys-search-map-popup',
    dialogCls: 'ametys-search-map-dialog',
    results: null
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysResultMap.prototype.initialize = function () {
    // vars
    var $self = this;
        
    $self.options.searchMapDialogSelector = '#' + $self.options.searchMapDialogId;
    $self.options.mapTargetSelector = $self.options.searchMapDialogSelector + ' [data-search-map]';
    
    $self.$element.on('click', function () {
        var $this = $(this),
            $dialog = $($self.options.searchMapDialogSelector),
            $width = $(window).width() * 0.90,
            $height = $(window).height() * 0.90,
            $mapContainer = $($self.options.mapTargetSelector),
            $map = null,
            $results = $self.options.results || [],
            $markers = {};
            
        // Group results (one marker for each results with same point)
        for (var i in $results)
        {
            var result = results[i];
            var markers = result.markers || [];
            if (markers.length > 0)
            {
                for (var j in markers)
                {
                    var lat = markers[j].lat;
                    var lng = markers[j].lng;
                    var key = lat + '-' + lng;
                    
                    if (!$markers[key])
                    {
                        $markers[key] = {
                            lat: lat,
                            lng: lng,
                            results: []
                        }
                    }
                    $markers[key].results.push(result);
                }
            }
        }
        
        // Build popup for each markers
        $self.buildPopups($markers);
        
        // Open map
        $dialog.dialog({
            resizable: false,
            modal: true,
            draggable: false,
			classes: {
			  "ui-dialog":  $self.options.dialogCls,
			},
            width: $width,
            height: $height,
            maxHeight: 850,
            maxWidth: 1024,
            
            open: function(event, ui) {
                
                // Create map
                $map = L.map($mapContainer[0]);
                
                // Fit bounds
		        if ( ! $j.isEmptyObject($markers))
		        {
                    var latlngs = [];
                    
		            for (var i in $markers)
		            {
                        var $marker = $markers[i];
                        var icon = new AmetysMarkers.Icon({text: $marker.text});
                        
                        var marker = L.marker([$marker.lat, $marker.lng], {icon: icon}).bindPopup($marker.html, {
                            maxWidth: 400
                        });
                        marker.addTo($map);
                        
                        var latlng = L.latLng($marker.lat, $marker.lng);
                        latlngs.push(latlng);
		            }
                    
		            var latLngBounds = L.latLngBounds(latlngs);
		            $map.fitBounds(latLngBounds).zoomOut(1, {animate:false});
		        }
		        else
		        {
		            $map.fitWorld();
		        }
		        
		        // Add contribution
		        L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
		            attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
		        }).addTo($map);
            },
            
            close: function( event, ui ) {
	            if ($map)
	            {
	                $map.remove();
	            }
	        }
        });
    });
  };
  
  AmetysResultMap.prototype.buildPopups = function (markers) {
  
        var $self = this,
            $popupBaseCls = $self.options.popupBaseClsPrefix,
            $itemBaseCls = $self.options.popupBaseClsPrefix + '__item',
            $listBaseCls = $self.options.popupBaseClsPrefix + '-list';
    
        for (var i in markers)
        {
            var marker = markers[i];
            if (marker.results.length > 1)
            {
                marker.text = marker.results.length;
                
                var html = '<div class="' + $popupBaseCls + '">';
                html += '<ul class="' + $listBaseCls + '">';
                for (var j in marker.results)
                {
                    var result = marker.results[j];
                    html += '<li class="' + $listBaseCls + '__item">';
                    html += '<a class="' + $listBaseCls + '__link" href="' + result.uri + '"><span class="' + $listBaseCls + '__link-title">'+ result.title + '</span></a></li>';
                }
                html + '</ul>';
                html += '</div>';
                
                marker.html = html;
            }
            else
            {
                marker.text = '';
             
                var result = marker.results[0];
                
                var html = '<div class="' + $popupBaseCls + '">';
                html += '<div class="' + $itemBaseCls + '">';
                
                html += '<div class="' + $itemBaseCls + '-content">';
                
                html += '<div class="' + $itemBaseCls + '-content-title"><a href="' + result.uri + '">' + result.title + '</a></div>';
                html += '<div class="' + $itemBaseCls + '-content-text">' + result.excerpt + '</div>';
                
                html += '</div>';
                
                if (result.imgSrc)
                {
                    html += '<div class="' + $itemBaseCls + '-img-wrap">';
                    html += '<img alt="" src="' + result.imgSrc + '"/>';
                    html += '</div>';
                }
                
                html += '</div>';
                html += '</div>';
                
                marker.html = html;
            }
        }
  };
  
  $.fn.HSAmetysResultMap = function () {

    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;

    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined') {

        _[i].AmetysResultMap = new AmetysResultMap(_[i], opt);

      } else {

        ret = _[i].AmetysResultMap[opt].apply(_[i].AmetysResultMap, args);

      }

      if (typeof ret != 'undefined') {

        return ret;

      }
    }

    return _;

  };

})(jQuery);