<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:xalan="http://xml.apache.org/xalan"
                exclude-result-prefixes="ametys xalan i18n">
    
    <xsl:import href="plugin:odf-web://pages/services/search/search_1.2.xsl"/>
    <xsl:import href="service:odf-web://pages/services/search/search-criteria/search-criteria-multiple.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:variable name="facets" select="ametys:serviceParameter('facets') = 'true'"/>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/main.css')}"/>    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/print.css')}"/>    
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
         <script src="{ametys:skinURL('templates/common/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.js')}"></script>
         <script src="{ametys:skinURL('zones/search/js/ametys-tags.js')}"></script>
         <script src="{ametys:skinURL('zones/search/js/ametys-invoker-change-text.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-search">
            <div class="ametys-search-inner">
                <xsl:call-template name="search-aside" />
        
                <xsl:call-template name="search-content"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-aside">
        <aside class="ametys-search-sidebar">
        
            <!-- <xsl:call-template name="search-map"/> -->
                                            
            <xsl:call-template name="filter-fields-area"/>                                
        </aside>
    </xsl:template>
    
    <xsl:template name="search-map">
        <div class="ametys-map-invoker mb-5">
                                                
            <span class="ametys-map-invoker__img">
                <img src="{ametys:skinURL('zones/search/img/map.png')}" alt="Google Map"/>
            </span>
            
            <a class="ametys-map-invoker__btn" href="javascript:;">
                <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SEE_ON_MAP" i18n:catalogue="skin.{$skin}"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-fields-area">
        <h4 class="g-mb-30"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_DEFAULT_FILTERS_TITLE" i18n:catalogue="skin.{$skin}"/></h4>
                                            
        <form action="{concat($site-uri-prefix, '/', /search/url)}" id="{$search-form-id}" method="POST">
            <xsl:call-template name="form-search-hidden-filters"/>
            
            <div id="searchFilterTags_{$uniqueId}">
                <div class="ametys-tags" style="display: none;"
                     data-tags-wrap="">
                    <input type="text" data-tags=""/>
                </div>
                
                <xsl:call-template name="filter-fields"/>
            </div>
        </form>
        
        <script>
            $j('#searchFilterTags_<xsl:value-of select="$uniqueId"/>').HSAmetysTags();
            $j('#searchFilterTags_<xsl:value-of select="$uniqueId"/>').HSAmetysInvokerChangeText();
        </script>
    </xsl:template>
    
    <xsl:template name="form-search-hidden-filters">
        <input type="hidden" name="submit-form">
            <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
            </xsl:if>
        </input>
        <xsl:if test="/search/zone-item/@id">
            <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
        </xsl:if>
        
        <xsl:for-each select="/search/form/values/*[local-name() != 'attribute']">
            <input type="hidden" name="{name()}" value="{.}"/>
        </xsl:for-each>
        
        <!-- Catalog -->
        <input type="hidden" name="catalog" value="{$catalog}"/>
    </xsl:template>
    
    <xsl:template name="filter-fields">
        <ul id="searchFilter" class="ametys-search-filter">
            <xsl:for-each select="/search/form/fields/metadata[enumeration]">
                <xsl:call-template name="filter-field">
                    <xsl:with-param name="fieldLabel" select="label"/>
                    <xsl:with-param name="fieldName" select="@name"/>
                </xsl:call-template>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="filter-field">
        <xsl:param name="fieldLabel"/>
        <xsl:param name="fieldName"/>
        
        <xsl:if test="not($facets) or (/search/form/facets/facet[@name = $fieldName]/item[@count &gt; 0])">
            <li class="ametys-search-filter__item">
                <button class="ametys-search-filter__item-control" type="button" aria-expanded="false"
                        data-toggle="collapse"
                        data-target="#searchFilterItem_{$fieldName}">
                    <xsl:call-template name="filter-field-icon">
                        <xsl:with-param name="fieldName" select="$fieldName"/>
                    </xsl:call-template>
                    <xsl:value-of select="$fieldLabel"/>
                    <span class="ametys-search-filter__item-control-icon ametys-icon-angle-down"></span>
                </button>
                        
                <xsl:call-template name="filter-field-items">
                    <xsl:with-param name="fieldName" select="$fieldName"/>
                    <xsl:with-param name="fieldLabel" select="$fieldLabel"/>
                </xsl:call-template>                                        
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="filter-field-items">
        <xsl:param name="fieldName"/>
        <xsl:param name="fieldLabel"/>
        
        <div id="searchFilterItem_{$fieldName}" class="collapse" data-parent="#searchFilter">
            <div class="ametys-search-filter__item-content">
                
                <xsl:choose>
                    <xsl:when test="$facets">
                        <xsl:call-template name="filter-field-facet-items">
                            <xsl:with-param name="fieldName" select="$fieldName"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="filter-field-enum-items">
                            <xsl:with-param name="fieldName" select="$fieldName"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-field-facet-items">
        <xsl:param name="fieldName"/>
        <xsl:param name="moreIndex">5</xsl:param>
        
        <xsl:for-each select="/search/form/facets/facet[@name = $fieldName]/item[@count &gt; 0]">
             <xsl:sort select="@count" data-type="number" order="descending"/>
             
             <xsl:if test="position() &lt;= $moreIndex">
                <xsl:call-template name="filter-field-facet-item"/>
             </xsl:if>
        </xsl:for-each>
        
        <xsl:if test="count(/search/form/facets/facet[@name = $fieldName]/item[@count &gt; 0]) &gt; $moreIndex">
            <div id="searchFilterItem_{$fieldName}__more" class="collapse">
                <xsl:for-each select="/search/form/facets/facet[@name = $fieldName]/item[@count &gt; 0]">
                    <xsl:sort select="@count" data-type="number" order="descending"/>
                 
                    <xsl:if test="position() &gt; $moreIndex">
                        <xsl:call-template name="filter-field-facet-item"/>
                    </xsl:if>
                </xsl:for-each>
            </div>
            
            <xsl:call-template name="filter-field-show-more_items">
                <xsl:with-param name="targetId">searchFilterItem_<xsl:value-of select="$fieldName"/>__more</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="filter-field-facet-item">
        <xsl:variable name="name" select="../@name"/>
        <xsl:variable name="value" select="/search/form/values/metadata/metadata[@name = $name]"/>
        
        <div class="ametys-checkbox">
            <input data-tags-value="{.}" id="{$uniqueId}-metadata-{translate($name, '/', '.')}_{position()}" name="metadata-{translate($name, '/', '.')}" class="ametys-checkbox__control" type="checkbox" value="{@value}" data-tags-control="">
                <xsl:if test="$value = @value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
            </input>
            <label class="ametys-checkbox__label" for="{$uniqueId}-metadata-{translate($name, '/', '.')}_{position()}"><xsl:value-of select="."/> (<xsl:value-of select="@count"/>)</label>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-field-enum-items">
        <xsl:param name="fieldName"/>
        <xsl:param name="moreIndex">5</xsl:param>
        
        <xsl:for-each select="/search/form/fields/metadata[@name = $fieldName]/enumeration/item">
             <xsl:sort select="."/>
             
             <xsl:if test="position() &lt;= $moreIndex">
                <xsl:call-template name="filter-field-enum-item"/>
             </xsl:if>
        </xsl:for-each>
        
        <xsl:if test="count(/search/form/fields/metadata[@name = $fieldName]/enumeration/item) &gt; $moreIndex">
            <div id="searchFilterItem_{$fieldName}__more" class="collapse">
                <xsl:for-each select="/search/form/fields/metadata[@name = $fieldName]/enumeration/item">
                    <xsl:sort select="."/>
                 
                    <xsl:if test="position() &gt; $moreIndex">
                        <xsl:call-template name="filter-field-enum-item"/>
                    </xsl:if>
                </xsl:for-each>
            </div>
            
            <xsl:call-template name="filter-field-show-more_items">
                <xsl:with-param name="targetId">#searchFilterItem_<xsl:value-of select="$fieldName"/>__more</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="filter-field-enum-item">
        <xsl:variable name="name" select="../@name"/>
        <xsl:variable name="value" select="/search/form/values/metadata/metadata[@name = $name]"/>
        
        <div class="ametys-checkbox">
            <input data-tags-value="{.}" id="{$uniqueId}-metadata-{translate($name, '/', '.')}_{position()}" name="metadata-{translate($name, '/', '.')}" class="ametys-checkbox__control" type="checkbox" value="{@value}" data-tags-control="">
                <xsl:if test="$value = @value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
            </input>
            <label class="ametys-checkbox__label" for="{$uniqueId}-metadata-{translate($name, '/', '.')}_{position()}"><xsl:value-of select="label"/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-field-show-more_items">
        <xsl:param name="targetId"/>
    
        <div class="text-right py-3">
            <button class="ametys-search-filter-show-more-invoker" type="button" aria-expanded="false"
                    data-toggle="collapse"
                    data-target="#{$targetId}"
                    data-close-text="skin.{$skin}:SKIN_ODF_SEARCH_SEE_ALL_CRITERIA"
                    data-open-text="skin.{$skin}:SKIN_ODF_SEARCH_SEE_LESS_CRITERIA"
                    i18n:attr="data-close-text data-open-text"
                    data-invoker="">
                <span class="ametys-search-filter-show-more-invoker__icon ametys-icon-angle-down"></span>
                <span data-invoker-text=""><i18n:text i18n:key="SKIN_ODF_SEARCH_SEE_ALL_CRITERIA" i18n:catalogue="skin.{$skin}"/></span>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-field-icon">
        <xsl:param name="fieldName"/>
        
        <xsl:variable name="icon">
            <xsl:choose>
                <xsl:when test="$fieldName='degree'">ametys-icon-graduation-cap</xsl:when>
                <xsl:when test="$fieldName='orgUnit'">fas fa-university</xsl:when>
                <xsl:when test="$fieldName='place'">fas fa-map-marker-alt</xsl:when>
                <xsl:when test="$fieldName='domain'">fas fa-star</xsl:when>
                <xsl:when test="$fieldName='level'">fas fa-sign-out-alt</xsl:when>
                <xsl:when test="$fieldName='educationLevel'">fas fa-sign-out-alt</xsl:when>
                <xsl:when test="$fieldName='educationEntryLevel'">fas fa-sign-out-alt</xsl:when>
                <xsl:when test="$fieldName='siseCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='dgesipCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='siseCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='cite97Code'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='rncpCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='erasmusCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='romeCode'">fas fa-hashtag</xsl:when>
                <xsl:when test="$fieldName='educationLanguage'">fas fa-flag-checkered</xsl:when>
                <xsl:when test="$fieldName='teachingLanguage'">fas fa-flag-checkered</xsl:when>
                <xsl:when test="$fieldName='internationalEducation'">ametys-icon-globe</xsl:when>
                <xsl:otherwise>fas fa-layer-group</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <span class="ametys-search-filter__item-icon {$icon}"></span>
    </xsl:template>
    
    <xsl:template name="search-content">
        <xsl:call-template name="form-result"/>
    </xsl:template>

    <xsl:template name="form-result">
        <div class="ametys-search-content">

            <a name="nav" />
            <form action="{$site-uri-prefix}/{/search/url}#nav" method="post" class="search-result">
                <div class="ametys-heading">
                     <xsl:choose>
                        <xsl:when test="hits/hit">
                                <xsl:call-template name="form-search-hidden" />
                                
                                 <xsl:call-template name="results-count"/>
                                 <xsl:call-template name="results-sort" />
                
                        </xsl:when>
                        <xsl:when test="/search/form/values and not(/search/illegal-textfield)">
                             <!-- Template for no result -->
                            <xsl:call-template name="no-result" />
                        </xsl:when>
                    </xsl:choose>
                </div>
            </form>
            
            <xsl:if test="hits/hit">
                <xsl:call-template name="hits" />
                <xsl:call-template name="pagination"/>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="no-result">
        <h2 class="ametys-heading__title">
            <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NO_RESULT" i18n:catalogue="plugin.odf-web"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="results-count">
        <h2 class="ametys-heading__title">
            <xsl:choose>
                <xsl:when test="not(/search/hits) or /search/hits/@total = '0'">Aucune formation</xsl:when>
                <xsl:when test="/search/hits/@total = '1'">1 formation</xsl:when>
                <xsl:otherwise><xsl:value-of select="/search/hits/@total"/> formations</xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>
    
    <xsl:template name="results-sort">
        <div class="ametys-heading__filter">
            <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY"/>
            
            <input type="hidden" id="sort-by-{$uniqueId}"/>
            <select class="ametys-heading__filter-control" onchange="_sortBy_{$uniqueId}(this)">
                <option value="sort-by-score">
                    <xsl:if test="/search/sort-by-score"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                    <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_SCORE"/>
                </option>
                <option value="sort-by-title_sort">
                    <xsl:if test="/search/sort-by-title_sort"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                    <i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_TITLE"/>
                </option>
            </select>
        </div>
        
        <script type="text/javascript">
            function _sortBy_<xsl:value-of select="$uniqueId"/>(select)
            {
                var form = $j(select).closest('form'),
                    val = $j(select).val(),
                    sortInput = $j("#sort-by-<xsl:value-of select="$uniqueId"/>");
                
                $j(sortInput).prop('name', val);
                
                form.submit();
                
                return;
            }
        </script>
    </xsl:template>
    
    <xsl:template name="hits">
        <xsl:if test="/search/hits/hit">
            <ul class="ametys-search-results" id="searchResults-{$uniqueId}" >
                <xsl:apply-templates select="/search/hits/hit"/>
            </ul>
            
            <script type="text/javascript">
                $('#searchResults-<xsl:value-of select="$uniqueId"/>').HSAmetysInvokerChangeText();
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit">
        <li class="ametys-search-results__item">
            <div class="ametys-search-results__item-body">
                <div class="ametys-search-results__item-body-content">
                
                    <xsl:call-template name="hit-title"/>
                    <xsl:call-template name="hit-header"/>
                    <xsl:call-template name="hit-excerpt"/>
                    <xsl:call-template name="hit-subprograms"/>
                    <!-- <xsl:call-template name="hit-actions"/> -->
                </div>
                
                <xsl:call-template name="hit-image"/>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-title">
        <h4 class="ametys-search-results__item-title">
            <a>
                <xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
                <xsl:value-of select="title"/>
            </a>
        </h4>
    </xsl:template>
    
    <xsl:template name="hit-header">
        <xsl:if test="content/domain or content/degree">
            <ul class="ametys-degree-list">
                <!-- Domain -->
                <xsl:if test="content/domain">
                    <li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="{$site-uri-prefix}/{/search/url}?submit-form={/search/group-id}&amp;metadata-domain={content/domain/@id}">
                            <span class="ametys-degree-list__item-icon ametys-icon-libra"></span>
                            <xsl:value-of select="content/domain/@title"/>
                        </a>
                    </li>
                </xsl:if>
                    
                <!-- Degree -->
                <xsl:if test="content/degree">
                    <li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="{$site-uri-prefix}/{/search/url}?submit-form={/search/group-id}&amp;metadata-degree={content/degree/@id}">
                            <span class="ametys-degree-list__item-icon ametys-icon-graduation-cap"></span>
                            <xsl:value-of select="content/degree/@title"/>
                        </a>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-excerpt">
        <p class="ametys-search-results__item-text"><xsl:value-of select="excerpt"/></p>
    </xsl:template>
    
    <xsl:template name="hit-subprograms">
        <xsl:if test="$displaySubProgram != 'none' and subprogram">
            <!-- TODO Handle @highlight -->
            <ul class="ametys-external-links-list">
                <xsl:for-each select="subprogram">
                    <li class="ametys-external-links-list__item">
                        <xsl:call-template name="hit-subprogram" />
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-subprogram">
        <a class="ametys-external-links-list__link">
            <xsl:attribute name="href">
                <xsl:call-template name="hit-href">
                    <xsl:with-param name="url" select="concat(../uri, '/', @path)"/>
                </xsl:call-template>
            </xsl:attribute>

            <xsl:value-of select="title"/>
        </a>
    </xsl:template>
    
    <xsl:template name="hit-image">
        <xsl:param name="imgHeight">290</xsl:param>
        <xsl:param name="imgWidth">480</xsl:param>
        
        <xsl:variable name="orgunitId" select="content/orgUnit/@id"/>
        
        <xsl:if test="$orgunitId != ''">
            <xsl:variable name="logoUrl">
                <xsl:call-template name="get-image-uri-from-attribute">
                    <xsl:with-param name="id" select="$orgunitId"/>
                    <xsl:with-param name="attributePath" select="'illustration/logo'"/>
                    <xsl:with-param name="height" select="$imgHeight"/>
                    <xsl:with-param name="width" select="$imgWidth"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:variable>
            
            <xsl:variable name="imgUrl">
                <xsl:call-template name="get-image-uri-from-attribute">
                    <xsl:with-param name="id" select="$orgunitId"/>
                    <xsl:with-param name="attributePath" select="'illustration/image'"/>
                    <xsl:with-param name="height" select="$imgHeight"/>
                    <xsl:with-param name="width" select="$imgWidth"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:variable>
            
            <xsl:variable name="imgSrc">
                <xsl:choose>
                    <xsl:when test="$logoUrl != ''"><xsl:value-of select="$logoUrl"/></xsl:when>
                    <xsl:when test="$imgUrl != ''"><xsl:value-of select="$imgUrl"/></xsl:when>
                </xsl:choose>
            </xsl:variable>  
        
            <xsl:if test="$imgSrc != ''">
                <div class="ametys-search-results__item-body-img-wrap">
                    <img class="ametys-search-results__item-body-img" src="{$imgSrc}" alt="{content/orgUnit/@title}"/>
                </div>
            </xsl:if>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="hit-actions">
         <ul class="ametys-summary-list">
            <xsl:call-template name="hit-action-save"/>
            <xsl:call-template name="hit-action-share"/>
            <xsl:call-template name="hit-action-download"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="hit-action-save">
        <li class="ametys-summary-list__item">
            <a class="ametys-summary-list__link" href="#">
                <span class="ametys-summary-list__item-icon fas fa-heart"></span>
                Sauvegarder
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-action-share">
        <li class="ametys-summary-list__item">
            <a class="ametys-summary-list__link" href="#">
                <span class="ametys-summary-list__item-icon fas fa-share"></span>
                Partager
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-action-download">
        <li class="ametys-summary-list__item">
            <a class="ametys-summary-list__link" href="#">
                <span class="ametys-summary-list__item-icon fas fa-cloud-download-alt"></span>
                Télécharger
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="pagination">
        <xsl:param name="current-start" select="/search/pagination/@start"/>
        <xsl:param name="current-page" select="xalan:nodeset(/search/pagination/page[@start = $current-start])"/>
        <xsl:param name="nbPages" select="count(/search/pagination/page)"/>
        
        <xsl:if test="$nbPages != 0">
            
            <xsl:call-template name="pagination-form"/>
            
            <xsl:call-template name="pagination-nav">
                <xsl:with-param name="current-start" select="$current-start"/>
                <xsl:with-param name="current-page" select="$current-page"/>
                <xsl:with-param name="nbPages" select="$nbPages"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="pagination-nav">
        <xsl:param name="current-start"/>
        <xsl:param name="current-page"/>
        <xsl:param name="nbPages"/>
        
        <nav class="ametys-pagination-wrap" aria-label="Page Navigation">
            <ul class="ametys-pagination">
            
                <!-- Previous -->
                <xsl:call-template name="pagination-previous-page">
                    <xsl:with-param name="current-page" select="$current-page"/>
                    <xsl:with-param name="nbPages" select="$nbPages"/>
                </xsl:call-template>
                
                <!-- Pages -->
                <xsl:for-each select="/search/pagination/page">
                    <xsl:call-template name="pagination-page">
                        <xsl:with-param name="current-start" select="$current-start"/>
                        <xsl:with-param name="current-page" select="$current-page"/>
                    </xsl:call-template>
                </xsl:for-each>
                
                <!-- Next -->
                <xsl:call-template name="pagination-next-page">
                    <xsl:with-param name="current-page" select="$current-page"/>
                    <xsl:with-param name="nbPages" select="$nbPages"/>
                </xsl:call-template>
            </ul>
    
            <xsl:call-template name="pagination-counter"/>
        </nav>
        
        <script type="text/javascript">
            function _loadPage_<xsl:value-of select="$uniqueId"/>(pageIndex)
            {
                var form = $j("#form-pagination-<xsl:value-of select="$uniqueId"/>");
                var pageInput = $j("#form-pagination-<xsl:value-of select="$uniqueId"/>-page");
                
                $j(pageInput).prop('name', 'page-' + pageIndex);
                
                form.submit();
                
                return;
            }
        </script>
    </xsl:template>
    
    <xsl:template name="pagination-page">
        <xsl:param name="current-start"/>
        <xsl:param name="current-page"/>
        
        <li class="ametys-pagination__item">
            <a class="ametys-pagination__link" href="javascript:void(0)">
                <xsl:choose>
                    <xsl:when test="@start = $current-start"><xsl:attribute name="class">ametys-pagination__link active</xsl:attribute></xsl:when>
                    <xsl:otherwise><xsl:attribute name="onclick">_loadPage_<xsl:value-of select="$uniqueId"/>(<xsl:value-of select="@index"/>)</xsl:attribute></xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="@index"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="pagination-previous-page">
        <xsl:param name="current-page"/>
        <xsl:param name="nbPages"/>
        
        <xsl:if test="$current-page/@index != 1">
            <xsl:variable name="previousPage" select="$current-page/preceding-sibling::page[1]/@index"/>
            
            <li class="ametys-pagination__item">
                <a class="ametys-pagination__arrow ametys-pagination__arrow_prev" href="javascript:void(0)" onclick="_loadPage_{$uniqueId}({$previousPage})"
                    aria-label="Previous">
                    <span class="fa fa-angle-left"></span>
                </a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="pagination-next-page">
        <xsl:param name="current-page"/>
        <xsl:param name="nbPages"/>
        
        <xsl:if test="$current-page/@index != $nbPages">
            <xsl:variable name="nextPage" select="$current-page/following-sibling::page[1]/@index"/>
            
            <li class="ametys-pagination__item">
                <a class="ametys-pagination__arrow ametys-pagination__arrow_next" href="javascript:void(0)" onclick="_loadPage_{$uniqueId}({$nextPage})" aria-label="Next">
                    <span class="fa fa-angle-right"></span>
                </a>
            </li>
        </xsl:if> 
    </xsl:template>
    
    <xsl:template name="pagination-counter">
        <div class="ametys-pagination-counter">
            <xsl:call-template name="common-utils-pagination-results">
                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_RESULTS'" />
                <xsl:with-param name="pagination-start" select="/search/pagination/@start + 1" />
                <xsl:with-param name="pagination-end" select="/search/pagination/@end" />
                <xsl:with-param name="hits-total" select="/search/hits/@total" />
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="pagination-form">
        <form id="form-pagination-{$uniqueId}" method="post" action="{$site-uri-prefix}/{/search/url}#nav" accept-charset="UTF-8">
            <xsl:call-template name="pagination-input-hidden"/>
            
            <input type="hidden" name="page-1" id="form-pagination-{$uniqueId}-page"/>
        </form>
    </xsl:template>
                                                        
</xsl:stylesheet>
