<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/results/search-results.xsl"/>
    
    <xsl:template name="facet-filter-header">
    	<xsl:param name="searchFilterItemId" />
    	
    	<button class="ametys-search-filter__item-control" type="button" aria-expanded="false"
		        data-toggle="collapse"
		        data-target="#{$searchFilterItemId}">
			<xsl:call-template name="facet-filter-icon"/>
			<xsl:value-of select="label"/>
			<span class="ametys-search-filter__item-control-icon ametys-icon-angle-down"></span>
		</button>
    </xsl:template>
    
    <xsl:template name="facet-filter-icon">
    	<span>
			<xsl:attribute name="class">
				<xsl:text>ametys-search-filter__item-icon </xsl:text>
	            <xsl:choose>
	                <xsl:when test="contains(@name, 'degree')">ametys-icon-graduation-cap</xsl:when>
	                <xsl:when test="contains(@name, 'orgUnit')">fas fa-university</xsl:when>
	                <xsl:when test="contains(@name, 'place')">fas fa-map-marker-alt</xsl:when>
                    <xsl:when test="contains(@name, 'campus')">fas fa-map-marker-alt</xsl:when>
	                <xsl:when test="contains(@name, 'domain')">fas fa-star</xsl:when>
	                <xsl:when test="contains(@name, 'level')">ametys-icon-sign-in</xsl:when>
	                <xsl:when test="contains(@name, 'educationLevel')">fas fa-sign-out-alt</xsl:when>
	                <xsl:when test="contains(@name, 'educationEntryLevel')">fas fa-sign-out-alt</xsl:when>
	                <xsl:when test="contains(@name, 'siseCode')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'dgesipCode')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'siseCode')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'cite97Code')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'rncpCode')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'erasmusCode')">fas fa-hashtag</xsl:when>
	                <xsl:when test="contains(@name, 'romeCode')">fas fa-hashtag</xsl:when>
                    <xsl:when test="contains(@name, 'timeSlot')">ametys-icon-clock</xsl:when>
	                <xsl:when test="contains(@name, 'educationLanguage')">fas fa-flag-checkered</xsl:when>
	                <xsl:when test="contains(@name, 'teachingLanguage')">fas fa-flag-checkered</xsl:when>
                    <xsl:when test="contains(@name, 'teachingTerm')">far fa-calendar-alt</xsl:when>
	                <xsl:when test="contains(@name, 'internationalEducation')">ametys-icon-globe</xsl:when>
	                <xsl:otherwise>fas fa-layer-group</xsl:otherwise>
	            </xsl:choose>
	        </xsl:attribute>
		</span>
    </xsl:template>
    
    <xsl:template name="facet-filter-elements">
    	<xsl:param name="searchFilterItemId" />
        <xsl:param name="moreIndex">5</xsl:param>
    	
        <xsl:variable name="facetPrefixId">
            <xsl:call-template name="facet-filter-element-prefix-id">
                <xsl:with-param name="facetName" select="@name"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:for-each select="item[@count > 0]">
            <xsl:sort select="@count" data-type="number" order="descending"/>
            
            <xsl:if test="position() &lt;= $moreIndex">
                <xsl:call-template name="facet-filter-element">
            	   <xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
                   <xsl:with-param name="facetPrefixId" select="$facetPrefixId"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>
        
        <xsl:if test="count(item[@count > 0]) > $moreIndex">
            <div id="{$searchFilterItemId}__more" class="collapse">
                <xsl:for-each select="item[@count > 0]">
                    <xsl:sort select="@count" data-type="number" order="descending"/>
                 
                    <xsl:if test="position() > $moreIndex">
                        <xsl:call-template name="facet-filter-element">
                    	   <xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
                           <xsl:with-param name="facetPrefixId" select="$facetPrefixId"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:for-each>
            </div>
            
            <xsl:call-template name="facet-filter-show-more_items">
                <xsl:with-param name="targetId"><xsl:value-of select="$searchFilterItemId"/>__more</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facet-filter-element-prefix-id">
        <xsl:param name="facetName"/>
        
        <xsl:variable name="facetId">
            <xsl:choose>
                <xsl:when test="contains($facetName, 'org.ametys.plugins.odf.Content.program$')"><xsl:value-of select="substring-after($facetName, 'org.ametys.plugins.odf.Content.program$')"/></xsl:when>
                <xsl:when test="contains($facetName, 'org.ametys.plugins.odf.Content.abstractProgram$')"><xsl:value-of select="substring-after($facetName, 'org.ametys.plugins.odf.Content.abstractProgram$')"/></xsl:when>
                <xsl:when test="contains($facetName, 'org.ametys.plugins.odf.Content.programItem$')"><xsl:value-of select="substring-after($facetName, 'org.ametys.plugins.odf.Content.programItem$')"/></xsl:when>
                <xsl:when test="contains($facetName, 'org.ametys.plugins.odf.Content.course$')"><xsl:value-of select="substring-after($facetName, 'org.ametys.plugins.odf.Content.course$')"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="generate-id()"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="concat('facet-', $facetId, '-')"/>
    </xsl:template>
    
    <xsl:template name="facet-filter-show-more_items">
        <xsl:param name="targetId"/>
    
        <div class="text-right py-3">
            <button class="ametys-search-filter-show-more-invoker" type="button" aria-expanded="false"
                    data-toggle="collapse"
                    data-target="#{$targetId}"
                    data-close-text="skin.{$skin}:SKIN_ODF_SEARCH_SEE_ALL_CRITERIA"
                    data-open-text="skin.{$skin}:SKIN_ODF_SEARCH_SEE_LESS_CRITERIA"
                    i18n:attr="data-close-text data-open-text"
                    data-invoker="">
                <span class="ametys-search-filter-show-more-invoker__icon ametys-icon-angle-down"></span>
                <span data-invoker-text=""><i18n:text i18n:key="SKIN_ODF_SEARCH_SEE_ALL_CRITERIA" i18n:catalogue="skin.{$skin}"/></span>
            </button>
        </div>
    </xsl:template>
	
	<xsl:template name="facet-filter-element">
		<xsl:param name="searchFilterItemId" />
        <xsl:param name="facetPrefixId">facet-</xsl:param>
        
        <xsl:variable name="id" select="concat($facetPrefixId, translate(@value, ':/', ''))"/>
		<div class="ametys-checkbox">
            <xsl:variable name="onclick"><xsl:call-template name="search-js-facet"/></xsl:variable>
			<input type="checkbox" name="{../@name}" value="{@value}" onclick="{$onclick}" id="{$id}" class="ametys-checkbox__control">
                <xsl:choose>
                    <xsl:when test="@selected = 'true'">
                        <xsl:attribute name="data-ametys-search-role">facet-selected</xsl:attribute>
                        <xsl:attribute name="checked">checked</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="data-ametys-search-role">facet-unselected</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </input>
			<label class="ametys-checkbox__label" for="{$id}"><xsl:value-of select="text()"/> (<xsl:value-of select="@count"/>)</label>
		</div>
    </xsl:template>
    
    <xsl:template name="results-count">
        <h2 class="ametys-heading__title">
            <xsl:choose>
                <xsl:when test="not(hits) or hits/@total = '0'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_NO_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:when test="hits/@total = '1'"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_ONE_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="hits/@total"/> <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAMS_RESULTS" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>
    
    <xsl:template name="results-sort">
		<xsl:if test="count(/search/form/sorts/sort) > 0">		
			<div class="ametys-heading__filter">
				<i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_SORT_BY" i18n:catalogue="plugin.web"/>
				<select class="ametys-heading__filter-control" name="sort">
					<xsl:attribute name="onchange">eval("function a(){" + this.options[this.selectedIndex].getAttribute('onselect') + "}"); try { a.call(this); } catch(e) { }; return true;</xsl:attribute>
					
					<xsl:call-template name="results-sort-opts"/>
				</select>
                <xsl:call-template name="current-sort"/>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="results-sort-opts">
		<xsl:for-each select="/search/form/sorts/sort">
			<option value="{@name}">
				<xsl:attribute name="onselect"><xsl:call-template name="search-js-sort"/></xsl:attribute>
				<xsl:if test="@selected"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                
				<xsl:value-of select="label"/>
			</option>
		</xsl:for-each>
	</xsl:template>
    
    <xsl:template name="current-sort">
        <!-- Hidden inputs with current sort(s), required to keep sort when selecting a facet or pagination -->
        <xsl:for-each select="/search/form/sorts/sort[@selected]">
            <xsl:call-template name="sort-hidden-input-for-selected"/>
        </xsl:for-each>
    </xsl:template>
	
    <xsl:template name="search-results">
    	<div class="ametys-search-content">
        	<xsl:call-template name="form-criteria-hidden"/>
        
	        <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
	            <xsl:call-template name="back-button"/>
	        </xsl:if>
	        
	        <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
	            <xsl:call-template name="form-result"/>
	            <xsl:call-template name="form-result-js"/>
	        </xsl:if>
	        
	        <xsl:choose>
	            <xsl:when test="/search/hits/hit">
		            <xsl:call-template name="hits"/>
	                <xsl:call-template name="pagination"/>
	            </xsl:when>
	            <xsl:otherwise>
	                <xsl:if test="/search/hits">
	                    <!-- hits is present but no single hit => there is no result -->
		                <xsl:call-template name="no-result"/>
	                </xsl:if>
	            </xsl:otherwise>
	        </xsl:choose>
	    </div>
    </xsl:template>
    
    <xsl:template name="form-result">
         <xsl:if test="/search/hits/hit">
			<div class="ametys-heading d-none d-md-flex">
                <xsl:call-template name="results-count"/>
	           	<xsl:call-template name="results-sort"/>
	        </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="hits">
    	<ul id="searchResults" data-ametys-search-role="hits" class="ametys-search-results list-unstyled">
    		<xsl:for-each select="/search/hits/hit">
    			<xsl:apply-templates select="."/>
    		</xsl:for-each>
		</ul>
        
        <script type="text/javascript">
            $('#searchResults').HSAmetysInvokerChangeText();
        </script>
    </xsl:template>
    
    <!-- Programs -->
	<xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']">
		<li class="ametys-search-results__item">
			<div class="ametys-search-results__item-content">
				<div class="ametys-search-results__item-body">
					<div class="ametys-search-results__item-body-content">
                        <xsl:call-template name="hit-title"/>
                        <xsl:apply-templates select="." mode="header"/>
                        
                        <xsl:apply-templates select="." mode="abstract"/>
					    
                        <xsl:call-template name="hit-subprograms"/>
                        
                        <xsl:if test="$displaySubProgram != 'all_with_highlight' or not(subprogram[@highlight = 'false'])">
                            <xsl:call-template name="hit-actions"/>
                        </xsl:if>
					</div>
					
                    <xsl:apply-templates select="." mode="image"/>
				</div>
					
                <xsl:if test="$displaySubProgram = 'all_with_highlight' and subprogram[@highlight = 'false']">
                    <xsl:call-template name="hit-subprograms-others"/>
                    <xsl:call-template name="hit-actions-footer"/>
                </xsl:if>
			</div>
		</li>
	</xsl:template>
    
    <xsl:template name="hit-title">
        <h4 class="ametys-search-results__item-title">
            <xsl:choose>
                <xsl:when test="not(uri)">
                    <xsl:value-of select="title"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." mode="title-link"/>
                </xsl:otherwise>
            </xsl:choose>
        </h4>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="header">
        <xsl:if test="content/domain or content/degree">
            <ul class="ametys-degree-list">
                <xsl:call-template name="hit-domain"/>
                <xsl:call-template name="hit-degree"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="hit-domain">
        <xsl:if test="content/domain">
            <xsl:for-each select="content/domain">
        		<li class="ametys-degree-list__item">
                        <a class="ametys-degree-list__link" href="javascript:void(0)">
                            <xsl:attribute name="onclick">
                                if (!$('#<xsl:value-of select="concat('facet-domain-', translate(@id, ':/', ''))"/>').prop("checked")) $('#<xsl:value-of select="concat('facet-domain-', translate(@id, ':/', ''))"/>').click();
                            </xsl:attribute>
                            <xsl:call-template name="hit-domain-icon"/>
                            <xsl:value-of select="@title"/>
                        </a>
        		</li>
            </xsl:for-each>
        </xsl:if>
	</xsl:template>

    <xsl:template name="hit-domain-icon">
        <xsl:param name="id" select="@id"/>
        <xsl:variable name="code" select="ametys:contentAttribute($id, 'code')"/>
        
        <span>
            <xsl:attribute name="class">
                <xsl:text>ametys-degree-list__item-icon </xsl:text>
                <xsl:choose>
                    <xsl:when test="contains($code, 'DEG')">ametys-icon-libra</xsl:when>
                    <!-- TODO others icon ? -->
                    <xsl:otherwise>fas fa-layer-group</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
        </span>
    </xsl:template>
	
	<xsl:template name="hit-degree">
        <xsl:if test="content/degree">
    		<li class="ametys-degree-list__item">
    			<a class="ametys-degree-list__link" href="javascript:void(0)">
    				<xsl:attribute name="onclick">
    					if (!$('#<xsl:value-of select="concat('facet-degree-', translate(content/degree/@id, ':/', ''))"/>').prop("checked")) $('#<xsl:value-of select="concat('facet-degree-', translate(content/degree/@id, ':/', ''))"/>').click();
    				</xsl:attribute>
    				<span class="ametys-degree-list__item-icon ametys-icon-graduation-cap"></span>
    				<xsl:value-of select="content/degree/@title"/>
    			</a>
    		</li>
        </xsl:if>
	</xsl:template>
    
	<xsl:template name="hit-actions">
		<ul class="ametys-summary-list">
            <xsl:call-template name="hit-action-save"/>
            <!-- xsl:call-template name="hit-action-share"/-->
			<xsl:call-template name="hit-action-download"/>
		</ul>
	</xsl:template>
    
    <xsl:template name="hit-actions-footer">
        <div class="ametys-search-results__item-footer">
            <xsl:call-template name="hit-actions"/>
        </div>
    </xsl:template>
    
	
	<xsl:template name="hit-action-save">
        <xsl:param name="addTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_ADD')"/>
        <xsl:param name="removeTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_DELETE')"/>
        
		<li class="ametys-summary-list__item">
            <a href="#" id="save-{generate-id()}" class="ametys-summary-list__link"
               data-tf-is-in-wishlist="out"
               data-tf-default-text="{$addTextKey}"
               data-tf-active-text="{$removeTextKey}"
               data-tf-default-icon="fas fa-heart"
               data-tf-active-icon="fas fa-heart"
               i18n:attr="data-tf-default-text data-tf-active-text">
                <span class="ametys-summary-list__item-icon fas fa-heart" data-tf-icon="data-tf-icon"></span>
                <span data-tf-text="data-tf-text"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_CART_ADD" i18n:catalogue="skin.{$skin}"/></span>
            </a>
            
            <script>
                function _updateLink<xsl:value-of select="generate-id()"/>(answer)
                {
                    $j.HSCore.components.HSToggleFavorite.init('#save-<xsl:value-of select="generate-id()"/>', {
                        isInWishList: answer,
                        itemId: "<xsl:value-of select="id"/>",
                        itemTitle: "<xsl:value-of select="escaper:escapeJavaScript(title)"/>",
                        callback: ODFCart.emptyCallback
                    });
                }
                
                ODFCart.hasItem('<xsl:value-of select="id"/>', _updateLink<xsl:value-of select="generate-id()"/>);
            </script>
		</li>
	</xsl:template>
	
	<xsl:template name="hit-action-share">
		<li class="ametys-summary-list__item">
			<a class="ametys-summary-list__link" href="#TODO">
				<span class="ametys-summary-list__item-icon fas fa-share"></span>
				<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAM_SHARE" i18n:catalogue="skin.{$skin}"/>
			</a>
		</li>
	</xsl:template>
	
	<xsl:template name="hit-action-download">
		<li class="ametys-summary-list__item">
			<xsl:variable name="odf-content-id" select="content/@id"/>
            <xsl:variable name="odf-content-name" select="content/@name"/>
            
	        <xsl:variable name="pdfHref" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', $odf-content-name, '/', filename:filterName(title), '.pdf')"/>
	        <a class="ametys-summary-list__link" href="{url:encodePath($pdfHref)}">
	        	<span class="ametys-summary-list__item-icon fas fa-cloud-download-alt"></span>
				<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_PROGRAM_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
	        </a>
        </li>
	</xsl:template>
	
	<xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="abstract">
		<xsl:if test="excerpt">
            <p class="ametys-search-results__item-text">
                <xsl:value-of select="excerpt"/>
            </p>
        </xsl:if>
	</xsl:template>
    
	<xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.ProgramSaxer']" mode="image">
		<xsl:variable name="imgSrc">
            <xsl:call-template name="program-image-url">
                <xsl:with-param name="contentId" select="id"/>
                <xsl:with-param name="maxHeight">290</xsl:with-param>
                <xsl:with-param name="maxWidth">480</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        
        <div class="ametys-search-results__item-body-img-wrap">
            <img class="ametys-search-results__item-body-img"  src="{$imgSrc}" alt="" />
        </div>
    </xsl:template>
    
    <xsl:template name="hit-subprograms">
        <xsl:if test="$displaySubProgram != 'none' and subprogram">
            <xsl:if test="subprogram[not(@highlight) or @highlight = 'true']">
                <ul class="ametys-external-links-list">
                    <xsl:for-each select="subprogram[not(@highlight) or @highlight = 'true']">
                        <xsl:call-template name="hit-subprogram" />
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
   <xsl:template name="hit-subprograms-others">                                                     
        <div class="ametys-hidden-content">
        	<div id="searchResultsHiddenContent-{generate-id()}" class="collapse">
                <ul class="ametys-external-links-list">
                    <xsl:for-each select="subprogram[@highlight = 'false']">
                       <xsl:call-template name="hit-subprogram" />
                    </xsl:for-each>
                </ul>
            </div>
            <xsl:call-template name="hit-subprograms-others-button"/>
		</div>
    </xsl:template>
    
    <xsl:template name="hit-subprograms-others-button">
    	<div class="text-center">
			<button class="ametys-hidden-content-invoker" type="button" aria-expanded="false"
			        data-toggle="collapse"
			        data-target="#searchResultsHiddenContent-{generate-id()}"
			        data-invoker=""
                    i18n:attr="data-close-text data-open-text">
			        <xsl:attribute name="data-close-text">
			        	<xsl:choose>
							<xsl:when test="subprogram[@highlight = 'true']">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_OTHERS</xsl:when>
							<xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_ALL</xsl:otherwise>
						</xsl:choose>
			        </xsl:attribute>
			        <xsl:attribute name="data-open-text">
			        	<xsl:choose>
							<xsl:when test="subprogram[@highlight = 'true']">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_HIDE_OTHERS</xsl:when>
							<xsl:otherwise>skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_HIDE_ALL</xsl:otherwise>
						</xsl:choose>
			        </xsl:attribute>
				<span class="ametys-hidden-content-invoker__icon ametys-icon-angle-down"></span>
				<span data-invoker-text="">
					<xsl:choose>
						<xsl:when test="subprogram[@highlight = 'true']">
							<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_OTHERS" i18n:catalogue="skin.{$skin}"/>
						</xsl:when>
						<xsl:otherwise>
							<i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_NOT_MATCHING_SUBPROGRAM_SHOW_ALL" i18n:catalogue="skin.{$skin}"/>
						</xsl:otherwise>
					</xsl:choose>
				</span>
			</button>
		</div>
    </xsl:template>
    
    <xsl:template name="hit-subprogram">
    	<li class="ametys-external-links-list__item">
            <xsl:choose>
                <xsl:when test="not(../uri)">
                    <span class="ametys-external-links-list__link-text"><xsl:value-of select="@title"/></span>
                </xsl:when>
                <xsl:otherwise>
                    <a class="ametys-external-links-list__link">
                        <xsl:attribute name="href">
                            <xsl:call-template name="hit-href">
                                <xsl:with-param name="url" select="concat(../uri, @path)"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <span class="ametys-external-links-list__link-text"><xsl:value-of select="@title"/></span>
                     </a>
                </xsl:otherwise>
            </xsl:choose>
	         
	     </li>
    </xsl:template>
    
</xsl:stylesheet>