<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms">
    
    
    <!-- Skills fieldset -->
    <xsl:template match="fieldset[@name = 'skills']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:variable name="skills" select="odf:getCurrentSkills()"/>
        <xsl:if test="count($skills) != '0'">
            <fo:block xsl:use-attribute-sets="fieldset-title">
                <fo:block xsl:use-attribute-sets="fieldset-title-body">
                    <xsl:value-of select="label"/>
                </fo:block>
            </fo:block>
                    
            <xsl:apply-templates select="fieldset|metadata" mode="display">
                <xsl:with-param name="skills" select="$skills" />
            </xsl:apply-templates> 
        </xsl:if>
    </xsl:template>
    
    <!-- Compétences acquises -->
    <xsl:template match="metadata[@name = 'acquiredMicroSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="skills"/>
        
        <fo:block>
            <fo:block xsl:use-attribute-sets="section-title">
                Compétences acquises
            </fo:block>
            
            <xsl:apply-templates select="metadata" mode="display"/> 
        </fo:block>
        
        <fo:table table-layout="fixed" margin-top="5mm" padding="0pt" >
            <xsl:call-template name="skills-table-style"/>
            
            <fo:table-column column-width="40%"/>
            <fo:table-column/>
            <fo:table-body>
                <xsl:call-template name="skills-table-header"/>
                
                <xsl:for-each select="$skills[@type='MACROSKILL']">
                <fo:table-row>
                    <fo:table-cell>
                        <xsl:call-template name="skills-td-style"/>
                        <fo:block>
                        <xsl:value-of select="@title"/>
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                    <xsl:for-each select="$skills[@type='MICROSKILL' and @parent=current()/@id]">
                        <fo:block>
                        <xsl:call-template name="skills-td-style"/>
                        <xsl:value-of select="@title"/>
                        </fo:block>
                    </xsl:for-each>
                    </fo:table-cell>
                </fo:table-row>
                </xsl:for-each>
            </fo:table-body>
        </fo:table>
    </xsl:template>
    
    <xsl:template name="skills-table-header">
        <fo:table-row>
            <fo:table-cell>
                <xsl:call-template name="skills-th-style"/>
                <fo:block>Macro-compétence</fo:block>
            </fo:table-cell>
            <fo:table-cell>
                <xsl:call-template name="skills-th-style"/>
                <fo:block>Micro-compétences</fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
</xsl:stylesheet>
