<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">

    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/zones.xsl" />
    <xsl:import href="skin://stylesheets/menus.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl"/>
    <xsl:import href="skin://stylesheets/footer.xsl"/>
    <xsl:import href="skin://stylesheets/others.xsl"/>
    <xsl:import href="skin://stylesheets/svg.xsl"/>

    <xsl:variable name="sitemap" select="/cms/inputData/sitemap" />
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')" />

    <xsl:variable name="odfSearchPage" select="ametys:findPagesIdsByTag('SEARCH_ODF')"/>
    <xsl:variable name="odfSearchPageUri">
        <xsl:choose>
            <xsl:when test="$odfSearchPage"><xsl:value-of select="resolver:resolve('page', $odfSearchPage/@id)"/></xsl:when>
            <xsl:otherwise>#</xsl:otherwise>
        </xsl:choose>
    </xsl:variable> 
    
	<!-- + | BASE + -->
	<xsl:template name="template">
		<html>
			<xsl:call-template name="head" />
            <xsl:call-template name="body" />
		</html>
	</xsl:template>
    
    <xsl:template name="body">
        <body>
            <xsl:call-template name="header"/>
            
            <main class="ametys-main">
                
                <xsl:call-template name="main-banner"/>
                
                <xsl:call-template name="main-content"/>
            </main>
            
            <xsl:call-template name="footer"/>
        </body>
    </xsl:template>
    
    <xsl:template name="main-banner"/>
    
    <xsl:template name="main-content"/>

</xsl:stylesheet>
