<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="ametys escape math user resolver exslt">
                
    
    <xsl:import href="plugin:workspaces://pages/services/search/search.xsl"/>
    
    <!-- Max number of categories displayed before a "See more" button appears -->    
    <xsl:variable name="moreThreshold" select="5"/>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-js"/>

        <script type="text/javascript">
        
            function showResultAdditionCallbackByModule_<xsl:value-of select="$uniqueId"/>(data, moduleId, hits)
            {
                let $search = $j('#modular-search-<xsl:value-of select="$uniqueId"/>');
                
                let count = Number(hits.attr("total"));
                let minLimit = Number(hits.attr("minLimit"));
                
                let $showMore = $search.find('[data-results-show-more="' + moduleId + '"]');
                if (count > minLimit)
                {
                    $showMore.show();
                }
                else
                {
                    $showMore.hide();
                }
            }
            
            function showResultAdditionCallback_<xsl:value-of select="$uniqueId"/>(data, firstLoad) 
            {
                let $search = $j('#modular-search-<xsl:value-of select="$uniqueId"/>');
                
                if (firstLoad)
                {
                    // Update other tabs counter
                    var count = 0;
                    $search.find('[data-other-tabs] ul *[data-results-count]').each(function(i, s) { count += parseInt($j(s).html()) })
                    $search.find('*[data-results-count="others"]').html(count);
                    
                    if (count == 0)
                    {
                        $search.find('[data-other-tabs]').closest('li').addClass('disabled');
                    }
                    else
                    {
                        $search.find('[data-other-tabs]').closest('li').removeClass('disabled');
                    }
                    
                    let $activeTab = $search.find('.ametys-filter-categories-btn.active');
                    let currentCount = Number($activeTab.find('[data-results-count]').html());
                    if (currentCount == 0)
                    {
                        // Active "All" tab
                        $activeTab.removeClass("active");
                        
                        let totalCount = $search.find('[data-results-count=all]').html();
                        if (totalCount != 0)
                        {
                            $search.find('[data-results-count=all]').closest('a.ametys-filter-categories-btn').click();
                        }
                        
                    }
                    
                }
                
                // Truncate text
                $search.find('.ametys-truncate').each(function (i, el) {
                    var lines = navigator.userAgent.toLowerCase().indexOf('firefox') > -1 ? $j(el).data('lines') + 1 : $j(el).data('lines');
        
                    $j(el).truncate({
                        lines: lines
                    });
                });
            }
        </script>
        
    	<script src="{ametys:skinURL('templates/common/plugins/truncate.js/truncate.js')}"/>
   		<script src="{ametys:skinURL('templates/common/js/popper.min.js')}"></script>
    	<script src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.min.js')}"></script>
    	<script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
        
        <xsl:call-template name="search-service-tracking-js" />
        
        <script>
            // FIXME https://jquery.com/upgrade-guide/3.5/
            // Required since 3.7.1 jquery upgrade 
            $j.migrateEnablePatches( "self-closed-tags" );
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
    	<!-- Vendors Styles-->
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.min.css')}" />
		
        <!-- filter styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/print.css')}" />
		<!-- END::filter styles -->
        
        <!-- custom control styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/print.css')}" />
        <!-- END::custom control styles -->
		
		<!-- membres styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/membres/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/membres/scss/print.css')}" />
		<!-- END::membres styles -->
		
		<!-- search styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/search/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/search/scss/print.css')}" />
		<!-- END::search styles -->
		
		<!-- user styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/user/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/user/scss/print.css')}" />
		<!-- END::user styles -->
		
		<!-- contacts styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/contacts/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/contacts/scss/print.css')}" />
		<!-- END::contacts styles -->
		
		<!-- document styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/print.css')}" />
		<!-- END::document styles -->
		
		<!-- schedule styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/schedule/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/schedule/scss/print.css')}" />
		<!-- END::schedule styles -->
		
		<!-- event styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/event/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/event/scss/print.css')}" />
		<!-- END::event styles -->
		
		<style>
			.ametys-truncate {
				display: flex;
			}
		</style>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="modular-search-{$uniqueId}">
            <xsl:call-template name="search-header"/>
            <xsl:call-template name="modules-header"/>
			<xsl:call-template name="modules-content"/>
        </div>
    </xsl:template>
    
    <xsl:template name="search-header">
        <div class="ametys-filter">
            <div class="ametys-filter-header">
                <xsl:call-template name="results-count"/>
                <xsl:call-template name="filter-toolbar" />
            </div>
            <xsl:call-template name="filters" />
        </div>
    </xsl:template>
    
	<xsl:template name="results-count">
		<div class="ametys-filter-header-title" data-search-total-results="true">
            <span data-search-total-results-count="true"></span>
            <xsl:text> </xsl:text>
            <i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_RESULTS"/>
            
            <span data-search-textfield="true" style="display:none">
               <i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_RESULTS_FOR"/><strong data-search-textfield-value="true"><xsl:value-of select="/search/filters/textfield"/></strong>
            </span>        
        </div>
    </xsl:template>
    
    <xsl:template name="filters">
        <div id="filter_advanced" class="collapse">
			<form method="POST" action="" data-search-form="true">
				<div class="pt-4">
					<div class="row">
						<xsl:call-template name="keywords-filter"/>
			            <xsl:call-template name="categories-filter"/>
			            <xsl:call-template name="projects-filter"/>
			            <script>
                            let hasActiveFilters = <xsl:value-of select="count(/search/filters/*)"/> != 0;
                            if (hasActiveFilters)
                            {
                                $j('#filter_advanced').collapse('show');
                            }
                            
							$j('#filter_advanced').on('hide.bs.collapse', function () {
								$j('#filter_advanced .ametys-form-control-limit-wrap').removeClass('ametys-form-control-limit-wrap-off');
							});
							
							$j('#filter_advanced').on('shown.bs.collapse', function () {
								$j('#filter_advanced .ametys-form-control-limit-wrap').addClass('ametys-form-control-limit-wrap-off');
							});
						</script>
				    </div>
				</div>
			</form>
		</div>
    </xsl:template>
    
    <xsl:template name="filter-toolbar">
        <div class="ametys-filter-header-toolbar">
            <div class="ametys-filter-header-toolbar__item">
                <button class="ametys-filter-btn" type="button" role="button" aria-expanded="false"
                    data-toggle="collapse" data-target="#filter_advanced">
                    <i class="ametys-filter-btn__icon material-icons">filter_list</i>
                    <i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_FILTERS" i18n:catalogue="skin.{$skin}" />
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="keywords-filter">
        <div class="col-lg-4">
            <div class="ametys-form-group mb-lg-0">
                <label><i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_FILTERS" i18n:catalogue="skin.{$skin}"/></label>
                <div class="ametys-input-group">
                    <div class="ametys-input-group__prepend">
                        <div class="ametys-input-group__text">
                            <i class="material-icons">search</i>
                        </div>
                    </div>
                    <input class="ametys-form-control" type="text" placeholder="skin.{$skin}:SKIN_SERVICE_SEARCH_TEXTFIELD_PLACEHOLDER" i18n:attr="placeholder" name="textfield" value="{/search/filters/textfield}"/>
                </div>
            </div>
        </div>
        <script type="text/javascript">
            $j('#modular-search-<xsl:value-of select="$uniqueId"/> input[name=textfield]').keyup(function(e){
                if (e.key === 'Enter' || e.keyCode === 13) {
                    doSearch_<xsl:value-of select="$uniqueId"/>(true);
                }
            });
        </script>
	</xsl:template>
	
	<xsl:template name="projects-filter">
        <div class="col-lg-4">
            <div class="ametys-form-group mb-0">
                <label><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_FILTER_PROJECTS" /></label>
                <div class="ametys-form-control-limit-wrap">
                    <select name="project" onchange="doSearch_{$uniqueId}(true)" class="selectpicker ametys-form-control" title="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT" multiple="multiple"
                                    data-select-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_ALL"
                                    data-deselect-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_UNSELECT_ALL"
                                    data-none-results-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_NO_RESULT"
                                    i18n:attr="title data-select-all-text data-deselect-all-text data-none-results-text"
                                    data-actions-box="true"
                                    data-live-search="true">
                          <xsl:for-each select="/search/projects/project">
                              <xsl:sort select="title"/>
                              <option value="{@name}" data-tokens="{@name}">
                                <xsl:if test="/search/filters/project = @name"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                <xsl:value-of select="."/>
                              </option>        
                          </xsl:for-each>
                    </select>
                </div>
            </div>
        </div>
    </xsl:template>
    
	<xsl:template name="categories-filter">
        <div class="col-lg-4">
            <div class="ametys-form-group mb-lg-0">
                <label><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_FILTER_CATEGORIES" /></label>
                <div class="ametys-form-control-limit-wrap">
                    <select name="category" onchange="doSearch_{$uniqueId}(true)" class="selectpicker ametys-form-control" title="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT" multiple="multiple"
                                    data-select-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_ALL"
                                    data-deselect-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_UNSELECT_ALL"
                                    data-none-results-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_NO_RESULT"
                                    i18n:attr="title data-select-all-text data-deselect-all-text data-none-results-text"
                                    data-actions-box="true">
                         <xsl:for-each select="/search/categories/category">
                            <xsl:sort select="title"/>
                            <option value="{@name}" data-tokens="{@name}">
                                <xsl:if test="/search/filters/category = @name"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
                                <xsl:value-of select="title"/>
                            </option>        
                        </xsl:for-each>
                    </select>
                </div>
            </div>
        </div>
    </xsl:template>
    
	<xsl:template name="modules-header">
		<div id="categories_scroll" class="ametys-scroll-via-btn">
			<div class="ametys-filter-categories-wrap">
		    	<ul class="ametys-filter-categories">
		    		<li data-results-tab-head="all">
						<a class="ametys-filter-categories-btn ametys-hide-show-invoker active" href="#tab-all" data-group="tabs-outside">
							<i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_TAB_ALL" /> (<span data-results-count="all"></span>)
						</a>
					</li>
		    		<xsl:apply-templates select="/search/modules/module[position() &lt; $moreThreshold]" mode="tab-head">
		                <xsl:sort select="@order" data-type="number"/>
		            </xsl:apply-templates>
		            <xsl:if test="/search/modules/module[position() &gt;= $moreThreshold]">
			            <li>
							<div class="ametys-dropdown dropdown" data-other-tabs="true">
								<a class="ametys-filter-categories-btn" href="javascript:;" aria-haspopup="true" aria-expanded="false"
									 data-toggle="dropdown"
									 data-boundary="window">
									<i class="fas fa-ellipsis-v"></i>
									<i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_OTHER" i18n:catalogue="skin.{$skin}"/> 
									(<span data-results-count="others">0</span>) 
								</a>
								<div class="ametys-dropdown-content dropdown-menu">
									<ul class="ametys-dropdown__menu">
										<xsl:apply-templates select="/search/modules/module[position() &gt;= $moreThreshold]" mode="tab-head">
							                <xsl:sort select="@order" data-type="number"/>
							            </xsl:apply-templates>
									</ul>
								</div>
							</div>
						</li>
					</xsl:if>
				</ul>
			</div>
			<script>
				$j('#categories_scroll .ametys-dropdown .ametys-hide-show-invoker').on('click', function () {
					var $this = $j(this),
							text = $this.html(),
							href = $this.attr('href'),
							
							$target = $this.closest('.ametys-dropdown')
									.closest('li')
									.prev()
									.find('.ametys-hide-show-invoker'),
							targetText = $target.html(),
							targetHref = $target.attr('href');
					
					setTimeout(function() {
						$this.attr('href', targetHref);
						$this.html(targetText);
						$this.removeClass('active');
						
						$target.attr('href', href);
						$target.html(text);
						$target.addClass('active');
					});
				});
			</script>
			<button type="button"
							data-btn-right="">
				<i class="fas fa-angle-right"></i>
			</button>
			<button type="button"
							data-btn-left="">
				<i class="fas fa-angle-left"></i>
			</button>
		</div>
		<script>
			var currentLeft,
					$target = $j('#categories_scroll .ametys-filter-categories-wrap');
			
			$j('#categories_scroll [data-btn-right]').on('click', function () {
				currentLeft = $target.scrollLeft();
				$target.stop()
						.animate({
							scrollLeft: currentLeft + 200
						}, 400);
			});
			
			$j('#categories_scroll [data-btn-left]').on('click', function () {
				currentLeft = $target.scrollLeft();
				$target.stop()
						.animate({
							scrollLeft: currentLeft - 200
						}, 400);
			});
		</script>
	</xsl:template>
	
	<xsl:template match="module" mode="tab-head">
		<xsl:variable name="anchor" select="substring-after(substring-before(@url, '.xml'), 'module/')"/>
		
		<li data-results-tab-head="{@id}">
			<a class="ametys-filter-categories-btn ametys-hide-show-invoker" href="#tab-{$anchor}" data-group="tabs-outside">
				<xsl:value-of select="title"/> (<span data-results-count="{@id}">0</span>)
			</a>
		</li>
	</xsl:template>
	
	<xsl:template name="modules-content">
        <div class="tab-content">
            <xsl:call-template name="tab-all"/>
            
            <xsl:apply-templates select="/search/modules/module" mode="tab-content">
                <xsl:sort select="@order" data-type="number"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>  
    
    <xsl:template name="tab-all">
        <div id="tab-all" class="ametys-hide-show-target" style="display: block;" data-group="tabs-outside">
		    <xsl:apply-templates select="/search/modules/module" mode="tab-all"/>
        </div>
    </xsl:template>
    
     <xsl:template match="module" mode="tab-all">
        <div class="ametys-search" data-results-tab-all="{@id}">
            <div class="ametys-search-header">
                <div class="ametys-search-header-title">
                	<xsl:value-of select="title"/>
                </div>
                <div class="ametys-search-header-infobar" data-results-show-more="{@id}">
					<div class="ametys-search-header-infobar__item">
						<xsl:variable name="anchor" select="substring-after(substring-before(@url, '.xml'), 'module/')"/>
		
						<a class="ametys-hide-show-invoker" href="#tab-{$anchor}"
							 data-group="tabs-outside">
							 <i18n:text i18n:key="SKIN_SERVICE_SEARCH_SEE_MORE" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text><span data-results-count="{@id}">0</span><xsl:text> </xsl:text><span style="text-transform:lowercase"><xsl:value-of select="title"/></span>
						</a>
					</div>
				</div>
            </div>
            <ul class="ametys-search-results" data-search-all-results="{@id}">
                <!-- Here the search results will be loaded -->
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="module" mode="tab-content">
    	<xsl:variable name="anchor" select="substring-after(substring-before(@url, '.xml'), 'module/')"/>
    	
        <div id="tab-{$anchor}" class="ametys-hide-show-target" style="display: none;" data-group="tabs-outside">
            <div class="ametys-search" data-results-tab-content="{@id}">
                <div class="ametys-search-header">
                	<div class="ametys-search-header-title">
                		<xsl:value-of select="title"/>
                	</div>
                </div>
                <ul class="ametys-search-list" data-search-results="{@id}">
                    <!-- Here the search results will be loaded -->
                </ul>
            </div>
            
            <div data-search-next-results="{@id}"/>
            
            <xsl:call-template name="load-more"/>
        </div>
    </xsl:template>  
    
    <xsl:template name="load-more">
    	<div class="text-center mt-5">
    		<input data-search-offset="{@id}" type="hidden" value="{@limit}"/>
			<button class="ametys-btn-load-more" type="button" data-search-more-button="{@id}" onclick="loadMore_{$uniqueId}('{@id}')">
				<i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_LOAD_MORE_RESULTS" />
			</button>
		</div>
    </xsl:template>
    
</xsl:stylesheet>