<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                extension-element-prefixes="math ametys resolver escaper">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="is-empty" select="not(/suggestions/project)" />  
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/side-suggestions/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/side-suggestions/scss/print.css')}" />
    </xsl:template>
    
     <xsl:template name="common-service-head-js">
        <xsl:call-template name="suggestion-js"/>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">projects-suggestions</xsl:variable>
    <xsl:variable name="common-service-name">projects-suggestions</xsl:variable>   
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="suggestion-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/Project.', ametys:lang(), '.js'))}"></script>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-sidebar-section">
            <h2 class="ametys-sidebar-section__title"><xsl:value-of select="$header"/></h2>
            
            <ul class="ametys-side-suggestions__list">
                <xsl:apply-templates select="/suggestions/project"/>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="project">
        <xsl:variable name="onclick">
            <xsl:choose>
                <xsl:when test="inscriptionStatus = 'MODERATED'">Project.askToJoin('<xsl:value-of select="@id"/>'); return false;</xsl:when>
                <xsl:otherwise>Project.join('<xsl:value-of select="@id"/>'); return false;</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <li>
            <a href="javascript:;" onclick="{$onclick}" class="ametys-side-suggestions__list_img d-block">
                <xsl:apply-templates select="." mode="illustration"/>
                <span class="ametys-tag ametys-tag--sm" style="color: #FFF; background-color: {category/@color}"><xsl:value-of select="category"/></span>
            </a>
            <h3 class="ametys-side-suggestions__list_title"><xsl:value-of select="title"/></h3>
            <a href="javascript:;" onclick="{$onclick}" class="ametys-link">
                <i18n:text i18n:key="PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ACTION" i18n:catalogue="plugin.workspaces"/>
            </a>
            
            <xsl:call-template name="join-project-dialog"/>
        </li>
    </xsl:template>
    
    <xsl:template match="project" mode="illustration">
        <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage('site-parameter', concat(site/@name, ';illustration'), 101, 246, false(), true())"/>
        <xsl:choose>
            <xsl:when test="$imgUrl != ''"><img src="{$imgUrl}" alt="" /></xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="project-default-illustration"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="project-default-illustration">
        <img src="{ametys:skinURL('templates/common/img/bg2-small.png')}" alt="" />
    </xsl:template>
    
    <xsl:template name="join-project-dialog">
        <div class="join-project-dialog" data-join-project="{@id}" style="display:none" >
            <div class="mb-2 text-center"><xsl:value-of select="title"/></div>
            <xsl:if test="description">
                <div class="mb-2 text-center ui-dialog-text-secondary"><xsl:value-of select="description"/></div>
            </xsl:if>
            <xsl:if test="inscriptionStatus = 'MODERATED'">
                <textarea name="message" placeholder="PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK" i18n:attr="placeholder" style="resize: none; height: 100px; width: 100%"></textarea>
            </xsl:if>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
