<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver project">

	<xsl:import href="skin://templates/project/stylesheets/template.xsl" />
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:template name="additionnal-css">
        <!-- edit tools styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/print.css')}" />
        <!-- End edit tools styles -->
    </xsl:template>
    
    
    <xsl:template name="additionnal-script">
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="start-callback">function() { $j('.front-edition-placeholder .ametys-front-edition-button').parents('.front-edition-placeholder').show(); }</xsl:with-param>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
        
        <link rel="stylesheet" href="{ametys:skinURL('zones/foedition-toolbar/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="main-content">
        <div class="container">
            <div class="ametys-main-content-wrap">
                <div class="ametys-main-content">
                    <div class="ametys-main__inner">
                        <xsl:call-template name="publish-banner"/>
                        <zone name="default" level="1" />
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="publish-banner">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        <xsl:param name="cTypeId" select="$mainContent/information/type-information/@id"/>
        
        <xsl:if test="$cTypeId = 'org.ametys.plugins.workspaces.Content.projectNews'">
            <xsl:call-template name="ametys-front-edition-content-workflow-button">
                <xsl:with-param name="content-id" select="$mainContent/information/contentId"/>
                <xsl:with-param name="workflow-id">5</xsl:with-param>
                <xsl:with-param name="workflow-text"><i18n:text i18n:key="SKIN_NEWS_NOTIFY_PUBLICATION" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="title-i18n" select="concat('skin.', $skin, ':SKIN_NEWS_NOTIFY_PUBLICATION_TITLE')"/>
                <xsl:with-param name="class">ametys-front-edition-publish-banner</xsl:with-param>
                <xsl:with-param name="edition-mode-only" select="false()"/>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-front-edition-insert-delete-page-button">
                <xsl:with-param name="page-id" select="ametys:pageId()"/>
                <xsl:with-param name="title-i18n" select="concat('skin.', $skin, ':SKIN_FO_DELETE_NEWS_BTN_TEXT')"/>
                <xsl:with-param name="class">ametys-edit-tools__delete</xsl:with-param>
                <xsl:with-param name="button-text"><span class="ametys-edit-tools__icon fas fa-trash-alt"></span></xsl:with-param>
                <xsl:with-param name="edition-mode-only" select="false()"/>
                <xsl:with-param name="callback">function() { window.location.href = "<xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$lang"/>/index.html"; }</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
                                
</xsl:stylesheet>