<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

    <xsl:template name="main-menu">
        <nav class="ametys-nav-tabs ametys-nav-tabs--white mb-6">
            <ul class="ametys-nav-tabs-list">
        
                <xsl:if test="$sitemap/page[@sitemap:name = 'index']">
                    <li class="ametys-nav-tabs-list__item">
                        <a class="ametys-nav-tabs-list__link" href="{$site-uri-prefix}/{$lang}/index.html">
                            <xsl:if test="$sitemap/page[@sitemap:name = 'index']/@sitemap:in-path='true'">
                                <xsl:attribute name="class">ametys-nav-tabs-list__link active</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="$sitemap/page[@sitemap:name = 'index']/@sitemap:title" />
                            
                            <!-- TODO Indicateur nouveauté -->
                            <!-- <xsl:call-template name="main-menu-indicator"/> -->
                        </a>
                    </li>
                </xsl:if>
        
                <xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]|$sitemap/page[@sitemap:path='minisite']/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                    <li class="ametys-nav-tabs-list__item">
                        <a class="ametys-nav-tabs-list__link" href="{resolver:resolve('page', @sitemap:id)}">
                            <xsl:if test="@sitemap:in-path='true'">
                                <xsl:attribute name="class">ametys-nav-tabs-list__link active</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="@sitemap:title" />
                            
                            <!-- TODO Indicateur nouveauté  -->
                            <!-- <xsl:call-template name="main-menu-indicator"/> -->
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </nav>
    </xsl:template>
    
    <xsl:template name="main-menu-indicator">
        <span class="ametys-indicator ametys-indicator--danger"></span>
    </xsl:template>
</xsl:stylesheet>