<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:math="java.lang.Math" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:str="http://exslt.org/strings"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:exslt="http://exslt.org/common"
    exclude-result-prefixes="xalan math str ametys user resolver stringutils">  
    
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:variable name="rawCurrentUser">
        <xsl:call-template name="user-info"/>
    </xsl:variable>
    <xsl:variable name="currentUser" select="exslt:node-set($rawCurrentUser)"/>

    <xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')"/>
    
    <xsl:variable name="catalogHomeUrl">
        <xsl:choose>
            <xsl:when test="$catalogSiteName != '' and ametys:pageExists($catalogSiteName, $lang, 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/', $lang, '/index.html')"/>
            </xsl:when>
            <xsl:when test="$catalogSiteName != '' and $lang != 'fr' and ametys:pageExists($catalogSiteName, 'fr', 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/fr/index.html')"/>
            </xsl:when>
            <xsl:when test="$catalogSiteName != '' and $lang != 'en' and ametys:pageExists($catalogSiteName, 'en', 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/en/index.html')"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Catalog home page not found  -->
                <xsl:value-of select="concat($site-uri-prefix, '/', $lang, '/index.html')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="extjs-theme">/plugins/front-edition/resources/themes/theme-ametys-material</xsl:variable>
    
</xsl:stylesheet>    