<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="resolver">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/members.xsl"/>
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>
    
    <xsl:template match="hit">
    	<li class="ametys-search-list__item ametys-search-list__item--hidden-info" data-module-hit="true">
			<div class="ametys-search-item">
				<a class="ametys-search-item__full-link" href="{resolver:resolve('page', page)}"></a>
				
				<div class="ametys-search-item-header">
					<div class="ametys-user">
                        <xsl:call-template name="user-image"/>
					    <xsl:call-template name="user-info"/>
					</div>
				</div>
				
				<div class="ametys-search-item-info">
					<xsl:call-template name="first-column"/>
					<xsl:call-template name="second-column"/>
				</div>
			</div>
		</li>
    </xsl:template> 
    
    <xsl:template name="user-image">
        <xsl:param name="imgWidth">60</xsl:param>
        
        <xsl:variable name="imgUrl" select="concat($site-uri-prefix, '/_plugins/core-ui/user/', attributes/user/@populationId, '/', uriutils:encodePath(attributes/user/@login), '/image_', $imgWidth, '?lang=', $lang)"/>
        <div class="ametys-user-img">
            <img alt="" src="{$imgUrl}"/>
        </div>        
    </xsl:template>
    
    <xsl:template name="user-info">
		<div class="ametys-user-info">
			
            <xsl:call-template name="user-info-title"/>
            <xsl:call-template name="user-info-function"/>
            <xsl:call-template name="user-info-organisation"/>
		</div>
    </xsl:template>
    
    <xsl:template name="user-info-title">
        <h3 class="ametys-user-info__name ametys-truncate-1">
            <xsl:choose>
                <xsl:when test="attributes/user"><xsl:value-of select="attributes/user"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="attributes/title"/></xsl:otherwise>
            </xsl:choose>
        </h3>
    </xsl:template>
    
    <xsl:template name="user-info-function">
        <xsl:if test="normalize-space(attributes/function) != ''">
            <div class="ametys-user-info__position ametys-truncate-1"><xsl:value-of select="attributes/function"/></div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-info-organisation">
        <xsl:if test="normalize-space(attributes/organisation) != '' or normalize-space(attributes/organisation-accronym) != ''">
            <span class="ametys-tag ametys-tag--xs ametys-tag--gray ametys-truncate-1">
                <xsl:choose>
                    <xsl:when test="normalize-space(attributes/organisation-accronym) != ''">
                        <xsl:value-of select="attributes/organisation-accronym"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="attributes/organisation"/>
                    </xsl:otherwise>
                </xsl:choose>
            </span>
        </xsl:if>
    </xsl:template>
				
    <xsl:template name="first-column">
		<xsl:if test="normalize-space(attributes/phone) != '' or normalize-space(attributes/mobile) != ''">
			<div class="ametys-search-item-info__item">
				<div class="ametys-contacts">
					<xsl:call-template name="first-column-title"/>
					<ul class="ametys-contacts-list">
						<xsl:call-template name="phone"/>
						<xsl:call-template name="mobile"/>
					</ul>
				</div>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="first-column-title">
		<h3 class="ametys-contacts-title">
			<i class="ametys-contacts-title__icon fas fa-mobile-alt"></i>
			<i18n:text i18n:key="SKIN_SERVICE_SEARCH_MEMBERS_MODULE_PHONE" i18n:catalogue="skin.{$skin}"/>
		</h3>
    </xsl:template>
    
    <xsl:template name="phone">
		<xsl:if test="normalize-space(attributes/phone) != ''">
			<li class="ametys-contacts-list__item">
				<a href="tel:{attributes/phone}"><xsl:value-of select="attributes/phone"/></a>
			</li>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="mobile">
		<xsl:if test="normalize-space(attributes/mobile) != ''">
			<li class="ametys-contacts-list__item">
				<a href="tel:{attributes/mobile}"><xsl:value-of select="attributes/mobile"/></a>
			</li>
		</xsl:if>
	</xsl:template>
    
    <xsl:template name="second-column">
    	<xsl:if test="normalize-space(attributes/email) != '' or normalize-space(attributes/mobile) != ''">
			<div class="ametys-search-item-info__item">
				<div class="ametys-contacts">
					<xsl:call-template name="second-column-title"/>
					
					<ul class="ametys-contacts-list">
						<xsl:call-template name="email"/>
					</ul>
				</div>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="second-column-title">
		<h3 class="ametys-contacts-title">
			<i class="ametys-contacts-title__icon far fa-comment-dots"></i>
			<i18n:text i18n:key="SKIN_SERVICE_SEARCH_MEMBERS_MODULE_CONTACT" i18n:catalogue="skin.{$skin}"/>
		</h3>
	</xsl:template>
	
	<xsl:template name="email">
		<xsl:if test="normalize-space(attributes/email) != ''">
			<li class="ametys-contacts-list__item">
				<a href="mailto:{attributes/email}"><xsl:value-of select="attributes/email"/></a>
			</li>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>