<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:stringutils="org.apache.commons.lang.StringUtils"
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="docbook resolver ametys user exslt"
                              extension-element-prefixes="text">
    
    <xsl:import href="plugin:workspaces://stylesheets/content/catalogNews/catalogNews-portlet.xsl"/>    
	
    <xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')"/>
    
    <xsl:template name="common-content-body">
        <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
 	
    <xsl:template name="common-content-body-content">
        <div class="ametys-home-top__list__item ametys-home-top__list__item--white">
            <div class="ametys-portlet">
        		<xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
                <a class="ametys-portlet__master-link" href="{resolver:resolve('page', $page-id, false)}"></a>
                
                <xsl:call-template name="top-news"/>
                
                <xsl:call-template name="content-news"/>
                
                <xsl:call-template name="comment-news"/>
                
                <xsl:call-template name="bottom-news"/>
            </div>
        </div>    	
    </xsl:template>

    <xsl:template name="comment-news">
    	<div class="ametys-comment-vote">
   			<span class="ametys-comment-vote__item">
				<i class="far fa-comment"></i>
				<xsl:if test="comments/comment">
					<xsl:value-of select="count(comments/comment)"/>
				</xsl:if>
			</span>
		</div>
    </xsl:template>
    
    <xsl:template name="top-news">
    	<xsl:variable name="rawAuthor">
	        <xsl:call-template name="user-info">
	            <xsl:with-param name="userIdentity" select="@creator"/>
		        <xsl:with-param name="imgWidth">40</xsl:with-param>
	        </xsl:call-template>
	    </xsl:variable>
	    <xsl:variable name="author" select="exslt:node-set($rawAuthor)"/>
	    
	    <xsl:variable name="authorPage" select="resolver:resolve('page', $author/user/pageId)"/>	
	    
		<div class="ametys-portlet__top">
    	    <xsl:choose>
                <xsl:when test="$authorPage != ''">
    			     <a class="ametys-portlet__top-user" href="{$authorPage}">
                        <xsl:call-template name="author-news">
							<xsl:with-param name="author" select="$author"/>
						</xsl:call-template>
                     </a>
    		    </xsl:when>
    		    <xsl:otherwise>
			    	<div class="ametys-portlet__top-user">
						<xsl:call-template name="author-news">
						     <xsl:with-param name="author" select="$author"/>
					    </xsl:call-template>
					</div>
    		    </xsl:otherwise>
    		</xsl:choose>
            <xsl:call-template name="news-date"/>
        </div>
    </xsl:template>
    
    <xsl:template name="author-news">
        <xsl:param name="author"/>
        
        <xsl:call-template name="author-img">
            <xsl:with-param name="author" select="$author"/>
        </xsl:call-template>
        
        <div class="ametys-portlet__top_user">
            <xsl:call-template name="author-name">
                <xsl:with-param name="author" select="$author"/>
            </xsl:call-template>
            
            <xsl:call-template name="author-accr">
                <xsl:with-param name="author" select="$author"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    
    <xsl:template name="content-news">
    	<div class="ametys-portlet__content">
    		<div class="ametys-portlet__content_article">
    			<xsl:call-template name="news-text"/>    
    			<xsl:call-template name="news-image"/>
    		</div>
    	</div>
	 </xsl:template>

     <xsl:template name="news-image">
        <xsl:if test="metadata/illustration/image">
            <div class="ametys-portlet__content_article_img">
                <xsl:call-template name="common-content-body-image-smallsize">
                    <xsl:with-param name="maxWidth" select="'100'"/>
                    <xsl:with-param name="maxHeight" select="'81'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                    <xsl:with-param name="class" select="'mCS_img_loaded'"/>
                </xsl:call-template>
            </div>
        </xsl:if>
     </xsl:template>
     
	 <xsl:template name="bottom-news">
		<div class="ametys-portlet__bottom">
			<xsl:variable name="rawCategories">
	            <categories>
	                <xsl:for-each select="tags/*[starts-with(local-name(), 'WORKSPACES_CATEGORY_')]">
                        <xsl:variable name="color" select="project:categoryColor(substring-after(local-name(), 'WORKSPACES_CATEGORY_'))"/>
	                    <xsl:if test="$color">
	                        <category>
                                <name><xsl:value-of select="substring-after(local-name(), 'WORKSPACES_CATEGORY_')"/></name>
	                            <label><xsl:value-of select="."/></label>
	                            <xsl:copy-of select="$color"/>
	                        </category>
	                    </xsl:if>
	                </xsl:for-each>
	            </categories>
	        </xsl:variable>
	        <xsl:variable name="categories" select="exslt:node-set($rawCategories)/categories"/>
	        
            <xsl:if test="$categories/category">
                <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_SEARCH')"/>
                
    			<a href="javascript:void(0);" onclick="$j(this).find('form').submit()" class="ametys-tag ametys-tag--sm ametys-tag--danger" style="background-color: {$categories/category/color/main}; color: {$categories/category/color/text}">
                    <xsl:if test="$searchPage">
                        <form action="{resolver:resolve('page', $searchPage/@id)}" method="post">
                            <input name="category" type="hidden" value="{$categories/category/name}"/>
                        </form>
                    </xsl:if>
    	        	<xsl:value-of select="$categories/category/label"/>
    	   		</a>
            </xsl:if>
            
            <xsl:call-template name="news-tags"/>
	    </div>
    </xsl:template>
    
    <xsl:template name="news-tags">
        <xsl:param name="tagPrefix">WORKSPACES_KEYWORD_</xsl:param>
        
        <xsl:if test="tags/*[starts-with(local-name(), $tagPrefix)]">
            <xsl:variable name="orderedKeywords">
                <keywords>
                    <xsl:for-each select="tags/*[starts-with(local-name(), $tagPrefix)]">
                        <xsl:sort select="local-name()" order="ascending"/>
                        <xsl:copy-of select="."/>
                    </xsl:for-each>
                </keywords>
            </xsl:variable>
            <xsl:variable name="keywords" select="exslt:node-set($orderedKeywords)/keywords"/>
            
            <xsl:for-each select="$keywords/*">
                <xsl:call-template name="news-tag">
                    <xsl:with-param name="tag" select="."/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="news-tag">
        <xsl:param name="tag"/>
        
        <span class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent-light" title="{$tag}">
            <i class="fas fa-hashtag" aria-hidden="true"></i>
            <xsl:value-of select="$tag"/>
        </span>
    </xsl:template>
	 
	 <xsl:template name="news-text">
	 	<div class="ametys-portlet__content_article_txt">
 			<xsl:call-template name="news-title"/>
 		
            <p class="ametys-truncate" data-lines="2">
                <xsl:call-template name="common-utils-simpletext">
                    <xsl:with-param name="text" select="metadata/abstract"/>                
                    <xsl:with-param name="defaultText" select="metadata/content/docbook:article"/>                
                    <xsl:with-param name="maxDefaultTextSize" select="'200'"/>                
                </xsl:call-template>            
            </p>
 		</div>  
	</xsl:template>
	
	<xsl:template name="news-title">
		<h2 class="ametys-truncate" data-lines="2">
			<xsl:if test="metadata/title != ''">
				<xsl:value-of select="metadata/title"/>
			</xsl:if>
		</h2> 
    </xsl:template>
   
   	<xsl:template name="news-date">
		<xsl:if test="metadata/start-date != ''">
            <span class="ametys-portlet__top_date ml-auto">
	            <xsl:call-template name="common-utils-date-role-pattern">
	                <xsl:with-param name="date" select="metadata/start-date"/>
	                <xsl:with-param name="role" select="'dtstart'"/>
	            </xsl:call-template>
            </span>
		</xsl:if>	
    </xsl:template>
    
    <xsl:template name="author-accr">
	    <xsl:param name="author"/>
    
        <xsl:variable name="organisationAccronym" select="$author/user/organisationAccronym"/>
    	<xsl:if test="$organisationAccronym != ''">
            <span class="ametys-tag ametys-tag--xs ametys-tag--gray ametys-truncate-1"><span data-ametys-tooltip="{$author/user/organisation}"><xsl:value-of select="$organisationAccronym"/></span></span>
        </xsl:if>
    </xsl:template>     
    
    <xsl:template name="author-name">
    	<xsl:param name="author"/>
	    <h3>
			<xsl:value-of select="$author/user/fullname"/>
		</h3>
	</xsl:template>
	
    <xsl:template name="author-img">
    	<xsl:param name="author"/>
        
	    <xsl:if test="$author/user/imgUrl != ''">
			<div class="ametys-portlet__top_img">
				<img class="mCS_img_loaded" src="{$author/user/imgUrl}" alt=""/>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- Template override to change date format -->
    <xsl:template name="common-utils-date-pattern">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="medium"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template> 

</xsl:stylesheet>