<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns="http://docbook.org/ns/docbook" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:import href="plugin:cms://stylesheets/io/htmleditor2docbook.xsl" />
    
    <xsl:template match="p[contains(@class, 'prettyprint') or contains(@class, 'prettyprint linenums') or contains(@class, 'prettyprintLinenums')]">
        <para>
            <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
            <xsl:apply-templates select="child::node()" mode="code"></xsl:apply-templates>
        </para>
    </xsl:template>
    
    <xsl:template match="br" mode="code">
        <phrase role="linebreak"/>
    </xsl:template>
    
    <xsl:template match="strong|b" mode="code">
		<emphasis role="strong">
			<xsl:apply-templates mode="code"/>
		</emphasis>
	</xsl:template>
	
	<xsl:template match="em|i" mode="code">
		<emphasis>
			<xsl:apply-templates mode="code"/>
		</emphasis>
	</xsl:template>
       
</xsl:stylesheet>
