<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:javalocaldate="java.time.LocalDate"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys javalocaldate">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/threads.xsl"/>
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>
    
    <xsl:variable name="datetime-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_THREADS_DATETIME_FORMAT'))"/>
    <xsl:variable name="datetime-format-with-year" select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_THREADS_DATETIME_FORMAT_WITH_YEAR'))"/>
    
    <xsl:variable name="currentYear" select="substring(javalocaldate:now(), 0, 5)"/>
    
    <xsl:template match="hit">
    	<li class="ametys-search-list__item" data-module-hit="true">
			<div class="ametys-search-item">
				<a class="ametys-search-item__full-link" href="{uri}"></a>
				
				<div class="ametys-search-item-header">
					<div class="ametys-document">
						
                        <xsl:call-template name="author-image"/>
                        
						<div class="ametys-document-info">
							<h3 class="ametys-user-info__name">
								<xsl:value-of select="author/fullname"/>
								
                                <xsl:call-template name="thread-date"/>
							</h3>
                            
                            <xsl:call-template name="author-info"/>
                            
                            <xsl:call-template name="thread-title"/>
                            <xsl:call-template name="thread-description"/>
						</div>
					</div>
				</div>
				
				<div class="ametys-search-item-info">
					<div class="ametys-search-item-info__item">
						<div class="ametys-schedule ametys-schedule--special">
							<xsl:call-template name="project"/>
							<xsl:call-template name="thread-type"/>
						</div>
					</div>
				</div>
			</div>
		</li>
    </xsl:template> 
    
    <xsl:template name="thread-date">
        <xsl:variable name="year" select="substring(creationDate, 0, 5)"/>
        <span class="ametys-user-info__date">
            <xsl:text> - </xsl:text>
            <xsl:choose>
                <xsl:when test="$year = $currentYear">
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$datetime-format}"><xsl:value-of select="creationDate"/></i18n:date>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$datetime-format-with-year}"><xsl:value-of select="creationDate"/></i18n:date>
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    
    <xsl:template name="author-image">
        <xsl:variable name="imgUrl" select="concat($site-uri-prefix, '/_plugins/core-ui/user/', author/@population, '/', uriutils:encodePath(author/@login), '/image_56?lang=', $lang)"/>
        <div class="ametys-user-img">               
            <img src="{$imgUrl}" alt="" title="{assignments/assignment/fullname}"/>
        </div>
	</xsl:template>
    
    <xsl:template name="author-info">
        <xsl:if test="author-infos/function != ''
                      or normalize-space(author-infos/organisation-accronym) != '' or normalize-space(author-infos/organisation) != ''">
            <div class="ametys-author-info">
                <xsl:call-template name="author-info-function"/>
                <xsl:call-template name="author-info-organisation"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="author-info-function">
        <xsl:if test="normalize-space(author-infos/function) != ''">
            <div class="ametys-user-info__position ametys-truncate-1"><xsl:value-of select="author-infos/function"/></div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="author-info-organisation">
        <xsl:if test="normalize-space(author-infos/organisation) != '' or normalize-space(author-infos/organisation-accronym) != ''">
            <span class="ametys-tag ametys-tag--nomargin ametys-tag--xs ametys-tag--gray ametys-truncate-1">
                <xsl:choose>
                    <xsl:when test="normalize-space(author-infos/organisation-accronym) != ''">
                        <xsl:value-of select="author-infos/organisation-accronym"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="author-infos/organisation"/>
                    </xsl:otherwise>
                </xsl:choose>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="thread-title">
        <h3 class="ametys-document-info__name"><xsl:value-of select="title"/></h3>
    </xsl:template>
    
    <xsl:template name="thread-description">
        <xsl:if test="description">
            <div class="ametys-document-info__size ametys-truncate" data-lines="2">
                <xsl:value-of select="description"/>
            </div>
        </xsl:if>
    </xsl:template>
       
    <xsl:template name="thread-type">
        <ul class="ametys-schedule-list">
			<li class="ametys-schedule-list__item">
				
            <xsl:choose>
                <xsl:when test="category = 'DISCUSSION'">
					<span class="ametys-schedule-list__item-icon">
                        <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-discussions.png')}" />
					</span>
					<i18n:text i18n:key="PLUGINS_WORKSPACES_FORUM_THREAD_CATEGORY_DISCUSSION" i18n:catalogue="plugin.workspaces"/>
                </xsl:when>
                <xsl:when test="category = 'QUESTION'">
                
                    <span class="ametys-schedule-list__item-icon">
                        <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-question.png')}" />
                    </span>                      
					<i18n:text i18n:key="PLUGINS_WORKSPACES_FORUM_THREAD_CATEGORY_QUESTION" i18n:catalogue="plugin.workspaces"/>
                </xsl:when>
                <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
            
			</li>
		</ul>
    </xsl:template>
    
</xsl:stylesheet>