<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                extension-element-prefixes="math ametys resolver escaper">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:template name="common-service-head-css">
    	<!-- Vendors Styles-->
		<link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.min.css')}" />
		
	   	<!-- statistics styles -->
		<link rel="stylesheet" href="{ametys:skinURL('pages/statistics/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('pages/statistics/scss/print.css')}" />
		<!-- END::statistics styles -->
		
		<!-- custom control styles -->
		<link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/print.css')}" />
		<!-- END::custom control styles -->
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">workspaces-report</xsl:variable>
    <xsl:variable name="common-service-name">service-workspaces-report</xsl:variable>   
    
    <xsl:variable name="downloadUrl"><xsl:value-of select="$site-uri-prefix"/>/_plugins/workspaces/report_project.csv</xsl:variable> 
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="report-js"/>
        <script src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.min.js')}"></script>
    </xsl:template>

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="report-js">
        <script type="text/javascript">
            function downloadReport_<xsl:value-of select="$uniqueId"/>()
            {
                let $report = $j('#workspaces-report-<xsl:value-of select="$uniqueId"/>');
                let $form = $report.find('*[data-report-form]');
                
                $form.submit();
            }    
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div class="ametys-card" id="workspaces-report-{$uniqueId}">
            <form method="POST" action="{$downloadUrl}" data-report-form="true">
                <input type="hidden" name="lang" value="{$lang}"/>
                <div class="ametys-card-header">
	                <div class="ametys-card-header-left">
	                	<xsl:call-template name="report-filters" />
	                </div>
	                <div class="ametys-card-header-right">
	                	<xsl:call-template name="report-download-btn" />
	                </div>
	            </div>
                <div class="ametys-card-body" style="min-height:350px;">
                	<xsl:call-template name="report-options" />
                </div>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="report-filters">
        <xsl:call-template name="report-filter-by-categories"/>
        <xsl:call-template name="report-filter-by-projects"/>
        
        <script type="text/javascript">
            $j('.selectpicker').on('loaded.bs.select', function (e) {
              var $select = $j(e.target),
                  label = $select.data('select-label');
                  
              $select.parent().find('.filter-option-inner').attr('data-select-label', label);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="report-filter-by-categories">
        
        <select name="category" multiple="multiple" class="selectpicker ametys-form-control ametys-form-control--alt ametys-form-control--categories" title="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT"
            data-select-label="skin.{$skin}:SKIN_SERVICE_REPORT_SELECT_CATEGORIES"
            data-select-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_ALL"
            data-deselect-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_UNSELECT_ALL"
            data-none-results-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_NO_RESULT"
            i18n:attr="title data-select-label data-select-all-text data-deselect-all-text data-none-results-text"
            data-actions-box="true"
			data-live-search="true"
			data-size="6">
            <xsl:for-each select="/reports/categories/category">
                <option value="{@name}" selected="selected" data-tokens="{@name}"><xsl:value-of select="title"/></option>
            </xsl:for-each>
        </select>
    </xsl:template>
    
    <xsl:template name="report-filter-by-projects">
        <select name="project" multiple="multiple" class="selectpicker ametys-form-control ametys-form-control--alt ametys-form-control--projects" title="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT"
            data-select-label="skin.{$skin}:SKIN_SERVICE_REPORT_SELECT_PROJECTS"
        	data-select-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_ALL"
            data-deselect-all-text="skin.{$skin}:SKIN_SERVICE_SEARCH_UNSELECT_ALL"
            data-none-results-text="skin.{$skin}:SKIN_SERVICE_SEARCH_SELECT_NO_RESULT"
            i18n:attr="title data-select-label data-select-all-text data-deselect-all-text data-none-results-text"
            data-actions-box="true"
			data-live-search="true"
			data-size="6">
            <xsl:for-each select="/reports/projects/project">
                <option value="{@id}" selected="selected" data-tokens="{@name}"><xsl:value-of select="."/></option>
            </xsl:for-each>
        </select>
    </xsl:template>
    
    <xsl:template name="report-options">
        <div class="report-options">
            <xsl:call-template name="report-options-hint"/>
            
            <xsl:call-template name="report-options-text"/>
            
            <xsl:call-template name="report-option-managers"/>
            <xsl:call-template name="report-option-members"/>
        </div>
    </xsl:template>
    
    <xsl:template name="report-options-hint">
        <h6 class="report-options__hint">
            <i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_DOWNLOAD_DESC" i18n:catalogue="plugin.workspaces"/>
        </h6>
    </xsl:template>
    
    <xsl:template name="report-options-text">
        <p class="report-options__text">
            <i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_OPTIONS_DESC" i18n:catalogue="plugin.workspaces"/>
        </p>
    </xsl:template>
    
    <xsl:template name="report-option-managers">
        <div class="ametys-checkbox-with-title">
            <input id="report-opt-with-managers-{$uniqueId}" name="with-managers" type="checkbox" value="true"/>
            <label for="report-opt-with-managers-{$uniqueId}">
            	<strong><i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_MANAGERS" i18n:catalogue="plugin.workspaces"/></strong>
            	<i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_MANAGERS_DESC" i18n:catalogue="plugin.workspaces"/>
            </label>
        </div>
    </xsl:template>
    
    <xsl:template name="report-option-members">
        <div class="ametys-checkbox-with-title">
            <input id="report-opt-with-members-{$uniqueId}" name="with-members" type="checkbox" value="true"/>
            <label for="report-opt-with-members-{$uniqueId}">
            	<strong><i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_MEMBERS" i18n:catalogue="plugin.workspaces"/></strong>
                <i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_MEMBERS_DESC" i18n:catalogue="plugin.workspaces"/>
            </label>
        </div>
    </xsl:template>
            
    <xsl:template name="report-download-btn">
		<button type="button" onclick="downloadReport_{$uniqueId}()" class="ametys-download-btn">
			<i class="fas fa-file-download"></i>
			<i18n:text i18n:key="PLUGIN_WORKSPACES_SERVICE_REPORTS_SERVICE_DOWNLOAD" i18n:catalogue="plugin.workspaces"/>
		</button>
    </xsl:template>
</xsl:stylesheet>
