<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="skin://stylesheets/content/article/article-main.xsl"/>	
	
    <xsl:template name="common-content-body-content-title">
        <h1 data-ametys-metadata="{@id};title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="common-content-body-content-content">
        <!-- Title -->
        <xsl:call-template name="common-content-body-content-title"/>
        
        <!-- Rich content -->
        <xsl:choose>
            <xsl:when test="metadata/content/docbook:article">
                <div class="ametys-richtext" data-ametys-metadata="{@id};content">
                    <xsl:call-template name="common-content-body-content-rich"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="rs-editable">
                    <div class="ametys-richtext front-edition-placeholder" data-ametys-metadata="{@id};content" style="display: none; height: 740px; text-align: center" i18n:attr="data-front-edition-button-text" data-front-edition-button-text="skin.{$skin}:SKIN_FO_ABOUT_CONTENT_PLACEHOLDER">
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>