<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver project">

	<xsl:import href="skin://templates/project/stylesheets/template.xsl" />
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:template name="additionnal-script">
        <!-- FO edition (for news + wallcontent) -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
        <script type="text/javascript">
            if (ametysUser)
            {
                ametysUser.canPinWallContent = <xsl:value-of select="project:hasRightOnModule('Plugins_Workspaces_Right_Pin_WallContent', 'org.ametys.plugins.workspaces.wall.WallContentModule')"/>;
                ametysUser.canEditWallContent = <xsl:value-of select="project:hasRightOnModule('Workflow_Rights_Edition_Online', 'org.ametys.plugins.workspaces.wall.WallContentModule')"/>;
                ametysUser.canDeleteWallContent = <xsl:value-of select="project:hasRightOnModule('CMS_Rights_DeleteContent', 'org.ametys.plugins.workspaces.wall.WallContentModule')"/>;
            }
        </script>
   </xsl:template>

    <xsl:template name="additionnal-css">
        <!-- sidebar styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/print.css')}" />
        <!-- End sidebar styles -->
    </xsl:template>
    
    <xsl:template name="main-content">
          
        <div class="ametys-container-wrap">
            <div class="container">
                <div class="ametys-main-content-wrap mb-0 position-relative">
                    
                    <!-- left aside -->
					<aside class="ametys-main-sidebar ametys-main-sidebar--left" 
						aria-labelledby="ametys-cms-zone-sidebar-left-top ametys-cms-zone-sidebar-left-middle ametys-cms-zone-sidebar-left-bottom">
                        
                        <zone name="left-top" level="1">
                            <body data-ametys-mobile-tab="true" data-ametys-mobile-tab-text="skin.{$skin}:SKIN_MOBILE_TAB_ALERT" i18n:attr="data-ametys-mobile-tab-text"/>
                        </zone>
                        <zone name="left" level="1">
                            <body data-ametys-mobile-tab="true" data-ametys-mobile-tab-text="skin.{$skin}:SKIN_MOBILE_TAB_NEWS" i18n:attr="data-ametys-mobile-tab-text"/>
                        </zone>
                        <zone name="left-bottom" level="1"/>
                    </aside>
                    <!-- END::left aside -->
                    
                    <!-- content -->
                    <div class="ametys-main-content home">
                        <zone name="default" level="1">
                            <body data-ametys-mobile-tab="true" data-ametys-mobile-tab-text="skin.{$skin}:SKIN_MOBILE_TAB_WALL" i18n:attr="data-ametys-mobile-tab-text" data-ametys-mobile-tab-priority="1"/>
                        </zone> 
                    </div>
                    
                    <!-- right aside -->
                    <aside class="ametys-main-sidebar ametys-main-sidebar--right" aria-labelledby="ametys-cms-zone-sidebar-right-top ametys-cms-zone-sidebar-right-middle">
                        <zone name="right" level="1">
                            <body data-ametys-mobile-tab="true" data-ametys-mobile-tab-text="skin.{$skin}:SKIN_MOBILE_TAB_SURVEY" i18n:attr="data-ametys-mobile-tab-text"/>
                        </zone>
                        <zone name="right-bottom" level="1"/>
                    </aside>
                    <!-- END::right aside -->
                </div>
            </div>
        </div>
    </xsl:template>
    
    <!-- Overriden configuration for mobile header -->
    <xsl:template name="mobile-header-withtabs">true</xsl:template>
    
    <xsl:template name="project-title">
        <div class="row mb-6">
            <div class="px-3 py-2">
                <div class="py-1 ametys-main-banner-text">
                    <h1><xsl:value-of select="$projectTitle"/></h1>
                    <xsl:call-template name="project-description"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="project-description">
        <xsl:if test="$projectDescription != ''">
            <p>
                <xsl:value-of select="$projectDescription"/>
                <xsl:call-template name="project-know-more"/>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-know-more">
        <xsl:variable name="aboutPageId" select="project:getModulePage('org.ametys.plugins.workspaces.about.AboutWorkspaceModule')"/>
        <xsl:if test="$aboutPageId">
            <xsl:text> </xsl:text><a class="know-more" href="{resolver:resolve('page', $aboutPageId)}"><i18n:text i18n:key="SKIN_PROJECT_KNOW_MORE" i18n:catalogue="skin.{$skin}"/></a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>