(function ($) {
	function truncate(selector) {
		$(selector).each(function (i, el) {
			var lines = navigator.userAgent.toLowerCase().indexOf('firefox') > -1 ? $(el).data('lines') + 1 : $(el).data('lines');

			$(el).truncate({
				lines: $(el).data('lines') + 1 // FIX Ametys
			});
		});
	}

	$(function () {
		// Anchors
		var ametysAnchor = $('.ametys-anchor');
		var ametysAnchorTop = ametysAnchor.length ? ametysAnchor.offset().top : 0;

		// Hide/ Show blocks
		$('.ametys-hide-show-invoker').on('click', function (e) {
			var $this = $(this),
				target = $this.attr('href') || $(this).data('target');
			
			if (target.slice(0, 1) !== '#') {
				return;
			}
			
			e.preventDefault();

			var group = $this.data('group');

			$('.ametys-hide-show-invoker[data-group="' + group + '"]').removeClass('active');
			$('.ametys-hide-show-invoker[href="' + target + '"]').addClass('active');

			$('html,body').animate({
				scrollTop: 0
			}, 400);

			$('.ametys-hide-show-target[data-group="' + group + '"]').hide();
			$(target).fadeIn(200, function () {
				if (!$(target + ' .ametys-truncate').length) return;

				truncate(target + ' .ametys-truncate');
			});
		});

		// initialization of dropdowns
		if ($('[data-dropdown-target]').length) {
		$.HSCore.components.HSDropdown.init($('[data-dropdown-target]'), {
			dropdownHideOnScroll: false,
			afterOpen: function () {
				$('.ametys-search-form__control-wrap .ametys-search-form-dropdown-content').fadeOut(200);
			}
		});
		}

		// initialization of custom scroll
		if ($('.js-scrollbar').length) {
			$.HSCore.components.HSScrollBar.init($('.js-scrollbar'));
		}

		$('.ametys-cms-content table:not(.no-wrap), .ametys-richtext table:not(.no-wrap)').each(function () {
			var $this = $(this);

			if (!$this.closest('.table-wrapper').length) {
				$this.wrap('<div class="table-wrapper"></div>');
			}
		});

		// scrolled position
		$(window).on('scroll', function () {
			var scrolledPosition = $(this).scrollTop();

			if (scrolledPosition > ametysAnchorTop) {
				$('.ametys-nav-tabs').removeClass('ametys-nav-tabs--white');
				$('.ametys-header-nav').removeClass('d-none');
				$('.ametys-header').addClass('ametys-header__moved');
				$('.white-logo').addClass('d-none');
				$('.color-logo').removeClass('d-none');
			} else {
				$('.ametys-nav-tabs').addClass('ametys-nav-tabs--white');
				$('.ametys-header-nav').addClass('d-none');
				$('.ametys-header').removeClass('ametys-header__moved');
				$('.white-logo').removeClass('d-none');
				$('.color-logo').addClass('d-none');
			}

		});

		// scroll top
		var $goTo = $('.ametys__scrolltop');

		$goTo.on('click', function (e) {
			e.preventDefault();

			$('html, body').stop().animate({
				'scrollTop': 0
			}, 800);
		});

		$(window).on('scroll', function () {
			if ($(window).scrollTop() >= 400 && !$goTo.hasClass('animation-was-fired')) {
				$goTo.show();

				setTimeout(function () {
					$goTo.addClass('animation-was-fired animated zoomIn').css({
						'opacity': ''
					});
				});
			} else if ($(window).scrollTop() <= 400 && $goTo.hasClass('animation-was-fired')) {
				$goTo.removeClass('animation-was-fired zoomIn');

				setTimeout(function () {
					$goTo.addClass('zoomOut').css({
						'opacity': 0
					});
				}, 100);

				setTimeout(function () {
					$goTo.removeClass('animated zoomOut').hide();
				}, 400);
			}

            rightColumnOnLeft();
		});
		
		function rightColumnOnLeft()
		{
            if ($(this).width() < 1200) {
                var sidebarRightHeight = 0;
                var twoSidebarsHeight = 0;

                $('.ametys-main-sidebar--left > div').each(function () {
                    sidebarRightHeight += $(this).height();
                });

                $('.ametys-main-sidebar--right > div').each(function () {
                    twoSidebarsHeight += $(this).height();
                });

                $('.ametys-main-sidebar--right').css('top', sidebarRightHeight + 140);

                $('.ametys-main-content').css('min-height', sidebarRightHeight + twoSidebarsHeight + 180);
            }
        }

		$(window).on('load', function () {
			var scrolledPosition = $(this).scrollTop();

			if (scrolledPosition > ametysAnchorTop) {
				$('.ametys-nav-tabs').removeClass('ametys-nav-tabs--white');
				$('.ametys-header-nav').removeClass('d-none');
				$('.ametys-header').addClass('ametys-header__moved');
				$('.white-logo').addClass('d-none');
				$('.color-logo').removeClass('d-none');
			} else {
				$('.ametys-nav-tabs').addClass('ametys-nav-tabs--white');
				$('.ametys-header-nav').addClass('d-none');
				$('.ametys-header').removeClass('ametys-header__moved');
				$('.white-logo').removeClass('d-none');
				$('.color-logo').addClass('d-none');
			}

            rightColumnOnLeft();
		});
		
		$(window).on('resize', function () {
            rightColumnOnLeft();
        });

        $('.ametys-add-publier').on('focus', function() {
            $(this).find("textarea").focus();
        });
		$('.ametys-add-publier__top_input').each(function () {
			var $self = $(this),
				$parent = $self.closest('.ametys-add-publier');

			$parent.on('focusin', function () {
				$parent.addClass('active');
				$('#publierBtnHd').hide();
				$parent.find('.ametys-add-publier__fitcher').removeClass('d-none');
				$parent.find('.ametys-add-publier__bottom').removeClass('d-none');
			});

			$parent.on('focusout', function (e) {
                if ($(this).has(e.relatedTarget || document.activeElement).length == 0) {
					$parent.removeClass('active');
					$('#publierBtnHd').show();
					$parent.find('.ametys-add-publier__fitcher').addClass('d-none');
					$parent.find('.ametys-add-publier__bottom').addClass('d-none');
                }
			});
		});

		// $('.ametys-add-publier__top_input input, .ametys-add-publier__top_input textarea').focusout(function (e) {
		//     console.log($(e.target).closest('.ametys-add-publier').length);
		//
		//     if ($(this).val().length < 1) {
		//         $(this).parent().parent().removeClass('active');
		//         $('#publierBtnHd').show();
		//         $('.ametys-add-publier__fitcher').addClass('d-none');
		//         $('.ametys-add-publier__bottom').addClass('d-none');
		//         $('.ametys-add-publier_membres').addClass('d-none');
		//     }
		// });

		$('.ametys-add-publier__top_input input, .ametys-add-publier__top_input textarea').on('keyup', function () {
			var $self = $(this);
			var $value = $self.val();

			if ($value.includes('@')) {
				$('.ametys-add-publier_membres').removeClass('d-none');
			}
		});

		$('.ametys-add-publier_chips:not(.ametys-add-publier_chips--excluded)').on('click', function () {
			$(this).toggleClass('active');
		});

		$('.ametys-add-publier_chips_more').on('click', function () {
			$('.ametys-add-publier_chips--hide').toggleClass('d-block');
		});

		// pick image
		function previewPicture(input, target) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();

				reader.onload = function (e) {
					$('<div class="ametys-add-publier__fitcher__list_item ametys-add-publier__fitcher__list_item--picked-img"><img class="img-fluid" src="' + e.target.result + '" alt="Picked Image" /></div>').appendTo(target);
				};

				reader.readAsDataURL(input.files[0]);
			}
		}

		function srcPicture(input, target) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();

				reader.onload = function (e) {
					target.attr('src', e.target.result);
				};
				
				reader.readAsDataURL(input.files[0]);
				}
		}

		function bgImage(input, target) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				
				reader.onload = function (e) {
					target.css('background-image', 'url(' + e.target.result + ')');
				};
				
				reader.readAsDataURL(input.files[0]);
			}
		}

		$('.ametys-pick-img').each(function () {
			var $this = $(this),
				$control = $this.children('.ametys-pick-img__control'),
				$fileName = $this.children('.ametys-pick-img__name'),
				$remove = $this.children('.ametys-pick-img__remove'),
				target = $this.data('pick-image-insert-target'),
				singleOnly = $this.attr('data-pick-image-single-only'),
				showFileName = $this.attr('data-pick-image-show-file-name');

			$control.on('change', function () {
                if ($control.val() == '')
                {
                    $(target).find('.ametys-add-publier__fitcher__list_item--picked-img')
                        .remove();
	
	                $this.removeClass('ametys-pick-img--picked');
	
	                if (showFileName != null) {
	                    $fileName.text('');
	                }
	
	                setTimeout(function () {
	                    if (singleOnly != null) {
	                        $control.show();
	                        $control.prop('disabled', false);
	                    }
	                });
                }
                else
                {
					var fileName = $control.val().split('\\').pop();
	
					if (singleOnly != null) {
	                    $control.closest('.ametys-add-publier').find("textarea").focus();
	                    $control.hide();
	                    $control.prop('disabled', true);
					}
	
					$this.addClass('ametys-pick-img--picked');
	
					if (showFileName != null) {
						$fileName.text(fileName);
					}
	
					previewPicture($control[0], target);
                }
			});

			$this.on('click', function () {
				if (!$this.hasClass('ametys-pick-img--picked')) return;

				$control.val('');
                $control.trigger('change');
			});
		});

		// $('.rs-main-profile__userpic .user-image').wrap('<div class="user-image-wrap"></div>')

		$('.rs-main-profile__userpic').each(function () {
			var $this = $(this),
				$control = $this.children('.rs-main-profile__userpic-control'),
				$btn = $this.find('.ametys-front-edition-button'),
				$target = $this.find('.user-image');

			$btn.on('click', function () {
				$control.trigger('click');
			});

			$control.on('change', function () {
				srcPicture($control[0], $target);
			});
		});

		$('.contenttype-composite .field-illustration-image input').each(function () {
			var $this = $(this),
				$target = $this.closest('.input');
			
			$this.on('change', function () {
				$target.addClass('changed');
				
				bgImage($this[0], $target);
			});
		});
		
		// vote active state
//		$('.ametys-comment-vote__item').on('click', function () {
//			var voteIcon = $(this).find('i').attr('class');
//
//			$(this).toggleClass('active');
//
//			if (voteIcon == 'far fa-thumbs-up') {
//				$(this).find('i').toggleClass('far fa-thumbs-up fas fa-thumbs-up');
//			}
//
//			if (voteIcon == 'fas fa-thumbs-up') {
//				$(this).find('i').toggleClass('fas fa-thumbs-up far fa-thumbs-up');
//			}
//
//			if (voteIcon == 'far fa-comment') {
//				$(this).parent().parent().parent().find('.ametys-comment__bottom').toggleClass('d-none');
//			}
//		});

		// sound ON/OFF
		$('.ametys-comment__content__sound_on').on('click', function () {
			$(this).toggleClass('fa-volume-up fa-volume-mute');
		});

		// scroll top
		$('.ametys__scrolltop').on('click', function () {
			$("html, body").animate({scrollTop: 0}, 700)
		});

		// home page search filter input
		$('.ametys-home__filter_icn').on('click', function () {
			$(this).parent().addClass('active');
			$('.ametys-overlay-transparent').addClass('active');
		});

		$('#ametysCloseFilter').on('click', function () {
			$(this).parent().parent().removeClass('active');
		});

		// header top icons
		$('.ametys-toprojects').on('click', function () {
			$(this).toggleClass('active');
			$('.ametys-overlay-transparent').addClass('active');
			$('.ametys-notifications').removeClass('active');
			$('.ametys-user').removeClass('active');
		});

		$('.ametys-notifications').on('click', function () {
			$(this).toggleClass('active');
			$('.ametys-overlay-transparent').addClass('active');
			$('.ametys-toprojects').removeClass('active');
			$('.ametys-user').removeClass('active');
		});

		$('.ametys-user').on('click', function () {
			$(this).toggleClass('active');
			$('.ametys-overlay-transparent').addClass('active');
			$('.ametys-toprojects').removeClass('active');
			$('.ametys-notifications').removeClass('active');
		});

//		$('.ametys-more').on('click', function () {
//			$(this).toggleClass('active');
//		});

		$('.ametys-overlay-transparent').on('click', function () {
			$(this).removeClass('active');
			$('.ametys-toprojects').removeClass('active');
			$('.ametys-notifications').removeClass('active');
			$('.ametys-user').removeClass('active');
			$('.ametys-more').removeClass('active');
			$('.ametys-home__motrer_dropdown-toggle').parent().addClass('active').removeClass('active');
			$('.ametys-home__filter_icn').parent().removeClass('active');
			$('.ametys-actif__moredropdown').removeClass('active');
		});

		// show all text
		$(".ametys-voirp").on('click', function () {
			$(this).parent().addClass('ametys-comment-extend');
			$(this).hide();
		});

		// show/hide other comments
		$('.ametys-comments-show').on('click', function () {
			$(this).addClass('d-none');
			$(this).parent().parent().find('.ametys-show-others').slideDown();
			$(this).parent().find('.ametys-comments-hide').removeClass('d-none');
		});

//		$('.ametys-comments-hide').on('click', function () {
//			$(this).addClass('d-none');
//			$(this).parent().parent().find('.ametys-show-others').slideUp();
//			$(this).parent().find('.ametys-comments-show').removeClass('d-none');
//		});

//		$('.ametys-comment-repondre').on('click', function () {
//			$(this).parent().parent().find('.ametys-comment-repodre-block').slideToggle().find('textarea').focus();
//		});

		$('.ametys-sidebar-voir').on('click', function () {
			$(this).addClass('d-none');
			$(this).parent().find('.ametys-q-panel__list_subtxt--limit').addClass('show');
		});

		// star active/inactive
		$('.ametys-toprojects__list_item_panel i.fa-star').on('click', function () {
			var $self = $(this);

			if ($self.attr('class') == 'far fa-star') {
				$self.toggleClass('far fa-star fas fa-star');
				$self.addClass('icn-active');
				return;
			} else {
				$self.toggleClass('fas fa-star far fa-star');
				$self.removeClass('icn-active');
				return;
			}
		});

		// motre dropdown
		$('.ametys-home__motrer_dropdown-toggle').on('click', function () {
			$(this).parent().addClass('active');
			$('.ametys-overlay-transparent').addClass('active');
		});

		// more Actif
		$('.ametys-actif_more .g-dot_wrap').on('click', function () {
			$(this).parent().find('.ametys-actif__moredropdown').addClass('active');
		});

		$('.ametys-actif__moredropdown').on('click', function () {
			$(this).removeClass('active');
		});

		// hide if event outside opened component
		$(document).on('mouseup', function (e) {
			var container = $(".ametys-actif__moredropdown");

			if (!container.is(e.target) && container.has(e.target).length === 0) {
				container.removeClass('active');
			}
		});

		$(document).on('mouseup', function (e) {
			var container = $(".ametys-more");

			if (!container.is(e.target) && container.has(e.target).length === 0) {
				container.removeClass('active');
			}
		});

		// tous switch
		var blueBadge = 'ametys-home__motrer_selected--blue',
			greenBadge = 'ametys-home__motrer_selected--green',
			yellowBadge = 'ametys-home__motrer_selected--yellow',
			dangerBadge = 'ametys-home__motrer_selected--danger',
			$motrerSelected = $('.ametys-home__motrer_selected'),
			$motrerDropdown = $('.ametys-home__motrer_dropdown');

		var $itemYellow = $('.ametys-toprojects__list_item.ametys-yellow').parent(),
			$itemGreen = $('.ametys-toprojects__list_item.ametys-green').parent(),
			$itemBlue = $('.ametys-toprojects__list_item.ametys-blue').parent(),
			$itemDanger = $('.ametys-toprojects__list_item.ametys-danger').parent(),
			$itemParent = $('.ametys-toprojects__list');

		var colorObj = {
			blue: 'blue',
			yellow: 'yellow',
			green: 'green',
			danger: 'danger'
		};

		$('.ametys-home__motrer_dropdown-menu-item').on('click', function () {
			var currentSpanTag = $(this).data('motrer');

			$motrerSelected.removeClass(blueBadge);
			$motrerSelected.removeClass(greenBadge);
			$motrerSelected.removeClass(yellowBadge);
			$motrerSelected.removeClass(dangerBadge);

			$itemParent.find('li').removeClass('d-none');

			if (currentSpanTag == colorObj.blue) {
				$motrerSelected.addClass(blueBadge);
				$itemYellow.addClass('d-none');
				$itemGreen.addClass('d-none');
				$itemDanger.addClass('d-none');
				$motrerSelected.text('FINANCE');
			} else if (currentSpanTag == colorObj.green) {
				$motrerSelected.addClass(greenBadge);
				$itemYellow.addClass('d-none');
				$itemBlue.addClass('d-none');
				$itemDanger.addClass('d-none');
				$motrerSelected.text('TRANSPORT');
			} else if (currentSpanTag == colorObj.yellow) {
				$motrerSelected.addClass(yellowBadge);
				$itemBlue.addClass('d-none');
				$itemGreen.addClass('d-none');
				$itemDanger.addClass('d-none');
				$motrerSelected.text('RESSOURCE HUMAINES');
			} else if (currentSpanTag == colorObj.danger) {
				$motrerSelected.addClass(dangerBadge);
				$itemYellow.addClass('d-none');
				$itemGreen.addClass('d-none');
				$itemBlue.addClass('d-none');
				$motrerSelected.text('URBANISME');
			}

			$motrerDropdown.removeClass('active');
			$('.ametys-overlay-transparent').removeClass('active');
		});

		$('.ametys-home__motrer_dropdown-menu__title').on('click', function () {
			$motrerSelected.removeClass(blueBadge);
			$motrerSelected.removeClass(greenBadge);
			$motrerSelected.removeClass(yellowBadge);
			$motrerSelected.removeClass(dangerBadge);
			$itemParent.find('li').removeClass('d-none');
			$motrerSelected.text('Tous');
			$motrerDropdown.removeClass('active');
			$('.ametys-overlay-transparent').removeClass('active');
		});

		// auto change textarea height
		$('.ametys-textarea-auto').on('input', function () {
			if ($(this).val().length < 65) {
				this.style.height = '42px';
				return;
			} else {
				this.style.height = 'auto';
				this.style.height = (this.scrollHeight) + 'px';
			}

		});

		$('.ametys-header-search--mobile').on('click', function () {
			$(this).toggleClass('active');
			$('.ametys-header-search').toggleClass('active');
		});

		// play video
		$('.ametys-video').on('click', function () {
			var $this = $(this),
				target = $this.data('video-target');

			$this.find('img').hide();
			$this.addClass('active');

			$(target)[0].play();
		});

		// edition
		var $editionEl = $('.ametys-front-edition-possible:not(.front-edition-placeholder)');

		if ($editionEl.length) {
			$editionEl.on('mouseenter', function () {
				$(this).addClass('ametys-front-edition-hover');
			});

			$editionEl.on('mouseleave', function () {
				$(this).removeClass('ametys-front-edition-hover');
			});
		}
		
		// toggle favorite
//		$('.ametys-toggle-favorite').on('click', function () {
//			var $this = $(this),
//				target = $this.data('toggle-favorite-target');
//			
//			if ($(target).hasClass('ametys-comment--favorite')) {
//				$('[data-toggle-favorite-target="' + target + '"] > span').text('Epingler');
//			} else {
//				$('[data-toggle-favorite-target="' + target + '"] > span').text('Désépingler');
//			}
//			
//			$(target).toggleClass('ametys-comment--favorite');
//		});
	});

	$(window).on('load', function () {
			// Truncate text
			truncate('.ametys-truncate:visible');

			$('a[data-toggle="tab"]').on('shown.bs.tab', function (a, b, c) {
				var target = $(this).attr('href');

				if (!$(target + ' .ametys-truncate').length) return;

				truncate(target + ' .ametys-truncate');
			});
		}
	);
})(jQuery);