/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer;

import java.io.IOException;
import java.util.Map;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExplorerNodeGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._resolver = (AmetysObjectResolver)sManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("node");
        ExplorerNode node = (ExplorerNode)this._resolver.resolveById(id);
        this._saxExplorerNode(node);
    }

    private void _saxExplorerNode(ExplorerNode node) throws SAXException {
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", node.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Nodes", (Attributes)atts);
        if (node instanceof TraversableAmetysObject) {
            TraversableAmetysObject traversableObject = (TraversableAmetysObject)node;
            AmetysObjectIterable children = traversableObject.getChildren();
            for (AmetysObject child : children) {
                if (!(child instanceof ExplorerNode)) continue;
                this.saxExplorerNode((ExplorerNode)child);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Nodes");
        this.contentHandler.endDocument();
    }

    protected void saxExplorerNode(ExplorerNode node) throws SAXException {
        boolean hasChildNodes;
        AttributesImpl childAtts = new AttributesImpl();
        childAtts.addCDATAAttribute("id", node.getId());
        childAtts.addCDATAAttribute("name", node.getName());
        childAtts.addCDATAAttribute("iconCls", node.getIconCls());
        childAtts.addCDATAAttribute("applicationId", node.getApplicationId());
        String relPath = node.getExplorerPath();
        childAtts.addCDATAAttribute("path", relPath.startsWith("/") ? relPath.substring(1) : relPath);
        childAtts.addCDATAAttribute("type", "collection");
        boolean hasResources = false;
        if (node instanceof ResourceCollection) {
            hasResources = ((ResourceCollection)node).hasChildResources();
        }
        if (hasChildNodes = node.hasChildExplorerNodes()) {
            childAtts.addCDATAAttribute("hasChildNodes", "true");
        }
        if (hasResources) {
            childAtts.addCDATAAttribute("hasResources", "true");
        }
        if (node instanceof ModifiableAmetysObject) {
            childAtts.addCDATAAttribute("isModifiable", "true");
        }
        if (node instanceof ModifiableExplorerNode) {
            childAtts.addCDATAAttribute("canCreateChild", "true");
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
    }
}

