/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ImagesContainerClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getImages(String id) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        AmetysObject ao = this._resolver.resolveById(id);
        ArrayList<String> images = new ArrayList<String>();
        ResourceCollection collection = null;
        if (ao instanceof ResourceCollection) {
            collection = (ResourceCollection)ao;
        } else if (ao instanceof Resource) {
            collection = (ResourceCollection)ao.getParent();
        }
        if (collection != null) {
            for (AmetysObject child : collection.getChildren()) {
                Resource resource;
                if (!(child instanceof Resource) || !this._isImage(resource = (Resource)child)) continue;
                images.add(resource.getId());
            }
        }
        results.put("images", images);
        return results;
    }

    private boolean _isImage(Resource resource) {
        String filename = resource.getName().toLowerCase();
        return filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".gif") || filename.endsWith(".png");
    }
}

