/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.cmis;

import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.cmis.CMISResourcesCollection;
import org.ametys.plugins.explorer.cmis.CMISRootResourcesCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.commons.lang3.Strings;

public class CMISResource
implements Resource {
    private final Document _cmisDocument;
    private final CMISRootResourcesCollection _root;
    private AmetysObject _parent;

    public CMISResource(Document document, CMISRootResourcesCollection root, AmetysObject parent) {
        this._cmisDocument = document;
        this._root = root;
        this._parent = parent;
    }

    public CMISRootResourcesCollection getCmisRoot() {
        return this._root;
    }

    public Document getCmisDocument() {
        return this._cmisDocument;
    }

    public String getId() throws AmetysRepositoryException {
        return this.getCmisRoot().getId() + "/" + this.getCmisDocument().getId();
    }

    public String getName() {
        String fileName = this.getCmisDocument().getName();
        if (fileName == null) {
            fileName = this.getCmisDocument().getContentStreamFileName();
        }
        if (fileName == null) {
            ContentStream cs = this.getCmisDocument().getContentStream();
            if (cs == null) {
                throw new AmetysRepositoryException("contentStream is empty on CMIS Document '" + this.getCmisDocument().getId() + "'");
            }
            fileName = cs.getFileName();
            if (fileName == null) {
                throw new AmetysRepositoryException("fileName is null on CMIS Document '" + this.getCmisDocument().getId() + "'");
            }
        }
        return fileName;
    }

    public AmetysObject getParent() throws AmetysRepositoryException {
        if (this._parent != null) {
            return this._parent;
        }
        String rootPath = this._root.getRootFolder().getPath();
        String rootId = this._root.getRootFolder().getId();
        for (Folder parent : this.getCmisDocument().getParents()) {
            if (!Strings.CS.contains((CharSequence)parent.getPath(), (CharSequence)rootPath)) continue;
            this._parent = Strings.CS.equals(parent.getId(), rootId) ? this.getCmisRoot() : new CMISResourcesCollection(parent, this._root, null);
            return this._parent;
        }
        throw new AmetysRepositoryException("Failed to retrieve the parent of folder " + this.getName() + ". This is most likely due to the fact that we couldn't find one in the CMIS mount point.");
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this.getParent().getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    @Override
    public UserIdentity getCreator() {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY;
    }

    @Override
    public InputStream getInputStream() throws AmetysRepositoryException {
        ContentStream contentStream = this.getCmisDocument().getContentStream();
        if (contentStream != null) {
            return contentStream.getStream();
        }
        return null;
    }

    @Override
    public Date getLastModified() {
        GregorianCalendar calendar = this.getCmisDocument().getLastModificationDate();
        return calendar.getTime();
    }

    @Override
    public long getLength() {
        return this.getCmisDocument().getContentStreamLength();
    }

    @Override
    public String getMimeType() throws AmetysRepositoryException {
        String mimeType = this.getCmisDocument().getContentStreamMimeType();
        return mimeType != null ? mimeType : "application/unknown";
    }

    @Override
    public String[] getKeywords() throws AmetysRepositoryException {
        return new String[0];
    }

    @Override
    public String getKeywordsAsString() throws AmetysRepositoryException {
        return "";
    }

    @Override
    public String getResourcePath() throws AmetysRepositoryException {
        return ((ExplorerNode)this.getParent()).getExplorerPath() + "/" + this.getName();
    }

    public String getDCTitle() throws AmetysRepositoryException {
        return null;
    }

    public String getDCCreator() throws AmetysRepositoryException {
        return null;
    }

    public String[] getDCSubject() throws AmetysRepositoryException {
        return null;
    }

    public String getDCDescription() throws AmetysRepositoryException {
        return null;
    }

    public String getDCPublisher() throws AmetysRepositoryException {
        return null;
    }

    public String getDCContributor() throws AmetysRepositoryException {
        return null;
    }

    public Date getDCDate() throws AmetysRepositoryException {
        return null;
    }

    public String getDCType() throws AmetysRepositoryException {
        return null;
    }

    public String getDCFormat() throws AmetysRepositoryException {
        return null;
    }

    public String getDCIdentifier() throws AmetysRepositoryException {
        return null;
    }

    public String getDCSource() throws AmetysRepositoryException {
        return null;
    }

    public String getDCLanguage() throws AmetysRepositoryException {
        return null;
    }

    public String getDCRelation() throws AmetysRepositoryException {
        return null;
    }

    public String getDCCoverage() throws AmetysRepositoryException {
        return null;
    }

    public String getDCRights() throws AmetysRepositoryException {
        return null;
    }

    @Override
    public Date getCreationDate() throws AmetysRepositoryException {
        GregorianCalendar calendar = this.getCmisDocument().getCreationDate();
        return calendar.getTime();
    }

    @Override
    public UserIdentity getLastContributor() throws AmetysRepositoryException {
        return UserIdentity.stringToUserIdentity((String)this.getCmisDocument().getLastModifiedBy());
    }
}

