/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.cmis;

import java.util.ArrayList;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.cmis.CMISResource;
import org.ametys.plugins.explorer.cmis.CMISRootResourcesCollection;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISResourcesCollection
implements ResourceCollection {
    public static final String APPLICATION_ID = "Ametys.plugins.explorer.applications.resources.Resources";
    private static final Logger __LOGGER = LoggerFactory.getLogger(CMISResourcesCollection.class);
    private final Folder _cmisFolder;
    private final CMISRootResourcesCollection _root;
    private AmetysObject _parent;

    public CMISResourcesCollection(Folder folder, CMISRootResourcesCollection root, AmetysObject parent) {
        this._cmisFolder = folder;
        this._root = root;
        this._parent = parent;
    }

    @Override
    public String getApplicationId() {
        return APPLICATION_ID;
    }

    @Override
    public String getIconCls() {
        return "ametysicon-folder249";
    }

    public String getId() throws AmetysRepositoryException {
        return this.getCmisRoot().getId() + "/" + this.getCmisFolder().getId();
    }

    public String getName() throws AmetysRepositoryException {
        return this.getCmisFolder().getName();
    }

    public CMISRootResourcesCollection getCmisRoot() {
        return this._root;
    }

    public Folder getCmisFolder() {
        return this._cmisFolder;
    }

    public AmetysObject getParent() throws AmetysRepositoryException {
        if (this._parent != null) {
            return this._parent;
        }
        String rootPath = this._root.getRootFolder().getPath();
        String rootId = this._root.getRootFolder().getId();
        for (Folder parent : this._cmisFolder.getParents()) {
            if (!Strings.CS.contains((CharSequence)parent.getPath(), (CharSequence)rootPath)) continue;
            this._parent = Strings.CS.equals(parent.getId(), rootId) ? this.getCmisRoot() : new CMISResourcesCollection(parent, this._root, null);
            return this._parent;
        }
        throw new AmetysRepositoryException("Failed to retrieve the parent of folder " + this.getName() + ". This is most likely due to the fact that we couldn't find one in the CMIS mount point.");
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this.getParent().getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    public AmetysObject getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        Session session = this.getCmisRoot().getSession();
        if (session == null) {
            throw new UnknownAmetysObjectException("Failed to connect to CMIS server");
        }
        CmisObject child = session.getObjectByPath(path);
        BaseTypeId baseTypeId = child.getBaseType().getBaseTypeId();
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
            return new CMISResourcesCollection((Folder)child, this._root, this);
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            Document cmisDoc = (Document)child;
            if (cmisDoc.getContentStream() != null) {
                return new CMISResource((Document)child, this._root, this);
            }
            throw new UnknownAmetysObjectException("The CMIS document " + path + " has no content");
        }
        throw new UnknownAmetysObjectException("Unhandled CMIS type '" + String.valueOf(baseTypeId) + "', cannot get child at path " + path);
    }

    public CollectionIterable<AmetysObject> getChildren() throws AmetysRepositoryException {
        ArrayList<Object> aoChildren = new ArrayList<Object>();
        ItemIterable children = this.getCmisFolder().getChildren();
        for (CmisObject child : children) {
            BaseTypeId baseTypeId = child.getBaseTypeId();
            if (baseTypeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
                aoChildren.add(new CMISResourcesCollection((Folder)child, this._root, this));
                continue;
            }
            if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
                Document cmisDoc = (Document)child;
                if (!StringUtils.isNotEmpty((CharSequence)cmisDoc.getContentStreamFileName())) continue;
                aoChildren.add(new CMISResource(cmisDoc, this._root, this));
                continue;
            }
            __LOGGER.warn("Unhandled CMIS type {}. It will be ignored.", (Object)baseTypeId);
        }
        return new CollectionIterable(aoChildren);
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        ItemIterable children = this._cmisFolder.getChildren();
        for (CmisObject child : children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildResources() throws AmetysRepositoryException {
        return true;
    }

    @Override
    public boolean hasChildExplorerNodes() throws AmetysRepositoryException {
        return true;
    }

    @Override
    public String getExplorerPath() {
        AmetysObject parent = this.getParent();
        if (parent instanceof ExplorerNode) {
            return ((ExplorerNode)parent).getExplorerPath() + "/" + this.getName();
        }
        return "";
    }

    @Override
    public String getResourcePath() throws AmetysRepositoryException {
        return this.getExplorerPath();
    }

    @Override
    public String getDescription() {
        return null;
    }
}

