/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.cmis;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.cmis.CMISResource;
import org.ametys.plugins.explorer.cmis.CMISResourcesCollection;
import org.ametys.plugins.explorer.cmis.CMISTreeFactory;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AbstractAmetysObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.jcr.JCRCompositeMetadata;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISRootResourcesCollection
extends AbstractAmetysObject
implements JCRAmetysObject,
ResourceCollection,
ModifiableModelLessDataAwareAmetysObject {
    public static final String APPLICATION_ID = "Ametys.plugins.explorer.applications.resources.Resources";
    public static final String DATA_REPOSITORY_ID = "repositoryId";
    public static final String DATA_REPOSITORY_URL = "repositoryUrl";
    public static final String DATA_MOUNT_POINT = "mountPoint";
    public static final String DATA_USER = "user";
    public static final String DATA_PASSWORD = "password";
    private static final Logger __LOGGER = LoggerFactory.getLogger(CMISResourcesCollection.class);
    private final CMISTreeFactory _factory;
    private final Node _node;
    private String _name;
    private String _parentPath;
    private Session _session;
    private Folder _root;

    public CMISRootResourcesCollection(Node node, String parentPath, CMISTreeFactory factory) {
        this._node = node;
        this._parentPath = parentPath;
        this._factory = factory;
        try {
            this._name = this._node.getName();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get node name", (Throwable)e);
        }
    }

    void connect(Session session, Folder root) {
        this._session = session;
        this._root = root;
    }

    Session getSession() {
        return this._session;
    }

    Folder getRootFolder() {
        return this._root;
    }

    public AmetysObject getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        CmisObject entry;
        CmisObject object;
        BaseTypeId baseTypeId;
        if (this._session == null) {
            throw new UnknownAmetysObjectException("Failed to connect to CMIS server");
        }
        Object mountPoint = (String)StringUtils.defaultIfBlank((CharSequence)this.getMountPoint(), (CharSequence)"/");
        if (!((String)mountPoint).startsWith("/")) {
            mountPoint = "/" + (String)mountPoint;
        }
        if (!((String)mountPoint).endsWith("/")) {
            mountPoint = (String)mountPoint + "/";
        }
        Object remotePath = (String)mountPoint + path;
        if (path.endsWith("/") && ((String)remotePath).length() != 1) {
            remotePath = ((String)remotePath).substring(0, ((String)remotePath).length() - 1);
        }
        if ((baseTypeId = (object = this._session.getObject((ObjectId)(entry = this._session.getObjectByPath((String)remotePath)))).getBaseType().getBaseTypeId()).equals((Object)BaseTypeId.CMIS_FOLDER)) {
            return new CMISResourcesCollection((Folder)object, this, null);
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            return new CMISResource((Document)object, this, null);
        }
        throw new UnknownAmetysObjectException("Unhandled CMIS type '" + String.valueOf(baseTypeId) + "', cannot get child at path " + path);
    }

    public CollectionIterable<AmetysObject> getChildren() throws AmetysRepositoryException {
        ArrayList<Object> aoChildren = new ArrayList<Object>();
        if (this._session == null) {
            return new CollectionIterable(aoChildren);
        }
        ItemIterable children = this._root.getChildren();
        for (CmisObject child : children) {
            BaseTypeId typeId = child.getBaseTypeId();
            if (typeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
                aoChildren.add(new CMISResourcesCollection((Folder)child, this, this));
                continue;
            }
            if (typeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
                Document cmisDoc = (Document)child;
                if (!StringUtils.isNotEmpty((CharSequence)cmisDoc.getContentStreamFileName())) continue;
                aoChildren.add(new CMISResource(cmisDoc, this, this));
                continue;
            }
            __LOGGER.warn("Unhandled CMIS type {}. It will be ignored.", (Object)typeId);
        }
        return new CollectionIterable(aoChildren);
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        if (this._session == null) {
            return false;
        }
        ItemIterable children = this._root.getChildren();
        for (CmisObject child : children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder(this._factory.getDataTypesExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }

    public ModifiableCompositeMetadata getMetadataHolder() {
        return new JCRCompositeMetadata(this.getNode(), this._factory._resolver);
    }

    @Override
    public String getIconCls() {
        if (this._session == null) {
            return "ametysicon-share40 decorator-ametysicon-sign-caution a-tree-decorator-error-color";
        }
        String productName = this._session.getRepositoryInfo().getProductName();
        if (productName.toLowerCase().indexOf("alfresco") != -1) {
            return "ametysicon-share40";
        }
        if (productName.toLowerCase().indexOf("nuxeo") != -1) {
            return "ametysicon-share40";
        }
        return "ametysicon-share40";
    }

    @Override
    public String getApplicationId() {
        return APPLICATION_ID;
    }

    public String getName() throws AmetysRepositoryException {
        return this._name;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._parentPath == null) {
            this._parentPath = this.getParent().getPath();
        }
        return this._parentPath;
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    public Node getNode() {
        return this._node;
    }

    public String getId() {
        try {
            return this._factory.getScheme() + "://" + this._node.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get node UUID", (Throwable)e);
        }
    }

    @Override
    public boolean hasChildResources() throws AmetysRepositoryException {
        return true;
    }

    @Override
    public boolean hasChildExplorerNodes() throws AmetysRepositoryException {
        return true;
    }

    public void rename(String newName) throws AmetysRepositoryException {
        try {
            this.getNode().getSession().move(this.getNode().getPath(), this.getNode().getParent().getPath() + "/" + newName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    public void remove() throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        try {
            this.getNode().remove();
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryIntegrityViolationException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    public <A extends AmetysObject> A getParent() throws AmetysRepositoryException {
        return (A)this._factory.getParent(this);
    }

    public void saveChanges() throws AmetysRepositoryException {
        try {
            this.getNode().getSession().save();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to save changes", (Throwable)e);
        }
    }

    public void revertChanges() throws AmetysRepositoryException {
        try {
            this.getNode().refresh(false);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to revert changes.", (Throwable)e);
        }
    }

    public boolean needsSave() throws AmetysRepositoryException {
        try {
            return this._node.getSession().hasPendingChanges();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    @Override
    public String getResourcePath() throws AmetysRepositoryException {
        return this.getExplorerPath();
    }

    @Override
    public String getExplorerPath() {
        Object parent = this.getParent();
        if (parent instanceof ExplorerNode) {
            return ((ExplorerNode)parent).getExplorerPath() + "/" + this.getName();
        }
        return "";
    }

    public String getUser() throws AmetysRepositoryException {
        return (String)this.getValue(DATA_USER);
    }

    public String getPassword() throws AmetysRepositoryException {
        return (String)this.getValue(DATA_PASSWORD);
    }

    public String getRepositoryUrl() throws AmetysRepositoryException {
        return (String)this.getValue(DATA_REPOSITORY_URL);
    }

    public String getRepositoryId() throws AmetysRepositoryException {
        return (String)this.getValue(DATA_REPOSITORY_ID);
    }

    public String getMountPoint() throws AmetysRepositoryException {
        return (String)this.getValue(DATA_MOUNT_POINT);
    }

    public void setRepositoryUrl(String url) throws AmetysRepositoryException {
        this.setValue(DATA_REPOSITORY_URL, url);
    }

    public void setRepositoryId(String id) throws AmetysRepositoryException {
        this.setValue(DATA_REPOSITORY_ID, id);
    }

    public void setMountPoint(String mountPoint) {
        this.setValue(DATA_MOUNT_POINT, mountPoint);
    }

    public void setUser(String user) {
        this.setValue(DATA_USER, user);
    }

    public void setPassword(String password) {
        this.setValue(DATA_PASSWORD, password);
    }

    @Override
    public String getDescription() {
        return null;
    }
}

