/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.cmis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.explorer.cmis.CMISResource;
import org.ametys.plugins.explorer.cmis.CMISResourcesCollection;
import org.ametys.plugins.explorer.cmis.CMISRootResourcesCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.JCRAmetysObjectFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class CMISTreeFactory
extends AbstractLogEnabled
implements JCRAmetysObjectFactory<AmetysObject>,
Configurable,
Serviceable,
Initializable,
Observer {
    public static final String CMIS_ROOT_COLLECTION_NODETYPE = "ametys:cmis-root-collection";
    private static final String __SESSION_CACHE = CMISTreeFactory.class.getName() + "$cmisSessionCache";
    protected AmetysObjectResolver _resolver;
    protected String _scheme;
    protected String _nodetype;
    protected javax.jcr.Repository _repository;
    private ObservationManager _observationManager;
    private AbstractCacheManager _cacheManager;
    private ModelItemTypeExtensionPoint _modelLessBasicTypesExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._repository = (javax.jcr.Repository)manager.lookup("javax.jcr.Repository");
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._modelLessBasicTypesExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_MODEL_LESS_BASIC);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._scheme = configuration.getChild("scheme").getValue();
        Configuration[] nodetypesConf = configuration.getChildren("nodetype");
        if (nodetypesConf.length != 1) {
            throw new ConfigurationException("A SimpleAmetysObjectFactory must have one and only one associated nodetype. The '" + configuration.getAttribute("id") + "' component has " + nodetypesConf.length);
        }
        this._nodetype = nodetypesConf[0].getValue();
    }

    public void initialize() throws Exception {
        this._observationManager.registerObserver((Observer)this);
        this._cacheManager.createMemoryCache(__SESSION_CACHE, new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_CACHE_CMIS_SESSION_LABEL"), new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_CACHE_CMIS_SESSION_DESCRIPTION"), true, null);
    }

    public CMISRootResourcesCollection getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException, RepositoryException {
        CMISRootResourcesCollection root;
        block11: {
            root = new CMISRootResourcesCollection(node, parentPath, this);
            if (!root.hasValue("repositoryUrl")) {
                return root;
            }
            try {
                org.apache.chemistry.opencmis.client.api.Session session = this.getAtomPubSession(root);
                Folder rootFolder = null;
                if (session == null) break block11;
                String mountPoint = root.getMountPoint();
                if (StringUtils.isBlank((CharSequence)mountPoint) || Strings.CS.equals(mountPoint, "/")) {
                    rootFolder = session.getRootFolder();
                } else if (StringUtils.isNotBlank((CharSequence)mountPoint) && Strings.CS.startsWith((CharSequence)mountPoint, (CharSequence)"/")) {
                    try {
                        rootFolder = (Folder)session.getObjectByPath(mountPoint);
                    }
                    catch (CmisObjectNotFoundException e) {
                        this.getLogger().error("The mount point '{}' can't be found in the remote repository {}", new Object[]{mountPoint, root.getRepositoryId(), e});
                    }
                }
                if (rootFolder != null) {
                    root.connect(session, rootFolder);
                }
            }
            catch (CmisConnectionException e) {
                this.getLogger().error("Connection to CMIS Atom Pub service failed", (Throwable)e);
            }
            catch (CmisObjectNotFoundException e) {
                this.getLogger().error("The CMIS Atom Pub service url refers to a non-existent repository", (Throwable)e);
            }
            catch (CmisBaseException e) {
                this.getLogger().error("An error occured during call of CMIS Atom Pub service", (Throwable)e);
            }
        }
        return root;
    }

    public AmetysObject getAmetysObjectById(String id) throws AmetysRepositoryException {
        String uuid = id.substring(this.getScheme().length() + 3);
        int index = uuid.indexOf("/");
        if (index != -1) {
            CMISRootResourcesCollection root = this.getCMISRootResourceCollection(this.getScheme() + "://" + uuid.substring(0, index));
            org.apache.chemistry.opencmis.client.api.Session session = root.getSession();
            if (session == null) {
                throw new UnknownAmetysObjectException("Connection to CMIS server failed");
            }
            ObjectId cmisID = session.createObjectId(uuid.substring(index + 1));
            CmisObject cmisObject = session.getObject(cmisID);
            BaseTypeId baseTypeId = cmisObject.getBaseTypeId();
            if (baseTypeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
                return new CMISResourcesCollection((Folder)cmisObject, root, null);
            }
            if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
                Document cmisDoc = (Document)cmisObject;
                try {
                    if (!cmisDoc.isLatestVersion().booleanValue()) {
                        cmisDoc = cmisDoc.getObjectOfLatestVersion(false);
                    }
                }
                catch (CmisBaseException cmisBaseException) {
                    // empty catch block
                }
                return new CMISResource(cmisDoc, root, null);
            }
            throw new IllegalArgumentException("Unhandled CMIS type: " + String.valueOf(baseTypeId));
        }
        return this.getCMISRootResourceCollection(id);
    }

    public AmetysObject getAmetysObjectById(String id, Session session) throws AmetysRepositoryException, RepositoryException {
        return this.getAmetysObjectById(id);
    }

    protected CMISRootResourcesCollection getCMISRootResourceCollection(String id) throws AmetysRepositoryException {
        try {
            Node node = this.getNode(id);
            if (!node.getPath().startsWith("/ametys:root")) {
                throw new AmetysRepositoryException("Cannot resolve a Node outside Ametys tree");
            }
            return this.getAmetysObject(node, null);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get AmetysObject for id: " + id, (Throwable)e);
        }
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String uuid = id.substring(this.getScheme().length() + 3);
        int index = uuid.indexOf("/");
        if (index != -1) {
            CMISRootResourcesCollection root = this.getCMISRootResourceCollection(uuid.substring(0, index));
            org.apache.chemistry.opencmis.client.api.Session session = root.getSession();
            if (session == null) {
                return false;
            }
            ObjectId cmisID = session.createObjectId(uuid.substring(index + 1));
            return session.getObject(cmisID) == null;
        }
        try {
            this.getNode(id);
            return true;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public Collection<String> getNodetypes() {
        return Collections.singletonList(this._nodetype);
    }

    public AmetysObject getParent(CMISRootResourcesCollection object) throws AmetysRepositoryException {
        try {
            Node node = object.getNode();
            Node parentNode = node.getParent();
            return this._resolver.resolve(parentNode, false);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to retrieve parent object of object " + object.getName(), (Throwable)e);
        }
    }

    protected Node getNode(String id) {
        String uuid = id.substring(this.getScheme().length() + 3);
        Session session = null;
        try {
            session = this._repository.login();
            Node node = session.getNodeByIdentifier(uuid);
            return node;
        }
        catch (ItemNotFoundException e) {
            if (session != null) {
                session.logout();
            }
            throw new UnknownAmetysObjectException("There's no node for id " + id, (Throwable)e);
        }
        catch (RepositoryException e) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("Unable to get AmetysObject for id: " + id, (Throwable)e);
        }
    }

    public org.apache.chemistry.opencmis.client.api.Session getAtomPubSession(CMISRootResourcesCollection root) {
        Cache sessionCache = this._cacheManager.get(__SESSION_CACHE);
        String rootId = root.getId();
        return (org.apache.chemistry.opencmis.client.api.Session)sessionCache.get((Object)rootId, key -> this._getAtomPubSession(root));
    }

    private org.apache.chemistry.opencmis.client.api.Session _getAtomPubSession(CMISRootResourcesCollection root) {
        String url = root.getRepositoryUrl();
        String user = root.getUser();
        String password = root.getPassword();
        String repositoryId = root.getRepositoryId();
        try {
            SessionFactoryImpl f;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("org.apache.chemistry.opencmis.user", user);
            params.put("org.apache.chemistry.opencmis.password", password);
            params.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
            params.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            if (StringUtils.isEmpty((CharSequence)repositoryId)) {
                f = SessionFactoryImpl.newInstance();
                List repositories = f.getRepositories(params);
                repositoryId = ((Repository)repositories.listIterator().next()).getId();
                root.setRepositoryId(repositoryId);
                root.saveChanges();
            }
            params.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
            f = SessionFactoryImpl.newInstance();
            org.apache.chemistry.opencmis.client.api.Session session = f.createSession(params);
            return session;
        }
        catch (CmisConnectionException e) {
            this.getLogger().error("Connection to CMIS Atom Pub service ({}) failed", (Object)url, (Object)e);
        }
        catch (CmisObjectNotFoundException e) {
            this.getLogger().error("The CMIS Atom Pub service url ({}) refers to a non-existent repository ({})", new Object[]{url, repositoryId, e});
        }
        catch (CmisBaseException e) {
            this.getLogger().error("An error occured during call of CMIS Atom Pub service ({})", (Object)url, (Object)e);
        }
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public boolean supports(Event event) {
        String eventType = event.getId();
        return "collection.deleted".equals(eventType) || "cmis.collection.updated".equals(eventType);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String rootId;
        Cache sessionCache = this._cacheManager.get(__SESSION_CACHE);
        if (sessionCache.hasKey((Object)(rootId = (String)event.getArguments().get("object.id")))) {
            sessionCache.invalidate((Object)rootId);
        }
    }

    public ModelItemTypeExtensionPoint getDataTypesExtensionPoint() {
        return this._modelLessBasicTypesExtensionPoint;
    }
}

