/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.IOException;
import java.util.Map;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DublinCoreMetadataGenerator
extends ServiceableGenerator {
    private ExplorerResourcesDAO _resourceDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resourceDAO = (ExplorerResourcesDAO)((Object)serviceManager.lookup(ExplorerResourcesDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = this.parameters.getParameter("id", request.getParameter("id"));
        Map<String, Object> dcMetadata = this._resourceDAO.getDCMetadata(id);
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", id);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"object", (Attributes)atts);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"dublin-core-metadata");
        for (String metadataName : dcMetadata.keySet()) {
            this._saxIfNotNull(metadataName, dcMetadata.get(metadataName));
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"dublin-core-metadata");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"object");
        this.contentHandler.endDocument();
    }

    protected void _saxIfNotNull(String name, Object value) throws SAXException {
        if (value != null) {
            if (value instanceof String[]) {
                for (String val : (String[])value) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)name, (String)val);
                }
            } else if (value instanceof String) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)name, (String)((String)value));
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)name, (String)String.valueOf(value));
            }
        }
    }
}

