/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;

public class DublinCoreMetadataProvider
extends AbstractLogEnabled
implements Component,
Contextualizable,
ThreadSafe,
Initializable {
    public static final String ROLE = DublinCoreMetadataProvider.class.getName();
    private Map<String, Map<String, I18nizableText>> _entries;
    private Context _cocoonContext;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void initialize() throws Exception {
        this._entries = new HashMap<String, Map<String, I18nizableText>>();
    }

    public Set<String> getEnumeratedMetadataNames() {
        HashSet<String> metadataNames = new HashSet<String>();
        File dcFile = new File(this._cocoonContext.getRealPath("/WEB-INF/param/dublincore"));
        if (dcFile.exists()) {
            File[] xmlFiles;
            for (File xmlFile : xmlFiles = dcFile.listFiles(new FileFilter(this){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            })) {
                String filename = xmlFile.getName().toLowerCase();
                metadataNames.add(filename.substring(0, filename.lastIndexOf(".")));
            }
        }
        return metadataNames;
    }

    public boolean isEnumerated(String metadataName) {
        File file = new File(this._cocoonContext.getRealPath("/WEB-INF/param/dublincore/" + metadataName + ".xml"));
        return file.exists();
    }

    public Map<String, I18nizableText> getEntries(String metadataName) {
        if (!this.isEnumerated(metadataName)) {
            return null;
        }
        try {
            if (!this._entries.containsKey(metadataName)) {
                this._parseFile(metadataName);
            }
            return this._entries.get(metadataName);
        }
        catch (ConfigurationException e) {
            this.getLogger().warn("Unable to get enumerated values of DublinCore metadata '" + metadataName + "'", (Throwable)e);
            return null;
        }
    }

    public I18nizableText getEntry(String metadataName, String value) {
        if (!this.isEnumerated(metadataName)) {
            return null;
        }
        try {
            if (!this._entries.containsKey(metadataName)) {
                this._parseFile(metadataName);
            }
            return this._entries.get(metadataName).get(value);
        }
        catch (ConfigurationException e) {
            this.getLogger().warn("Unable to get enumerated values of DublinCore metadata '" + metadataName + "'", (Throwable)e);
            return null;
        }
    }

    protected void _parseFile(String metadataName) throws ConfigurationException {
        File file = new File(this._cocoonContext.getRealPath("/WEB-INF/param/dublincore/" + metadataName + ".xml"));
        if (file.exists()) {
            try (FileInputStream is = new FileInputStream(file);){
                Configuration configuration = new DefaultConfigurationBuilder().build((InputStream)is);
                Map<String, I18nizableText> entries = this._parseEnumerator(configuration);
                this._entries.put(metadataName, entries);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to read the configuration file " + file.getName(), (Throwable)e);
            }
        }
    }

    protected Map<String, I18nizableText> _parseEnumerator(Configuration configuration) throws ConfigurationException {
        HashMap<String, I18nizableText> entries = new HashMap<String, I18nizableText>();
        for (Configuration entryConfig : configuration.getChildren("entry")) {
            String value = entryConfig.getChild("value").getValue();
            I18nizableText label = null;
            if (entryConfig.getChild("label", false) != null) {
                label = this._parseI18nizableText(entryConfig, "label");
            }
            entries.put(value, label);
        }
        return entries;
    }

    protected I18nizableText _parseI18nizableText(Configuration config, String name) throws ConfigurationException {
        return I18nizableText.parseI18nizableText((Configuration)config.getChild(name), (String)"application");
    }
}

