/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.IOException;
import java.util.Map;
import org.ametys.plugins.explorer.dublincore.DublinCoreMetadataProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EnumeratedValuesGenerator
extends ServiceableGenerator {
    private DublinCoreMetadataProvider _dcProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._dcProvider = (DublinCoreMetadataProvider)((Object)smanager.lookup(DublinCoreMetadataProvider.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String metadataName = this.parameters.getParameter("metadataName", null);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"enumeration");
        if (metadataName != null && this._dcProvider.isEnumerated(metadataName)) {
            Map<String, I18nizableText> entries = this._dcProvider.getEntries(metadataName);
            for (String value : entries.keySet()) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (String)value);
                I18nizableText label = entries.get(value);
                if (label != null) {
                    label.toSAX(this.contentHandler, "label");
                } else {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)value);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"enumeration");
        this.contentHandler.endDocument();
    }
}

