/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public class RDFResourceReader
extends ServiceableReader {
    protected AmetysObjectResolver _resolver;
    protected SourceResolver _srcResolver;
    protected Resource _object;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._resolver = (AmetysObjectResolver)sManager.lookup(AmetysObjectResolver.ROLE);
        this._srcResolver = (SourceResolver)sManager.lookup(SourceResolver.ROLE);
    }

    public void setup(org.apache.cocoon.environment.SourceResolver sResolver, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(sResolver, objModel, src, par);
        String id = par.getParameter("id", null);
        String path = par.getParameter("path", null);
        assert (id != null || path != null);
        this._object = id != null ? (Resource)this._resolver.resolveById(id) : (Resource)this._resolver.resolveByPath(path);
    }

    public long getLastModified() {
        return this._object.getLastModified().getTime();
    }

    public String getMimeType() {
        return "application/rdf+xml";
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Source src = null;
        try {
            Object name = this._object.getName();
            name = ((String)name).substring(0, ((String)name).lastIndexOf(".")) + ".rdf";
            name = ((String)name).replaceAll("\\\\", "\\\\\\\\");
            name = ((String)name).replaceAll("\\\"", "\\\\\\\"");
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + (String)name + "\"");
            src = this._srcResolver.resolveURI("cocoon://plugins/explorer/dublincore/rdf?id=" + this._object.getId(), null, new HashMap());
            try (InputStream is = src.getInputStream();){
                response.setHeader("Content-Length", Long.toString(src.getContentLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
        catch (Exception e) {
            try {
                throw new ProcessingException("Unable to download file of id " + this._object.getId(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)this.out);
                if (src != null) {
                    this._srcResolver.release(src);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)this.out);
        if (src != null) {
            this._srcResolver.release(src);
        }
    }

    public void recycle() {
        super.recycle();
        this._object = null;
    }
}

