/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;

public class AddOrUpdateResource
implements Serviceable,
Contextualizable,
Component {
    public static final String ROLE = AddOrUpdateResource.class.getName();
    protected AddOrUpdateResourceHelper _addOrUpdateResourceHelper;
    protected Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._addOrUpdateResourceHelper = (AddOrUpdateResourceHelper)((Object)serviceManager.lookup(AddOrUpdateResourceHelper.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Plugin_Explorer_File_Add"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map addOrUpdateResources(String parentId, String rawMode, Boolean unzip, List<Part> parts) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList resultsForFileSuccess = new ArrayList();
            for (Part part : parts) {
                HashMap<String, Object> resultForPart = new HashMap<String, Object>();
                String rawModeForPart = rawMode;
                if (unzip.booleanValue() && part.getFileName().endsWith(".zip")) {
                    rawModeForPart = "add-unzip";
                }
                AddOrUpdateResourceHelper.ResourceOperationMode mode = AddOrUpdateResourceHelper.ResourceOperationMode.createsFromRawMode(rawModeForPart);
                this._addOrUpdateResourceHelper.checkAddResourceRight(parentId);
                AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation(part, parentId, mode);
                if (!operationResult.isSuccess()) {
                    Map errors = (Map)result.computeIfAbsent("message", l -> new HashMap());
                    errors.put(part.getFileName(), operationResult.getErrorMessage());
                    continue;
                }
                result.put("parentID", parentId);
                result.put("success", true);
                if (operationResult.isUnzip()) {
                    resultForPart.put("unzip", true);
                    resultForPart.put("reload", true);
                } else {
                    Resource resource = operationResult.getResource();
                    resultForPart.put("id", resource.getId());
                    resultForPart.put("name", resource.getName());
                }
                resultsForFileSuccess.add(resultForPart);
            }
            result.put("resultsForFileSuccess", resultsForFileSuccess);
            request.setAttribute(JSonReader.OBJECT_TO_READ, result);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

