/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.actions;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang.IllegalClassException;

public final class AddOrUpdateResourceHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = AddOrUpdateResourceHelper.class.getName();
    protected ExplorerResourcesDAO _resourcesDAO;
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resourcesDAO = (ExplorerResourcesDAO)((Object)serviceManager.lookup(ExplorerResourcesDAO.ROLE));
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public void checkAddResourceRight(String folderId) {
        AmetysObject folder = this._resolver.resolveById(folderId);
        if (!(folder instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, folder.getClass());
        }
        this.checkAddResourceRight((ModifiableResourceCollection)folder);
    }

    public void checkAddResourceRight(ModifiableResourceCollection folder) {
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Add", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to add file without convenient right [Plugin_Explorer_File_Add]");
        }
    }

    public ResourceOperationResult performResourceOperation(Part part, String parentId, ResourceOperationMode mode) {
        try {
            AmetysObject object = this._resolver.resolveById(parentId);
            if (!(object instanceof ModifiableResourceCollection)) {
                throw new IllegalClassException(ModifiableResourceCollection.class, object.getClass());
            }
            return this.performResourceOperation(part, (ModifiableResourceCollection)object, mode);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Unable to add file : the collection of id '{}' does not exist anymore", (Object)parentId, (Object)e);
            return new ResourceOperationResult("unknown-collection");
        }
    }

    public ResourceOperationResult performResourceOperation(Part part, ModifiableResourceCollection parent, ResourceOperationMode mode) {
        ResourceOperationResult resourceOperationResult;
        block11: {
            RejectedPart rejectedPart;
            if (part instanceof RejectedPart && (rejectedPart = (RejectedPart)part).getMaxContentLength() == 0) {
                return new ResourceOperationResult("infected");
            }
            if (part == null || part instanceof RejectedPart) {
                return new ResourceOperationResult("rejected");
            }
            if (!this._resourcesDAO.checkLock(parent)) {
                this.getLogger().warn("User '{}' is trying to modify the collection '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)parent.getName());
                return new ResourceOperationResult("locked");
            }
            String fileName = part.getUploadName();
            InputStream is = part.getInputStream();
            try {
                resourceOperationResult = this.performResourceOperation(is, fileName, parent, mode);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to add file to the collection of id '{}'", (Object)parent.getId(), (Object)e);
                    return new ResourceOperationResult("error");
                }
            }
            is.close();
        }
        return resourceOperationResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceOperationResult performResourceOperation(InputStream inputStream, String fileName, ModifiableResourceCollection parent, ResourceOperationMode mode) {
        Object usedFileName = fileName;
        if (!Normalizer.isNormalized((CharSequence)usedFileName, Normalizer.Form.NFC)) {
            usedFileName = Normalizer.normalize((CharSequence)usedFileName, Normalizer.Form.NFC);
        }
        if (!this._resourcesDAO.checkLock(parent)) {
            this.getLogger().warn("User '{}' is trying to modify the collection '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)parent.getName());
            return new ResourceOperationResult("locked");
        }
        if (fileName.toLowerCase().endsWith(".zip") && ResourceOperationMode.ADD_UNZIP.equals((Object)mode)) {
            return this._unzip(parent, inputStream);
        }
        ModifiableResource resource = null;
        if (parent.hasChild((String)usedFileName)) {
            if (ResourceOperationMode.ADD_RENAME.equals((Object)mode)) {
                String[] f = ((String)usedFileName).split("\\.");
                int index = 1;
                while (parent.hasChild((String)usedFileName)) {
                    usedFileName = f[0] + "-" + index++ + "." + f[1];
                }
                resource = this._resourcesDAO.createResource(parent, (String)usedFileName);
            } else {
                if (!ResourceOperationMode.UPDATE.equals((Object)mode)) return new ResourceOperationResult("already-exist");
                resource = (ModifiableResource)parent.getChild((String)usedFileName);
            }
        } else {
            resource = this._resourcesDAO.createResource(parent, (String)usedFileName);
        }
        try {
            if (!this._resourcesDAO.checkLock((AmetysObject)resource)) {
                this.getLogger().warn("User '{}' is trying to modify the resource '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)parent.getName());
                return new ResourceOperationResult("locked-file");
            }
            this._resourcesDAO.updateResource(resource, inputStream, fileName);
            parent.saveChanges();
            this._resourcesDAO.checkpoint(resource);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to add file to the collection of id '{}'", (Object)parent.getId(), (Object)e);
            return new ResourceOperationResult("error");
        }
        if (ResourceOperationMode.UPDATE.equals((Object)mode)) {
            this._notifyResourcesUpdated(parent, resource);
            return new ResourceOperationResult(resource);
        } else {
            this._notifyResourcesCreated(parent, Collections.singletonList(resource));
        }
        return new ResourceOperationResult(resource);
    }

    protected void _notifyResourcesCreated(ModifiableResourceCollection parent, List<Resource> resources) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        Map resourceMap = resources.stream().collect(Collectors.toMap(AmetysObject::getId, Function.identity(), (u, v) -> u, LinkedHashMap::new));
        eventParams.put("resources", resourceMap);
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.parent.path", parent.getPath());
        this._observationManager.notify(new Event("resource.created", this._currentUserProvider.getUser(), eventParams));
    }

    protected void _notifyResourcesUpdated(ModifiableResourceCollection parent, Resource resource) {
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", resource.getId());
        eventParams.put("object.name", resource.getName());
        eventParams.put("object.path", resource.getPath());
        eventParams.put("resource.path", resource.getResourcePath());
        eventParams.put("object.parent", parent.getId());
        this._observationManager.notify(new Event("resource.updated", this._currentUserProvider.getUser(), eventParams));
    }

    private ResourceOperationResult _unzip(ModifiableResourceCollection collection, InputStream inputStream) {
        ResourceOperationResult resourceOperationResult;
        ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream, "cp437");
        try {
            List<Resource> extractedResources = this._unzip(collection, zipInputStream);
            this._notifyResourcesCreated(collection, extractedResources);
            resourceOperationResult = new ResourceOperationResult(extractedResources);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getLogger().error("Unable to unzip file", (Throwable)e);
                return new ResourceOperationResult("unzip-error");
            }
        }
        zipInputStream.close();
        return resourceOperationResult;
    }

    private List<Resource> _unzip(ModifiableResourceCollection collection, ZipArchiveInputStream zipInputStream) throws IOException {
        ZipArchiveEntry zipEntry;
        LinkedList<Resource> extractedResources = new LinkedList<Resource>();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            ModifiableResourceCollection parentCollection = collection;
            String zipName = zipEntry.getName();
            String[] path = zipName.split("/");
            for (int i = 0; i < path.length - 1; ++i) {
                String name = path[i];
                parentCollection = this._addCollection(parentCollection, name);
            }
            String name = path[path.length - 1];
            if (zipEntry.isDirectory()) {
                parentCollection = this._addCollection(parentCollection, name);
                continue;
            }
            Resource resource = this._addZipEntry(parentCollection, (InputStream)zipInputStream, name);
            extractedResources.add(resource);
        }
        Ordering resourceNameOrdering = Ordering.natural().onResultOf(AmetysObject::getName);
        extractedResources.sort((Comparator<Resource>)resourceNameOrdering);
        return extractedResources;
    }

    private ModifiableResourceCollection _addCollection(ModifiableResourceCollection collection, String name) {
        if (collection.hasChild(name)) {
            return (ModifiableResourceCollection)collection.getChild(name);
        }
        ModifiableResourceCollection child = (ModifiableResourceCollection)collection.createChild(name, collection.getCollectionType());
        collection.saveChanges();
        return child;
    }

    private Resource _addZipEntry(ModifiableResourceCollection collection, InputStream zipInputStream, String fileName) {
        ModifiableResource resource = collection.hasChild(fileName) ? (ModifiableResource)collection.getChild(fileName) : this._resourcesDAO.createResource(collection, fileName);
        try (CloseShieldInputStream csis = CloseShieldInputStream.wrap((InputStream)zipInputStream);){
            this._resourcesDAO.updateResource(resource, (InputStream)csis, fileName);
        }
        collection.saveChanges();
        this._resourcesDAO.checkpoint(resource);
        return resource;
    }

    public static enum ResourceOperationMode {
        ADD("add"),
        ADD_UNZIP("add-unzip"),
        ADD_RENAME("add-rename"),
        UPDATE("update");

        private String _mode;

        private ResourceOperationMode(String mode) {
            this._mode = mode;
        }

        public String toString() {
            return this._mode;
        }

        public static ResourceOperationMode createsFromRawMode(String mode) {
            for (ResourceOperationMode entry : ResourceOperationMode.values()) {
                if (!entry.toString().equals(mode)) continue;
                return entry;
            }
            return null;
        }
    }

    public static class ResourceOperationResult {
        private final List<Resource> _resources;
        private final boolean _unzip;
        private final boolean _success;
        private final String _errorMessage;

        protected ResourceOperationResult(Resource resource) {
            this._resources = Collections.singletonList(resource);
            this._unzip = false;
            this._success = true;
            this._errorMessage = null;
        }

        protected ResourceOperationResult(List<Resource> resources) {
            this._resources = resources;
            this._unzip = true;
            this._success = true;
            this._errorMessage = null;
        }

        protected ResourceOperationResult(String errorMessage) {
            this._errorMessage = errorMessage;
            this._success = false;
            this._resources = null;
            this._unzip = false;
        }

        public Resource getResource() {
            return this._resources.get(0);
        }

        public List<Resource> getResources() {
            return this._resources;
        }

        public boolean isUnzip() {
            return this._unzip;
        }

        public boolean isSuccess() {
            return this._success;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }
    }
}

