/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import org.ametys.core.file.TikaProvider;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.cmis.CMISRootResourcesCollection;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.metadata.populate.ResourceMetadataPopulator;
import org.ametys.plugins.explorer.resources.metadata.populate.ResourceMetadataPopulatorExtensionPoint;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.dublincore.DublinCoreAwareAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.tika.metadata.Metadata;

public class ExplorerResourcesDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = ExplorerResourcesDAO.class.getName();
    public static final String RIGHTS_RESOURCE_UNLOCK_ALL = "Plugin_Explorer_File_Unlock_All";
    public static final String RIGHTS_RESOURCE_ADD = "Plugin_Explorer_File_Add";
    public static final String RIGHTS_RESOURCE_RENAME = "Plugin_Explorer_File_Rename";
    public static final String RIGHTS_RESOURCE_DELETE = "Plugin_Explorer_File_Delete";
    public static final String RIGHTS_RESOURCE_EDIT_DC = "Plugin_Explorer_File_Edit_DC_Metadata";
    public static final String RIGHTS_RESOURCE_MODERATE_COMMENT = "Plugin_Explorer_File_Moderate_Comments";
    public static final String RIGHTS_COLLECTION_CMIS_ADD = "Plugin_Explorer_CMIS_Add";
    public static final String RIGHTS_COLLECTION_ADD = "Plugin_Explorer_Folder_Add";
    public static final String RIGHTS_COLLECTION_EDIT = "Plugin_Explorer_Folder_Edit";
    public static final String RIGHTS_COLLECTION_DELETE = "Plugin_Explorer_Folder_Delete";
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected TikaProvider _tikaProvider;
    protected ResourceMetadataPopulatorExtensionPoint _metadataPopulatorEP;
    protected UserHelper _userHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._tikaProvider = (TikaProvider)manager.lookup(TikaProvider.ROLE);
        this._metadataPopulatorEP = (ResourceMetadataPopulatorExtensionPoint)((Object)manager.lookup(ResourceMetadataPopulatorExtensionPoint.ROLE));
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public List<ExplorerNode> getResourcesRootNodes() {
        ArrayList<ExplorerNode> roots = new ArrayList<ExplorerNode>();
        roots.add((ExplorerNode)this._resolver.resolveByPath("ametys:resources"));
        return roots;
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> getRootNodesInfo() {
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>();
        List<ExplorerNode> rootNodes = this.getResourcesRootNodes();
        for (ExplorerNode rootNode : rootNodes) {
            infos.add(this.getDefaultInfoAsRootNode(rootNode));
        }
        return infos;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getDefaultInfoAsRootNode(String id) {
        ExplorerNode node = (ExplorerNode)this._resolver.resolveById(id);
        return this.getDefaultInfoAsRootNode(node);
    }

    public Map<String, Object> getDefaultInfoAsRootNode(ExplorerNode rootNode) {
        boolean hasChildNodes;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", rootNode.getId());
        result.put("applicationId", rootNode.getApplicationId());
        result.put("name", "resources");
        result.put("cls", "root");
        result.put("iconCls", "ametysicon-folder249");
        result.put("text", this.getRootNodeLabel(rootNode));
        result.put("path", "/dummy/resources");
        result.put("type", "collection");
        boolean hasResources = false;
        if (rootNode instanceof ResourceCollection) {
            hasResources = ((ResourceCollection)rootNode).hasChildResources();
        }
        if (hasChildNodes = rootNode.hasChildExplorerNodes()) {
            result.put("hasChildNodes", true);
        }
        if (hasResources) {
            result.put("hasResources", true);
        }
        result.put("isModifiable", false);
        if (rootNode instanceof ModifiableExplorerNode) {
            result.put("canCreateChild", true);
        }
        return result;
    }

    public I18nizableText getRootNodeLabel(ExplorerNode rootNode) {
        return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_ROOT_NODE");
    }

    @Callable(rights={"*"})
    public Map<String, Object> getNodesInfo(List<String> ids) {
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>();
        ArrayList<String> objectsNotFound = new ArrayList<String>();
        for (String id : ids) {
            try {
                AmetysObject ao = this._resolver.resolveById(id);
                if (ao instanceof ExplorerNode) {
                    objects.add(this.getExplorerNodeProperties((ExplorerNode)ao));
                    continue;
                }
                if (!(ao instanceof Resource)) continue;
                objects.add(this.getResourceProperties((Resource)ao));
            }
            catch (UnknownAmetysObjectException e) {
                objectsNotFound.add(id);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("objects", objects);
        result.put("objectsNotFound", objectsNotFound);
        return result;
    }

    public Map<String, Object> getExplorerNodeProperties(ExplorerNode node) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        ExplorerNode root = node;
        AmetysObject parent = null;
        while ((parent = root.getParent()) instanceof ExplorerNode) {
            root = (ExplorerNode)parent;
        }
        parent = node.getParent();
        infos.put("rootId", root.getId());
        infos.put("rootOwnerType", "explorer");
        infos.put("parentId", parent instanceof ExplorerNode ? parent.getId() : null);
        infos.put("id", node.getId());
        infos.put("applicationId", node.getApplicationId());
        infos.put("name", node.getName());
        infos.put("path", node.getExplorerPath());
        infos.put("isModifiable", node instanceof ModifiableAmetysObject);
        infos.put("canCreateChild", node instanceof ModifiableExplorerNode);
        infos.put("cls", node.getIconCls());
        infos.put("rights", this.getUserRights(node));
        return infos;
    }

    public Map<String, Object> getResourceProperties(Resource resource) {
        ResourceCollection parentAO;
        HashMap<String, Object> infos = new HashMap<String, Object>();
        ResourceCollection root = parentAO = (ResourceCollection)resource.getParent();
        while (root.getParent() instanceof ResourceCollection) {
            root = (ResourceCollection)root.getParent();
        }
        infos.put("id", resource.getId());
        infos.put("rootId", root.getId());
        infos.put("rootOwnerType", "explorer");
        infos.put("parentId", parentAO.getId());
        infos.put("name", resource.getName());
        infos.put("path", resource.getResourcePath());
        infos.put("isModifiable", resource instanceof ModifiableAmetysObject);
        infos.put("rights", this.getUserRights(parentAO));
        return infos;
    }

    public Set<Pattern> getExplorerNodePathPatterns() {
        return Collections.singleton(Pattern.compile("^/ametys:resources(/.*)?$"));
    }

    @Callable(rights={"*"})
    public List<String> filterResourcesByRegExp(String id, String value, List<String> allowedExtensions) {
        ArrayList<String> matchingPaths = new ArrayList<String>();
        ExplorerNode root = (ExplorerNode)this._resolver.resolveById(id);
        String toMatch = StringUtils.stripAccents((String)value.toLowerCase()).trim();
        if (root instanceof TraversableAmetysObject) {
            TraversableAmetysObject traversableObject = (TraversableAmetysObject)root;
            AmetysObjectIterable children = traversableObject.getChildren();
            for (AmetysObject ao : children) {
                if (ao instanceof Resource) {
                    this._getMatchingResource((Resource)ao, toMatch, allowedExtensions, matchingPaths);
                    continue;
                }
                if (!(ao instanceof ExplorerNode)) continue;
                this._getMatchingExplorerNode((ExplorerNode)ao, toMatch, allowedExtensions, matchingPaths);
            }
        }
        return matchingPaths;
    }

    private void _getMatchingExplorerNode(ExplorerNode explorerNode, String value, List<String> allowedExtensions, List<String> matchingPaths) {
        String title = StringUtils.stripAccents((String)explorerNode.getName().toLowerCase());
        if (title.contains(value)) {
            matchingPaths.add(explorerNode.getExplorerPath());
        }
        if (explorerNode instanceof TraversableAmetysObject) {
            TraversableAmetysObject traversableObject = (TraversableAmetysObject)explorerNode;
            AmetysObjectIterable children = traversableObject.getChildren();
            for (AmetysObject ao : children) {
                if (ao instanceof Resource) {
                    this._getMatchingResource((Resource)ao, value, allowedExtensions, matchingPaths);
                    continue;
                }
                if (!(ao instanceof ExplorerNode)) continue;
                this._getMatchingExplorerNode((ExplorerNode)ao, value, allowedExtensions, matchingPaths);
            }
        }
    }

    private void _getMatchingResource(Resource resource, String value, List<String> allowedExtensions, List<String> matchingPaths) {
        String fileExtension;
        String filename = StringUtils.stripAccents((String)resource.getName().toLowerCase());
        String string = fileExtension = filename.lastIndexOf(".") > 0 ? filename.substring(filename.lastIndexOf(".") + 1) : "";
        if (filename.contains(value) && (allowedExtensions == null || allowedExtensions.size() == 0 || allowedExtensions.contains(fileExtension))) {
            matchingPaths.add(resource.getResourcePath());
        }
    }

    protected Set<String> getUserRights(ExplorerNode node) {
        return this._rightManager.getUserRights(this._currentUserProvider.getUser(), (Object)node);
    }

    @Callable(rights={"*"})
    public boolean hasRight(String id, String rightId) {
        ExplorerNode node;
        UserIdentity user = this._currentUserProvider.getUser();
        return this._rightManager.hasRight(user, rightId, (Object)(node = (ExplorerNode)this._resolver.resolveById(id))) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean checkLock(AmetysObject ao) {
        LockableAmetysObject lockableAO;
        if (ao instanceof LockableAmetysObject && (lockableAO = (LockableAmetysObject)ao).isLocked()) {
            if (!LockHelper.isLockOwner((LockAwareAmetysObject)lockableAO, (UserIdentity)this._currentUserProvider.getUser())) {
                return false;
            }
            if (ao instanceof JCRAmetysObject) {
                this._addLockToken(((JCRAmetysObject)ao).getNode());
            }
        }
        return true;
    }

    private void _addLockToken(Node node) {
        try {
            if (node.isLocked()) {
                LockManager lockManager = node.getSession().getWorkspace().getLockManager();
                Lock lock = lockManager.getLock(node.getPath());
                Node lockHolder = lock.getNode();
                lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add lock token", (Throwable)e);
        }
    }

    public void checkUserRight(AmetysObject object, String rightId) throws IllegalAccessException {
        ExplorerNode node = object instanceof Resource ? (ExplorerNode)object.getParent() : (ExplorerNode)object;
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)object) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to access a privilege feature without convenient right [" + rightId + ", /resources" + node.getExplorerPath() + "]");
        }
    }

    public boolean getUserRight(UserIdentity user, String right, AmetysObject object) {
        AmetysObject explorerNode;
        for (explorerNode = object; explorerNode != null && !(explorerNode instanceof ExplorerNode); explorerNode = explorerNode.getParent()) {
        }
        if (explorerNode == null) {
            return false;
        }
        return this._rightManager.hasRight(user, right, (Object)explorerNode) == RightManager.RightResult.RIGHT_ALLOW;
    }

    @Callable(rights={""})
    public Map<String, Object> addResourceCollection(String parentId, String desiredName, Boolean renameIfExists) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (parentId != null);
        AmetysObject object = this._resolver.resolveById(parentId);
        if (!(object instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, object.getClass());
        }
        LinkedList<String> errors = new LinkedList<String>();
        ResourceCollection rc = this.addResourceCollection((ModifiableResourceCollection)object, desiredName, renameIfExists, errors);
        if (!errors.isEmpty()) {
            result.put("message", errors.get(0));
        } else {
            result.put("id", rc.getId());
            result.put("parentID", parentId);
            result.put("name", rc.getName());
        }
        return result;
    }

    public ResourceCollection addResourceCollection(ModifiableResourceCollection parent, String desiredName, Boolean renameIfExists, List<String> errors) {
        String originalName = desiredName;
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_COLLECTION_ADD, (Object)parent) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to add folder without convenient right [Plugin_Explorer_Folder_Add]");
        }
        if (!this.checkLock(parent)) {
            this.getLogger().warn("User '{}' try to modify collection '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)parent.getName());
            if (errors != null) {
                errors.add("locked");
            }
            return null;
        }
        if (!renameIfExists.booleanValue() && parent.hasChild(originalName)) {
            this.getLogger().warn("The object '{}' can not be renamed in '{}' : a object of same name already exists.", (Object)parent.getName(), (Object)originalName);
            if (errors != null) {
                errors.add("already-exist");
            }
            return null;
        }
        int index = 2;
        Object name = originalName;
        while (parent.hasChild((String)name)) {
            name = originalName + " (" + index + ")";
            ++index;
        }
        ResourceCollection child = (ResourceCollection)parent.createChild((String)name, this.getResourceCollectionType());
        parent.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", child.getId());
        eventParams.put("object.parent", parent.getId());
        eventParams.put("object.name", child.getName());
        eventParams.put("object.path", child.getPath());
        this._observationManager.notify(new Event("collection.created", this._currentUserProvider.getUser(), eventParams));
        return child;
    }

    public String getResourceCollectionType() {
        return "ametys:resources-collection";
    }

    @Callable(rights={""})
    public Map<String, Object> renameObject(String id, String name) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRAmetysObject object = (JCRAmetysObject)this._resolver.resolveById(id);
        LinkedList<String> errors = new LinkedList<String>();
        JCRAmetysObject newObject = this.renameObject(object, name, errors);
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        } else {
            result.put("id", newObject.getId());
            result.put("name", name);
        }
        return result;
    }

    public JCRAmetysObject renameObject(JCRAmetysObject object, String name, List<String> errors) throws RepositoryException {
        String rightId;
        assert (object != null);
        assert (name != null);
        String legalName = Text.escapeIllegalJcrChars((String)name);
        if ("ametys-internal:resources".equals(object.getName())) {
            throw new IllegalStateException("The resources root node can not be renamed !");
        }
        String string = rightId = object instanceof Resource ? RIGHTS_RESOURCE_RENAME : RIGHTS_COLLECTION_EDIT;
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)object) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to rename folder or file without convenient right [" + rightId + "]");
        }
        Node node = object.getNode();
        String oldName = object.getName();
        String oldObjectPath = object.getPath();
        if (!this.checkLock((AmetysObject)object)) {
            this.getLogger().warn("User '{}' is trying to rename object '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)object.getName());
            if (errors != null) {
                errors.add("locked");
            }
            return null;
        }
        if (node.getParent().hasNode(legalName)) {
            this.getLogger().warn("The object '{}' cannot be renamed in '{}' : an object with the same name already exists.", (Object)object.getName(), (Object)name);
            if (errors != null) {
                errors.add("already-exist");
            }
            return null;
        }
        String oldResourcePath = object instanceof Resource ? ((Resource)object).getResourcePath() : ((ResourceCollection)object).getExplorerPath();
        node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + legalName);
        node.getSession().save();
        JCRAmetysObject newObject = (JCRAmetysObject)this._resolver.resolve(node, false);
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", newObject.getId());
        eventParams.put("object.parent", newObject.getParent().getId());
        eventParams.put("object.name", newObject.getName());
        eventParams.put("object.path", newObject.getPath());
        eventParams.put("object.old.name", oldName);
        eventParams.put("object.old.path", oldObjectPath);
        if (object instanceof Resource) {
            eventParams.put("resource.path", ((Resource)object).getResourcePath());
            eventParams.put("resource.old.path", oldResourcePath);
        } else {
            eventParams.put("explorer.path", ((ResourceCollection)object).getExplorerPath());
            eventParams.put("explorer.old.path", oldResourcePath);
        }
        this._observationManager.notify(new Event(object instanceof JCRResource ? "resource.renamed" : "collection.renamed", this._currentUserProvider.getUser(), eventParams));
        return newObject;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteObject(List<String> ids) {
        assert (ids != null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : ids) {
            RemovableAmetysObject object = (RemovableAmetysObject)this._resolver.resolveById(id);
            LinkedList<String> errors = new LinkedList<String>();
            this.deleteObject(object, errors);
            if (errors.isEmpty()) continue;
            String error = (String)errors.get(0);
            result.put("message", error);
            result.put("success", false);
            return result;
        }
        result.put("success", true);
        return result;
    }

    public String deleteObject(RemovableAmetysObject object, List<String> errors) {
        String rightId;
        if ("ametys-internal:resources".equals(object.getName())) {
            throw new IllegalStateException("The resources root node can not be deleted !");
        }
        String string = rightId = object instanceof Resource ? RIGHTS_RESOURCE_DELETE : RIGHTS_COLLECTION_DELETE;
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)object) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to delete file or folder without convenient right [" + rightId + "]");
        }
        if (!this.checkLock((AmetysObject)object)) {
            this.getLogger().warn("User '{}' is trying to delete object '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)object.getName());
            if (errors != null) {
                errors.add("locked");
            }
            return null;
        }
        ModifiableResourceCollection parent = (ModifiableResourceCollection)object.getParent();
        String eventType = object instanceof Resource ? "resource.deleted" : "collection.deleted";
        String parentId = parent.getId();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.parent", parentId);
        eventParams.put("object.id", object.getId());
        eventParams.put("object.name", object.getName());
        eventParams.put("object.path", object.getPath());
        if (object instanceof Resource) {
            eventParams.put("resource.path", ((Resource)object).getResourcePath());
        } else {
            eventParams.put("explorer.path", ((ResourceCollection)object).getExplorerPath());
            this._observationManager.notify(new Event("collection.deleting", this._currentUserProvider.getUser(), eventParams));
        }
        this.doDeleteObject(object);
        this._observationManager.notify(new Event(eventType, this._currentUserProvider.getUser(), eventParams));
        return parentId;
    }

    protected void doDeleteObject(RemovableAmetysObject object) {
        ModifiableResourceCollection parent = (ModifiableResourceCollection)object.getParent();
        object.remove();
        parent.saveChanges();
    }

    @Callable(rights={""})
    public Map<String, Object> renameResource(String id, String name) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRResource resource = (JCRResource)this._resolver.resolveById(id);
        LinkedList<String> errors = new LinkedList<String>();
        JCRResource newResource = this.renameResource(resource, name, errors);
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        } else {
            result.put("id", newResource.getId());
            result.put("name", name);
        }
        return result;
    }

    public JCRResource renameResource(JCRResource resource, String name, List<String> errors) throws RepositoryException {
        assert (resource != null);
        assert (name != null);
        String legalName = Text.escapeIllegalJcrChars((String)name);
        String oldName = resource.getName();
        String oldPath = resource.getPath();
        String oldResourcePath = resource.getResourcePath();
        Node node = resource.getNode();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_RESOURCE_RENAME, (Object)resource) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to rename file without convenient right [Plugin_Explorer_File_Rename]");
        }
        if (!this.checkLock((AmetysObject)resource)) {
            this.getLogger().warn("User '{}' is trying to rename resource '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)resource.getName());
            if (errors != null) {
                errors.add("locked");
            }
            return null;
        }
        if (node.getParent().hasNode(legalName)) {
            this.getLogger().warn("The resource '{}' cannot be renamed in '{}' : an object with the same name already exists.", (Object)resource.getName(), (Object)name);
            if (errors != null) {
                errors.add("already-exist");
            }
            return null;
        }
        String mimeType = this._cocoonContext.getMimeType(legalName.toLowerCase());
        mimeType = mimeType == null ? "application/unknown" : mimeType;
        resource.setMimeType(mimeType);
        node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + legalName);
        node.getSession().save();
        JCRResource newObject = (JCRResource)this._resolver.resolve(node, false);
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", newObject.getId());
        eventParams.put("object.parent", newObject.getParent().getId());
        eventParams.put("object.name", newObject.getName());
        eventParams.put("object.path", newObject.getPath());
        eventParams.put("object.old.name", oldName);
        eventParams.put("object.old.path", oldPath);
        eventParams.put("resource.path", newObject.getResourcePath());
        eventParams.put("resource.old.path", oldResourcePath);
        this._observationManager.notify(new Event("resource.renamed", this._currentUserProvider.getUser(), eventParams));
        return newObject;
    }

    @Callable(rights={""})
    public Map<String, Object> copyResource(List<String> ids, String target) throws RepositoryException {
        assert (ids != null);
        assert (target != null);
        AmetysObject object = this._resolver.resolveById(target);
        if (!(object instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, object.getClass());
        }
        return this.copyResource(ids, (ModifiableResourceCollection)object);
    }

    public Map<String, Object> copyResource(List<String> ids, ModifiableResourceCollection target) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> uncopiedResources = new ArrayList<String>();
        ArrayList<String> copiedResourceIds = new ArrayList<String>();
        assert (ids != null);
        assert (target != null);
        if (!this.checkLock(target)) {
            this.getLogger().warn("User '{}' try to copy objet to '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)target.getName());
            result.put("message", "locked");
            return result;
        }
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_RESOURCE_ADD, (Object)target) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to copy file without convenient right [Plugin_Explorer_File_Add]");
        }
        for (String id : ids) {
            Resource resourceToCopy = (Resource)this._resolver.resolveById(id);
            String fileName = resourceToCopy.getName();
            if (target.hasChild(fileName)) {
                this.getLogger().warn("The resource '" + fileName + "' can not be copied : an object of same name already exists in the target collection");
                result.put("message", "already-exist");
                uncopiedResources.add(fileName);
                continue;
            }
            ModifiableResource resource = this.createResource(target, fileName);
            try (InputStream is = resourceToCopy.getInputStream();){
                this.updateResource(resource, is, fileName);
            }
            catch (IOException e) {
                this.getLogger().warn("An error occurred while closing the ressource " + resource.getId(), (Throwable)e);
            }
            copiedResourceIds.add(resource.getId());
        }
        target.saveChanges();
        for (String id : copiedResourceIds) {
            ModifiableResource resource = (ModifiableResource)this._resolver.resolveById(id);
            this.checkpoint(resource);
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            HashMap<String, ModifiableResource> addedResource = new HashMap<String, ModifiableResource>();
            addedResource.put(resource.getId(), resource);
            eventParams.put("resources", addedResource);
            eventParams.put("object.parent", target.getId());
            eventParams.put("object.parent.path", target.getPath());
            this._observationManager.notify(new Event("resource.created", this._currentUserProvider.getUser(), eventParams));
        }
        if (uncopiedResources.size() > 0) {
            result.put("uncopied-resources", uncopiedResources);
        }
        if (copiedResourceIds.size() > 0) {
            result.put("copied-resources", copiedResourceIds);
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> moveObject(List<String> ids, String targetId) throws RepositoryException {
        assert (ids != null);
        assert (targetId != null);
        AmetysObject target = this._resolver.resolveById(targetId);
        if (!(target instanceof JCRTraversableAmetysObject)) {
            throw new IllegalClassException(JCRTraversableAmetysObject.class, target.getClass());
        }
        return this.moveObject(ids, (JCRTraversableAmetysObject)target);
    }

    public Map<String, Object> moveObject(List<String> ids, JCRTraversableAmetysObject targetNode) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> unmovedObjects = new ArrayList<String>();
        ArrayList<String> noRightObjects = new ArrayList<String>();
        ArrayList<String> movedObjectIds = new ArrayList<String>();
        assert (ids != null);
        assert (targetNode != null);
        if (!this.checkLock((AmetysObject)targetNode)) {
            this.getLogger().warn("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to move objet to '" + targetNode.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        for (String id : ids) {
            JCRAmetysObject object = (JCRAmetysObject)this._resolver.resolveById(id);
            String addRightId = object instanceof Resource ? RIGHTS_RESOURCE_ADD : RIGHTS_COLLECTION_ADD;
            String deleteRightId = object instanceof Resource ? RIGHTS_RESOURCE_DELETE : RIGHTS_COLLECTION_DELETE;
            ResourceCollection oldParent = (ResourceCollection)object.getParent();
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), addRightId, (Object)targetNode) != RightManager.RightResult.RIGHT_ALLOW || this._rightManager.hasRight(this._currentUserProvider.getUser(), deleteRightId, (Object)oldParent) != RightManager.RightResult.RIGHT_ALLOW) {
                this.getLogger().error("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to move resource without convenient right [" + addRightId + "]");
                noRightObjects.add(object.getName());
                continue;
            }
            if (targetNode.hasChild(object.getName())) {
                this.getLogger().warn("The object '" + object.getName() + "' can not be moved : a object of same name already exists in the target collection");
                result.put("message", "already-exist");
                unmovedObjects.add(object.getName());
                continue;
            }
            String oldResourcePath = object instanceof Resource ? ((Resource)object).getResourcePath() : ((ExplorerNode)object).getExplorerPath();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("object.old.path", object.getPath());
            Session session = object.getNode().getSession();
            session.move(object.getNode().getPath(), targetNode.getNode().getPath() + "/" + object.getNode().getName());
            if (object instanceof Resource) {
                eventParams.put("resource.path", ((Resource)object).getResourcePath());
                eventParams.put("resource.old.path", oldResourcePath);
            } else {
                eventParams.put("explorer.old.path", oldResourcePath);
            }
            eventParams.put("object.path", ((ExplorerNode)targetNode).getExplorerPath() + "/" + object.getName());
            eventParams.put("object.parent", targetNode.getId());
            eventParams.put("object.id", id);
            eventParams.put("object.name", object.getName());
            session.save();
            movedObjectIds.add(object.getId());
            if (object instanceof Resource) {
                eventParams.put("resource.path", ((Resource)object).getResourcePath());
                eventParams.put("resource.old.path", oldResourcePath);
                this._observationManager.notify(new Event("resource.moved", this._currentUserProvider.getUser(), eventParams));
                continue;
            }
            if (object instanceof ResourceCollection) {
                this._observationManager.notify(new Event("collection.moved", this._currentUserProvider.getUser(), eventParams));
                continue;
            }
            this.getLogger().warn("Object " + object.getId() + " of class '" + object.getClass().getName() + "' was moved. This type is unknown.");
        }
        if (!unmovedObjects.isEmpty()) {
            result.put("unmoved-objects", unmovedObjects);
        }
        if (!noRightObjects.isEmpty()) {
            result.put("noright-objects", noRightObjects);
        }
        if (!movedObjectIds.isEmpty()) {
            result.put("moved-objects", movedObjectIds);
        }
        return result;
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> resourceHistory(String id) throws RepositoryException {
        JCRResource resource = (JCRResource)this._resolver.resolveById(id);
        ArrayList<Map<String, Object>> versions = new ArrayList<Map<String, Object>>();
        ArrayList<VersionInformation> versionsInfo = new ArrayList<VersionInformation>();
        for (String revision : resource.getAllRevisions()) {
            VersionInformation versionInformation = new VersionInformation(revision, resource.getRevisionTimestamp(revision));
            for (String label : resource.getLabels(revision)) {
                versionInformation.addLabel(label);
            }
            versionsInfo.add(versionInformation);
        }
        Collections.sort(versionsInfo, new Comparator<VersionInformation>(this){

            @Override
            public int compare(VersionInformation o1, VersionInformation o2) {
                try {
                    return -o1.getCreatedAt().compareTo(o2.getCreatedAt());
                }
                catch (RepositoryException e) {
                    throw new RuntimeException("Unable to retrieve a creation date", e);
                }
            }
        });
        for (VersionInformation versionInformation : versionsInfo) {
            Map<String, Object> version = this._version2json(resource, versionInformation);
            versions.add(version);
        }
        return versions;
    }

    protected Map<String, Object> _version2json(JCRResource resource, VersionInformation versionInformation) throws RepositoryException {
        HashMap<String, Object> version = new HashMap<String, Object>();
        for (String label : versionInformation.getLabels()) {
            version.put(label, label);
        }
        version.put("rawName", versionInformation.getVersionRawName());
        version.put("name", versionInformation.getVersionName());
        version.put("createdAt", DateUtils.dateToString((Date)versionInformation.getCreatedAt()));
        try {
            resource.switchToRevision(versionInformation.getVersionRawName());
            UserIdentity author = resource.getLastContributor();
            version.put("author", this._userHelper.user2json(author));
        }
        catch (AmetysRepositoryException ametysRepositoryException) {
            // empty catch block
        }
        return version;
    }

    @Callable(rights={""})
    public void restoreResource(String id, String versionName) {
        JCRResource resource = (JCRResource)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_RESOURCE_ADD, (Object)resource.getParent()) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to restore file without convenient right [Plugin_Explorer_File_Add]");
        }
        resource.restoreFromRevision(versionName);
        resource.setLastContributor(this._currentUserProvider.getUser());
        resource.setLastModified(new Date());
        resource.saveChanges();
        resource.checkpoint();
    }

    @Callable(rights={"__READ_ACCESS", "Plugin_Explorer_File_Add"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public boolean resourcesExists(String parentId, List<String> names) {
        for (String name : names) {
            if (!this.resourceExists(parentId, name)) continue;
            return true;
        }
        return false;
    }

    public boolean resourceExists(String parentId, String name) {
        return this.resourceExists((TraversableAmetysObject)this._resolver.resolveById(parentId), name);
    }

    public boolean resourceExists(TraversableAmetysObject parent, String name) {
        return parent.hasChild(name);
    }

    @Callable(rights={""})
    public void setDCMetadata(String resourceId, Map<String, Object> values) throws ProcessingException {
        this.setDCMetadata((ModifiableResource)this._resolver.resolveById(resourceId), values);
    }

    public void setDCMetadata(ModifiableResource resource, Map<String, Object> values) {
        String title = (String)values.get("dc_title");
        String creator = (String)values.get("dc_creator");
        Object subject = values.get("dc_subject");
        List subjects = subject instanceof List ? (List)subject : Collections.emptyList();
        String description = (String)values.get("dc_description");
        String publisher = (String)values.get("dc_publisher");
        String contributor = (String)values.get("dc_contributor");
        String dateStr = (String)values.get("dc_date");
        String type = (String)values.get("dc_type");
        String source = (String)values.get("dc_source");
        String language = (String)values.get("dc_language");
        String relation = (String)values.get("dc_relation");
        String coverage = (String)values.get("dc_coverage");
        String rights = (String)values.get("dc_rights");
        try {
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_RESOURCE_EDIT_DC, (Object)resource) != RightManager.RightResult.RIGHT_ALLOW) {
                throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit file DC without convenient right [Plugin_Explorer_File_Edit_DC_Metadata]");
            }
            this._updateTitleIfNeeded(resource, title);
            this._updateCreatorIfNeeded(resource, creator);
            this._updateDateIfNeeded(resource, dateStr);
            this._updateDCSubjectIfNeeded(resource, subjects);
            this._updateDescriptionIfNeeded(resource, description);
            this._updatePublisherIfNeeded(resource, publisher);
            this._updateContributorIfNeeded(resource, contributor);
            this._updateTypeIfNeeded(resource, type);
            this._updateSourceIfNeeded(resource, source);
            this._updateLanguageIfNeeded(resource, language);
            this._updateRelationIfNeeded(resource, relation);
            this._updateCoverageIfNeeded(resource, coverage);
            this._updateRightsIfNeeded(resource, rights);
            this._saveChangesIfNeeded(resource);
        }
        catch (AmetysRepositoryException e) {
            String errorMsg = String.format("Exception while trying to set Dublin Core metadata on resource %s", resource.getId());
            this.getLogger().error(errorMsg, (Throwable)e);
            throw new AmetysRepositoryException(errorMsg, (Throwable)e);
        }
    }

    private void _updateTitleIfNeeded(ModifiableResource resource, String title) {
        if (!Objects.equals(title, resource.getDCTitle())) {
            resource.setDCTitle(title);
        }
    }

    private void _updateCreatorIfNeeded(ModifiableResource resource, String creator) {
        if (!Objects.equals(creator, resource.getDCCreator())) {
            resource.setDCCreator(creator);
        }
    }

    private void _updateDateIfNeeded(ModifiableResource resource, String dateStr) {
        Date date = null;
        if (StringUtils.isNotEmpty((CharSequence)dateStr)) {
            date = DateUtils.parse((String)dateStr);
        }
        if (!Objects.equals(date, resource.getDCDate())) {
            resource.setDCDate(date);
        }
    }

    private void _updateRightsIfNeeded(ModifiableResource resource, String rights) {
        if (!Objects.equals(rights, resource.getDCRights())) {
            resource.setDCRights(rights);
        }
    }

    private void _updateCoverageIfNeeded(ModifiableResource resource, String coverage) {
        if (!Objects.equals(coverage, resource.getDCCoverage())) {
            resource.setDCCoverage(coverage);
        }
    }

    private void _updateRelationIfNeeded(ModifiableResource resource, String relation) {
        if (!Objects.equals(relation, resource.getDCRelation())) {
            resource.setDCRelation(relation);
        }
    }

    private void _updateLanguageIfNeeded(ModifiableResource resource, String language) {
        if (!Objects.equals(language, resource.getDCLanguage())) {
            resource.setDCLanguage(language);
        }
    }

    private void _updateSourceIfNeeded(ModifiableResource resource, String source) {
        if (!Objects.equals(source, resource.getDCSource())) {
            resource.setDCSource(source);
        }
    }

    private void _updateTypeIfNeeded(ModifiableResource resource, String type) {
        if (!Objects.equals(type, resource.getDCType())) {
            resource.setDCType(type);
        }
    }

    private void _updateContributorIfNeeded(ModifiableResource resource, String contributor) {
        if (!Objects.equals(contributor, resource.getDCContributor())) {
            resource.setDCContributor(contributor);
        }
    }

    private void _updatePublisherIfNeeded(ModifiableResource resource, String publisher) {
        if (!Objects.equals(publisher, resource.getDCPublisher())) {
            resource.setDCPublisher(publisher);
        }
    }

    private void _updateDescriptionIfNeeded(ModifiableResource resource, String description) {
        if (!Objects.equals(description, resource.getDCDescription())) {
            resource.setDCDescription(description);
        }
    }

    private void _updateDCSubjectIfNeeded(ModifiableResource resource, List<String> subjects) {
        String[] trimSubject = (String[])subjects.stream().map(StringUtils::trim).toArray(String[]::new);
        if (!Objects.deepEquals(trimSubject, resource.getDCSubject())) {
            resource.setDCSubject(trimSubject);
        }
    }

    private void _saveChangesIfNeeded(ModifiableResource resource) {
        if (resource.needsSave()) {
            resource.setLastContributor(this._currentUserProvider.getUser());
            resource.setLastModified(new Date());
            ModifiableResourceCollection parent = (ModifiableResourceCollection)resource.getParent();
            parent.saveChanges();
            if (resource instanceof VersionableAmetysObject) {
                ((VersionableAmetysObject)resource).checkpoint();
            }
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("object.id", resource.getId());
            eventParams.put("object.parent", parent.getId());
            eventParams.put("object.name", resource.getName());
            eventParams.put("object.path", resource.getPath());
            this._observationManager.notify(new Event("resource.updated", this._currentUserProvider.getUser(), eventParams));
        }
    }

    @Callable(rights={"__READ_ACCESS", "Plugin_Explorer_File_Edit_DC_Metadata"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> getDCMetadata(String id) {
        AmetysObject object = this._resolver.resolveById(id);
        if (object instanceof DublinCoreAwareAmetysObject) {
            DublinCoreAwareAmetysObject dcObject = (DublinCoreAwareAmetysObject)object;
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("id", id);
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("dc_title", dcObject.getDCTitle());
            values.put("dc_creator", dcObject.getDCCreator());
            values.put("dc_subject", dcObject.getDCSubject());
            values.put("dc_description", dcObject.getDCDescription());
            values.put("dc_type", dcObject.getDCType());
            values.put("dc_publisher", dcObject.getDCPublisher());
            values.put("dc_contributor", dcObject.getDCContributor());
            values.put("dc_date", DateUtils.dateToString((Date)dcObject.getDCDate()));
            values.put("dc_format", dcObject.getDCFormat());
            values.put("dc_identifier", dcObject.getDCIdentifier());
            values.put("dc_source", dcObject.getDCSource());
            values.put("dc_language", dcObject.getDCLanguage());
            values.put("dc_relation", dcObject.getDCRelation());
            values.put("dc_coverage", dcObject.getDCCoverage());
            values.put("dc_rights", dcObject.getDCRights());
            metadata.put("values", values);
            return metadata;
        }
        throw new IllegalArgumentException("Object of id " + id + " is not Dublin Core aware.");
    }

    @Callable(rights={""})
    public Map<String, Object> addCMISCollection(String parentId, String originalName, String url, String login, String password, String repoId, String mountPoint, boolean renameIfExists) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AmetysObject object = this._resolver.resolveById(parentId);
        if (!(object instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, object.getClass());
        }
        ModifiableResourceCollection collection = (ModifiableResourceCollection)object;
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_COLLECTION_CMIS_ADD, (Object)collection) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to add CMIS collection without convenient right [Plugin_Explorer_CMIS_Add]");
        }
        if (!this.checkLock(collection)) {
            this.getLogger().warn("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to modify collection '" + object.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        if (!renameIfExists && collection.hasChild(originalName)) {
            this.getLogger().warn("The object '" + object.getName() + "' can not be renamed in '" + originalName + "' : a object of same name already exists.");
            result.put("message", "already-exist");
            return result;
        }
        int index = 1;
        Object name = originalName;
        while (collection.hasChild((String)name)) {
            name = originalName + " (" + index + ")";
            ++index;
        }
        CMISRootResourcesCollection child = (CMISRootResourcesCollection)collection.createChild((String)name, "ametys:cmis-root-collection");
        child.setRepositoryUrl(url);
        child.setRepositoryId(repoId);
        child.setMountPoint(mountPoint);
        child.setUser(login);
        child.setPassword(password);
        collection.saveChanges();
        result.put("id", child.getId());
        result.put("parentID", parentId);
        result.put("name", name);
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", child.getId());
        eventParams.put("object.parent", object.getId());
        eventParams.put("object.name", child.getName());
        eventParams.put("object.path", child.getPath());
        this._observationManager.notify(new Event("collection.created", this._currentUserProvider.getUser(), eventParams));
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> editCMISCollection(String id, String url, String login, String password, String repoId, String mountPoint) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CMISRootResourcesCollection object = (CMISRootResourcesCollection)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_COLLECTION_CMIS_ADD, (Object)object) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit CMIS collection without convenient right [Plugin_Explorer_CMIS_Add]");
        }
        object.setRepositoryUrl(url);
        object.setRepositoryId(repoId);
        object.setMountPoint(mountPoint);
        object.setUser(login);
        object.setPassword(password);
        object.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", object.getId());
        this._observationManager.notify(new Event("cmis.collection.updated", this._currentUserProvider.getUser(), eventParams));
        result.put("id", object.getId());
        return result;
    }

    @Callable(rights={"__READ_ACCESS", "Plugin_Explorer_CMIS_Add"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public boolean isCMISCollection(String id) {
        ResourceCollection collection = (ResourceCollection)this._resolver.resolveById(id);
        return collection instanceof CMISRootResourcesCollection;
    }

    @Callable(rights={""})
    public Map<String, String> getCMISProperties(String id) {
        HashMap<String, String> properties = new HashMap<String, String>();
        CMISRootResourcesCollection cmis = (CMISRootResourcesCollection)this._resolver.resolveById(id);
        ResourceCollection parent = (ResourceCollection)cmis.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_COLLECTION_CMIS_ADD, (Object)parent) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to getCMIS properties without convenient right [Plugin_Explorer_Folder_Add]");
        }
        properties.put("id", cmis.getId());
        properties.put("name", cmis.getName());
        properties.put("url", cmis.getRepositoryUrl());
        properties.put("login", cmis.getUser());
        properties.put("password", cmis.getPassword());
        properties.put("repoId", cmis.getRepositoryId());
        properties.put("mountPoint", cmis.getMountPoint());
        return properties;
    }

    public void updateResource(ModifiableResource resource, InputStream is, String fileName) {
        UserIdentity author = this._currentUserProvider.getUser();
        String mimeType = this._cocoonContext.getMimeType(fileName.toLowerCase());
        mimeType = mimeType == null ? "application/unknown" : mimeType;
        resource.setData(is, mimeType, new Date(), author);
        resource.setLastModified(new Date());
        this.extractResourceMetadata(resource, mimeType);
    }

    public void extractResourceMetadata(ModifiableResource resource, String mimeType) {
        try (InputStream is = resource.getInputStream();){
            Metadata metadata = new Metadata();
            try (Reader reader = this._tikaProvider.getTika().parse(is, metadata);){
                IOUtils.copy((Reader)reader, (OutputStream)OutputStream.nullOutputStream(), (Charset)StandardCharsets.UTF_8);
                Collection<ResourceMetadataPopulator> populators = this._metadataPopulatorEP.getPopulators(mimeType);
                for (ResourceMetadataPopulator populator : populators) {
                    populator.populate(resource, metadata);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error populating the metadata of resource " + resource.getId(), (Throwable)e);
        }
    }

    public void checkpoint(ModifiableResource resource) {
        if (resource instanceof VersionableAmetysObject) {
            ((VersionableAmetysObject)resource).checkpoint();
        }
    }

    public ModifiableResource createResource(ModifiableResourceCollection collection, String name) {
        return (ModifiableResource)collection.createChild(name, collection.getResourceType());
    }

    protected static class VersionInformation {
        private String _rawName;
        private String _name;
        private Date _creationDate;
        private Set<String> _labels = new HashSet<String>();

        public VersionInformation(String rawName, Date creationDate) throws RepositoryException {
            this._creationDate = creationDate;
            this._rawName = rawName;
            this._name = String.valueOf(Integer.parseInt(this._rawName.substring(2)) + 1);
        }

        public String getVersionName() {
            return this._name;
        }

        public String getVersionRawName() {
            return this._rawName;
        }

        public Date getCreatedAt() throws RepositoryException {
            return this._creationDate;
        }

        public Set<String> getLabels() {
            return this._labels;
        }

        public void addLabel(String label) {
            this._labels.add(label);
        }
    }
}

