/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.actions;

import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.HttpHeaderAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SetHttpHeaderForArchive
extends HttpHeaderAction
implements Serviceable {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map result = super.act(redirector, resolver, objectModel, source, parameters);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String name = request.getParameter("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            name = URIUtils.decode((String)name);
        } else if (request.getParameter("file") != null) {
            AmetysObject ao = this._resolver.resolveById(request.getParameter("file"));
            name = ao.getName();
            if (ao instanceof Resource) {
                name = name.substring(0, name.lastIndexOf("."));
            }
        } else {
            String id = request.getParameter("id");
            ResourceCollection collection = (ResourceCollection)this._resolver.resolveById(id);
            name = collection.getName();
        }
        name = name.replaceAll("\\\\", "\\\\\\\\");
        name = name.replaceAll("\\\"", "\\\\\\\"");
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + ".zip\"");
        return result;
    }
}

