/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.dom;

import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.dom.AbstractResourceElement;
import org.ametys.plugins.explorer.resources.dom.ResourceCollectionElement;
import org.w3c.dom.Element;

public class ResourceElement
extends AbstractResourceElement<Resource> {
    public ResourceElement(Resource resource, ResourceCollectionElement parent) {
        super(resource, parent);
    }

    public String getTagName() {
        return "resource";
    }

    protected Map<String, AmetysAttribute> _lookupAttributes() {
        Map atts = super._lookupAttributes();
        atts.put("name", new AmetysAttribute("name", "name", null, ((Resource)this._object).getName(), (Element)((Object)this)));
        atts.put("id", new AmetysAttribute("id", "id", null, ((Resource)this._object).getId(), (Element)((Object)this)));
        atts.put("length", new AmetysAttribute("length", "length", null, String.valueOf(((Resource)this._object).getLength()), (Element)((Object)this)));
        Date lastModified = ((Resource)this._object).getLastModified();
        if (lastModified != null) {
            String lastModifiedStr = DateUtils.getISODateTimeFormatter().format(lastModified.toInstant().atZone(ZoneId.systemDefault()));
            atts.put("last-modified", new AmetysAttribute("last-modified", "last-modified", null, lastModifiedStr, (Element)((Object)this)));
        }
        return atts;
    }
}

