/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ResourcesExplorerGenerator
extends ServiceableGenerator {
    public static final String RESOURCE_COLLECTION = "collection";
    public static final String RESOURCE = "resource";
    protected AmetysObjectResolver _resolver;
    protected UserManager _userManager;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._resolver = (AmetysObjectResolver)sManager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)sManager.lookup(UserManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = this.parameters.getParameter("node", request.getParameter("node"));
        int depth = this.parameters.getParameterAsInteger("depth", 0);
        if (depth == -1) {
            depth = Integer.MAX_VALUE;
        }
        String[] allowedExtensions = request.getParameterValues("allowedExtensions");
        ExplorerNode node = (ExplorerNode)this._resolver.resolveById(id);
        this.contentHandler.startDocument();
        long t0 = System.currentTimeMillis();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Nodes");
        this.saxCollection(node, depth, allowedExtensions);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Nodes");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("SAXed collection " + node.getExplorerPath() + " in " + (System.currentTimeMillis() - t0) + " ms");
        }
        this.contentHandler.endDocument();
    }

    protected void saxCollection(ExplorerNode node) throws SAXException {
        this.saxCollection(node, 0, null);
    }

    protected void saxCollection(ExplorerNode node, boolean saxNode) throws SAXException {
        this.saxCollection(node, 0, saxNode, "Node");
    }

    protected void saxCollection(ExplorerNode node, boolean saxNode, String nodeTag) throws SAXException {
        this.saxCollection(node, 0, saxNode, nodeTag);
    }

    protected void saxCollection(ExplorerNode node, int depth, boolean saxNode, String nodeTag) throws SAXException {
        if (saxNode) {
            AttributesImpl childAtts = this.getExplorerNodeAttributes(node);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)nodeTag, (Attributes)childAtts);
            this.saxCollection(node, depth, null);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)nodeTag);
        }
    }

    protected void saxCollection(ExplorerNode node, int depth, String[] allowedExtensions) throws SAXException {
        if (depth >= 0) {
            AmetysObjectIterable children = ((TraversableAmetysObject)node).getChildren();
            children.stream().filter(ExplorerNode.class::isInstance).map(ExplorerNode.class::cast).sorted(Comparator.comparing(AmetysObject::getName, new StringUtils.AlphanumComparator())).forEach(LambdaUtils.wrapConsumer(n -> this.saxExplorerNode((ExplorerNode)n, depth)));
            children.stream().filter(Resource.class::isInstance).map(Resource.class::cast).filter(r -> this._matchFilter((Resource)r, allowedExtensions)).sorted(Comparator.comparing(AmetysObject::getName, new StringUtils.AlphanumComparator())).forEach(LambdaUtils.wrapConsumer(r -> this.saxResource((Resource)r)));
        }
    }

    protected boolean _matchFilter(Resource resource, String[] allowedExtensions) {
        if (allowedExtensions == null || allowedExtensions.length == 0) {
            return true;
        }
        String filename = resource.getName();
        String extension = filename.lastIndexOf(".") > 0 ? filename.substring(filename.lastIndexOf(".") + 1) : "";
        return ArrayUtils.contains((Object[])allowedExtensions, (Object)extension.toLowerCase());
    }

    protected void saxExplorerNode(ExplorerNode node, int depth) throws SAXException {
        this.saxExplorerNode(node, depth, null);
    }

    protected void saxExplorerNode(ExplorerNode node, int depth, String[] allowedExtensions) throws SAXException {
        AttributesImpl childAtts = this.getExplorerNodeAttributes(node);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
        this.saxCollection(node, depth - 1, allowedExtensions);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Node");
    }

    protected AttributesImpl getExplorerNodeAttributes(ExplorerNode node) {
        boolean hasChildNodes;
        AttributesImpl childAtts = new AttributesImpl();
        childAtts.addCDATAAttribute("id", node.getId());
        childAtts.addCDATAAttribute("name", node.getName());
        String iconCls = node.getIconCls();
        if (iconCls != null) {
            childAtts.addCDATAAttribute("iconCls", iconCls);
        }
        childAtts.addCDATAAttribute("applicationId", node.getApplicationId());
        String relPath = node.getExplorerPath();
        childAtts.addCDATAAttribute("path", this._getNodePath(relPath));
        childAtts.addCDATAAttribute("type", RESOURCE_COLLECTION);
        boolean hasResources = false;
        if (node instanceof ResourceCollection) {
            hasResources = ((ResourceCollection)node).hasChildResources();
        }
        if (hasChildNodes = node.hasChildExplorerNodes()) {
            childAtts.addCDATAAttribute("hasChildNodes", "true");
        }
        if (hasResources) {
            childAtts.addCDATAAttribute("hasResources", "true");
        }
        if (node instanceof ModifiableAmetysObject) {
            childAtts.addCDATAAttribute("isModifiable", "true");
        }
        if (node instanceof ModifiableExplorerNode) {
            childAtts.addCDATAAttribute("canCreateChild", "true");
        }
        return childAtts;
    }

    protected void saxResource(Resource resource) throws SAXException {
        AttributesImpl childAtts = this.getResourceAttributes(resource);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"Node", (Attributes)childAtts);
    }

    protected AttributesImpl getResourceAttributes(Resource resource) {
        UserIdentity userIdentity = resource.getCreator();
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        String name = user == null ? userIdentity.getLogin() : user.getFullName() + " (" + userIdentity.getLogin() + ")";
        AttributesImpl childAtts = new AttributesImpl();
        childAtts.addCDATAAttribute("id", resource.getId());
        String iconCls = this.getResourcesIconCls(resource);
        if (iconCls != null) {
            childAtts.addCDATAAttribute("iconCls", this.getResourcesIconCls(resource));
        }
        childAtts.addCDATAAttribute("name", resource.getName());
        childAtts.addCDATAAttribute("mimetype", resource.getMimeType());
        childAtts.addCDATAAttribute("lastModified", DateUtils.dateToString((Date)resource.getLastModified()));
        childAtts.addCDATAAttribute("size", String.valueOf(resource.getLength()));
        childAtts.addCDATAAttribute("author", name);
        childAtts.addCDATAAttribute("keywords", resource.getKeywordsAsString());
        childAtts.addCDATAAttribute("type", RESOURCE);
        if (resource instanceof ModifiableAmetysObject) {
            childAtts.addCDATAAttribute("isModifiable", "true");
        }
        this.getAdditionalAttributes(childAtts, resource);
        String relPath = resource.getResourcePath();
        childAtts.addCDATAAttribute("path", this._getNodePath(relPath));
        return childAtts;
    }

    protected String _getNodePath(String relPath) {
        return relPath.startsWith("/") ? relPath.substring(1) : relPath;
    }

    protected String getResourcesIconCls(Resource resource) {
        return null;
    }

    protected void getAdditionalAttributes(AttributesImpl attrs, Resource resource) {
    }
}

