/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.generators.ResourcesExplorerGenerator;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SearchGenerator
extends ResourcesExplorerGenerator {
    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        block11: {
            String fulltext;
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String id = request.getParameter("id");
            ExplorerNode node = (ExplorerNode)this._resolver.resolveById(id);
            Expression metaExpr = this.getMetadataExpression(request);
            Object predicat = metaExpr != null ? metaExpr.build() : null;
            String name = request.getParameter("name");
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                String namePredicate = "jcr:like(fn:lower-case(fn:name()),'%" + name.toLowerCase() + "%')";
                Object object = predicat = predicat == null ? namePredicate : (String)predicat + Expression.LogicalOperator.OR.toString() + namePredicate;
            }
            if (StringUtils.isNotEmpty((CharSequence)(fulltext = request.getParameter("fulltext")))) {
                String xpath = "jcr:contains(jcr:content, '*" + fulltext + "*')";
                predicat = predicat == null ? xpath : (String)predicat + Expression.LogicalOperator.OR.toString() + xpath;
            }
            this.contentHandler.startDocument();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resources");
            try {
                if (!(node instanceof JCRAmetysObject)) break block11;
                String jcrPath = ((JCRAmetysObject)node).getNode().getPath();
                String relativeJcrPath = jcrPath.substring("ametys:root".length() + 1);
                String xpathQuery = "/" + ISO9075.encodePath((String)relativeJcrPath) + "//element(*, ametys:resource)" + (String)(predicat != null ? "[" + (String)predicat + "]" : "");
                try (AmetysObjectIterable it = this._resolver.query(xpathQuery);){
                    for (Resource resource : it) {
                        this.saxResource(resource);
                    }
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Error getting the JCR path of the explorer node of id " + id, (Throwable)e);
                throw new ProcessingException("Error getting the JCR path of the explorer node of id " + id, (Throwable)e);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resources");
        this.contentHandler.endDocument();
    }

    protected Expression getMetadataExpression(Request request) {
        String author;
        UserExpression expr = null;
        String keywords = request.getParameter("keywords");
        if (StringUtils.isNotEmpty((CharSequence)keywords)) {
            String[] words;
            for (String word : words = StringUtils.split((String)keywords)) {
                ExpressionContext context = ExpressionContext.newInstance().withUnversioned(true);
                StringExpression subjectExpr = new StringExpression("dc/dc_subject", Expression.Operator.WD, word, context);
                StringExpression descExpr = new StringExpression("dc/dc_description", Expression.Operator.WD, word, context);
                expr = expr == null ? new OrExpression(new Expression[]{subjectExpr, descExpr}) : new OrExpression(new Expression[]{expr, subjectExpr, descExpr});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(author = request.getParameter("author")))) {
            UserExpression authorExpr = new UserExpression("author", Expression.Operator.EQ, author, false, true);
            expr = expr == null ? authorExpr : new OrExpression(new Expression[]{expr, authorExpr});
        }
        return expr;
    }

    @Override
    protected AttributesImpl getResourceAttributes(Resource resource) {
        AttributesImpl atts = super.getResourceAttributes(resource);
        AmetysObject parent = resource.getParent();
        Resource object = resource;
        while (parent instanceof ResourceCollection) {
            object = parent;
            parent = object.getParent();
        }
        atts.addCDATAAttribute("rootId", object.getId());
        return atts;
    }
}

