/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserRightsGenerator
extends ServiceableGenerator {
    private AmetysObjectResolver _resolver;
    private RightManager _rightManager;
    private CurrentUserProvider _userProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("explorerNodeId");
        ExplorerNode node = (ExplorerNode)this._resolver.resolveById(id);
        UserIdentity user = this._userProvider.getUser();
        Set rights = this._rightManager.getUserRights(user, (Object)node);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"user-rights");
        for (String rightID : rights) {
            AttributesImpl rightAttr = new AttributesImpl();
            rightAttr.addCDATAAttribute("id", rightID);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"right", (Attributes)rightAttr);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"user-rights");
        this.contentHandler.endDocument();
    }
}

