/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ZipArchiveGenerator
extends ServiceableGenerator {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("id");
        String[] files = request.getParameterValues("file");
        boolean ignoreFolder = this.parameters.getParameterAsBoolean("ignoreFolder", false);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("zip", "http://apache.org/cocoon/zip-archive/1.0");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        if (files != null) {
            for (String fileId : files) {
                AmetysObject ao = this._resolver.resolveById(fileId);
                if (!ignoreFolder && ao instanceof ResourceCollection) {
                    this._saxResourceCollectionEntry((ResourceCollection)ao, this._getParentPath(ao), ignoreFolder);
                    continue;
                }
                if (!(ao instanceof Resource)) continue;
                this._saxResourceEntry((Resource)ao, this._getParentPath(ao));
            }
        } else {
            ResourceCollection collection = (ResourceCollection)this._resolver.resolveById(id);
            this._saxResourceCollectionEntry(collection, this._getParentPath(collection), ignoreFolder);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        this.contentHandler.endPrefixMapping("zip");
        this.contentHandler.endDocument();
    }

    private String _getParentPath(AmetysObject ao) {
        String parentPath = "";
        if (ao.getParent() instanceof ExplorerNode) {
            parentPath = ((ExplorerNode)ao.getParent()).getExplorerPath();
        }
        return parentPath;
    }

    private void _saxResourceCollectionEntry(ResourceCollection collection, String fromPath, boolean ignoreFolder) throws SAXException {
        AmetysObjectIterable children = collection.getChildren();
        for (AmetysObject child : children) {
            if (child instanceof Resource) {
                Resource resource = (Resource)child;
                this._saxResourceEntry(resource, fromPath);
                continue;
            }
            if (ignoreFolder || !(child instanceof ResourceCollection)) continue;
            this._saxResourceCollectionEntry((ResourceCollection)child, fromPath, ignoreFolder);
        }
    }

    private void _saxResourceEntry(Resource resource, String fromPath) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("name", resource.getResourcePath().substring(fromPath.length() + 1));
        attrs.addCDATAAttribute("src", "cocoon:/resource?id=" + URIUtils.encodeParameter((String)resource.getId()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry", (Attributes)attrs);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry");
    }
}

