/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.jcr;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourceFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CopiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultLockableAmetysObject;
import org.ametys.plugins.repository.jcr.DublinCoreHelper;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.metadata.MetadataAwareAmetysObject;
import org.ametys.plugins.repository.metadata.ModifiableMetadataAwareAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObjectHelper;
import org.ametys.plugins.repository.trash.TrashElement;
import org.ametys.plugins.repository.trash.TrashableAmetysObject;
import org.ametys.plugins.repository.trash.UnknownParentException;
import org.apache.commons.lang3.StringUtils;

public class JCRResource<F extends JCRResourceFactory>
extends DefaultLockableAmetysObject<F>
implements ModifiableResource,
CopiableAmetysObject,
TrashableAmetysObject {
    public static final String CREATOR_NODE_NAME = "creator";
    public static final String CREATION_DATE = "creationDate";
    public static final String CONTRIBUTOR_NODE_NAME = "contributor";

    public JCRResource(Node node, String parentPath, F factory) {
        super(node, parentPath, factory);
    }

    @Override
    public void setData(InputStream stream, String mimeType, Date lastModified, UserIdentity author) {
        Node fileNode = this.getNode();
        try {
            this.setLastContributor(author);
            Node resourceNode = null;
            if (fileNode.hasNode("jcr:content")) {
                resourceNode = fileNode.getNode("jcr:content");
            } else {
                resourceNode = fileNode.addNode("jcr:content", "nt:resource");
                this.setCreator(author);
                this.setCreationDate(new Date());
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(lastModified);
            resourceNode.setProperty("jcr:lastModified", (Calendar)gc);
            resourceNode.setProperty("jcr:mimeType", mimeType);
            Binary binary = resourceNode.getSession().getValueFactory().createBinary(stream);
            resourceNode.setProperty("jcr:data", binary);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set data for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setLastModified(Date lastModified) {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = fileNode.getNode("jcr:content");
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(lastModified);
            resourceNode.setProperty("jcr:lastModified", (Calendar)gc);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set lastmodified for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setKeywords(String keywords) {
        String[] words = StringUtils.stripAll((String[])StringUtils.split((String)keywords, (char)','));
        String[] trimWords = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            trimWords[i] = words[i].trim();
        }
        Node fileNode = this.getNode();
        try {
            fileNode.setProperty("ametys:keywords", trimWords);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set keywords for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setKeywords(String[] keywords) {
        Node fileNode = this.getNode();
        try {
            fileNode.setProperty("ametys:keywords", keywords);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set keywords for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setMimeType(String mimeType) {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = fileNode.getNode("jcr:content");
            resourceNode.setProperty("jcr:mimeType", mimeType);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set mimetype for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setCreator(UserIdentity author) {
        try {
            Node authorNode = null;
            authorNode = this.getNode().hasNode("ametys:creator") ? this.getNode().getNode("ametys:creator") : this.getNode().addNode("ametys:creator", "ametys:user");
            authorNode.setProperty("ametys:login", author.getLogin());
            authorNode.setProperty("ametys:population", author.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set creator for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = null;
            if (fileNode.hasNode("jcr:content")) {
                resourceNode = fileNode.getNode("jcr:content");
                return resourceNode.getProperty("jcr:data").getBinary().getStream();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get inputstream for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public String getMimeType() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = null;
            if (fileNode.hasNode("jcr:content")) {
                resourceNode = fileNode.getNode("jcr:content");
                return resourceNode.getProperty("jcr:mimeType").getString();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get mimetype for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public Date getLastModified() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = null;
            if (fileNode.hasNode("jcr:content")) {
                resourceNode = fileNode.getNode("jcr:content");
                return resourceNode.getProperty("jcr:lastModified").getDate().getTime();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get lastmodified for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public long getLength() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            Node resourceNode = null;
            if (fileNode.hasNode("jcr:content")) {
                resourceNode = fileNode.getNode("jcr:content");
                return resourceNode.getProperty("jcr:data").getLength();
            }
            return 0L;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get length for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public UserIdentity getCreator() throws AmetysRepositoryException {
        try {
            Node authorNode = this.getNode().getNode("ametys:creator");
            return new UserIdentity(authorNode.getProperty("ametys:login").getString(), authorNode.getProperty("ametys:population").getString());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get creator for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public UserIdentity getAuthorFromRevision(String revision) throws RepositoryException {
        try {
            this.switchToRevision(revision);
            VersionHistory history = this.getVersionHistory();
            Version versionNode = history.getVersion(revision);
            Node frozenNode = versionNode.getNode("jcr:frozenNode");
            if (frozenNode.hasNode("ametys:creator")) {
                Node authorNode = frozenNode.getNode("ametys:creator");
                return new UserIdentity(authorNode.getProperty("ametys:login").getString(), authorNode.getProperty("ametys:population").getString());
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get author from revision: " + revision + " of resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public String[] getKeywords() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            if (!fileNode.hasProperty("ametys:keywords")) {
                return new String[0];
            }
            Value[] values = fileNode.getProperty("ametys:keywords").getValues();
            String[] result = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i].getString();
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get keywords for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public String getKeywordsAsString() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            Value[] values;
            if (!fileNode.hasProperty("ametys:keywords")) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Value value : values = fileNode.getProperty("ametys:keywords").getValues()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(value.getString());
            }
            return sb.toString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get keywords for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    protected void restoreFromNode(Node node) throws RepositoryException {
        super.restoreFromNode(node);
        NodeIterator nit = this.getBaseNode().getNodes("jcr:content");
        while (nit.hasNext()) {
            nit.nextNode().remove();
        }
        NodeIterator new_nit = node.getNodes("jcr:content");
        while (new_nit.hasNext()) {
            this.copyNode(this.getBaseNode(), new_nit.nextNode());
        }
    }

    @Override
    public String getResourcePath() throws AmetysRepositoryException {
        return ((ExplorerNode)this.getParent()).getExplorerPath() + "/" + this.getName();
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        try {
            String nodeTypeName = NodeTypeHelper.getNodeTypeName((Node)this.getNode());
            JCRResource copiedResource = (JCRResource)parent.createChild(name, nodeTypeName);
            copiedResource.setKeywords(this.getKeywords());
            copiedResource.setData(this.getInputStream(), this.getMimeType(), this.getLastModified(), this.getCreator());
            parent.saveChanges();
            return copiedResource;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error copying the collection " + this.getId() + " into " + parent.getId(), (Throwable)e);
        }
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }

    public String getDCTitle() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCTitle((MetadataAwareAmetysObject)this, (String)this.getName());
    }

    public void setDCTitle(String title) throws AmetysRepositoryException {
        DublinCoreHelper.setDCTitle((ModifiableMetadataAwareAmetysObject)this, (String)title);
    }

    public String getDCCreator() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCCreator((MetadataAwareAmetysObject)this);
    }

    public void setDCCreator(String creator) throws AmetysRepositoryException {
        DublinCoreHelper.setDCCreator((ModifiableMetadataAwareAmetysObject)this, (String)creator);
    }

    public String[] getDCSubject() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCSubject((MetadataAwareAmetysObject)this, (String[])this.getKeywords());
    }

    public void setDCSubject(String[] subject) throws AmetysRepositoryException {
        DublinCoreHelper.setDCSubject((ModifiableMetadataAwareAmetysObject)this, (String[])subject);
    }

    public String getDCDescription() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCDescription((MetadataAwareAmetysObject)this);
    }

    public void setDCDescription(String description) throws AmetysRepositoryException {
        DublinCoreHelper.setDCDescription((ModifiableMetadataAwareAmetysObject)this, (String)description);
    }

    public String getDCPublisher() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCPublisher((MetadataAwareAmetysObject)this);
    }

    public void setDCPublisher(String publisher) throws AmetysRepositoryException {
        DublinCoreHelper.setDCPublisher((ModifiableMetadataAwareAmetysObject)this, (String)publisher);
    }

    public String getDCContributor() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCContributor((MetadataAwareAmetysObject)this, (String)UserIdentity.userIdentityToString((UserIdentity)this.getCreator()));
    }

    public void setDCContributor(String contributor) throws AmetysRepositoryException {
        DublinCoreHelper.setDCContributor((ModifiableMetadataAwareAmetysObject)this, (String)contributor);
    }

    public Date getDCDate() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCDate((MetadataAwareAmetysObject)this, (Date)this.getLastModified());
    }

    public void setDCDate(Date date) throws AmetysRepositoryException {
        DublinCoreHelper.setDCDate((ModifiableMetadataAwareAmetysObject)this, (Date)date);
    }

    public String getDCType() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCType((MetadataAwareAmetysObject)this, (String)this._getDefaultDCType());
    }

    private String _getDefaultDCType() {
        String mimetype = this.getMimeType();
        if (mimetype == null) {
            return "Text";
        }
        if (mimetype.startsWith("image")) {
            return "Image";
        }
        if (mimetype.startsWith("video") || "application/x-shockwave-flash".equals(mimetype)) {
            return "InteractiveResource";
        }
        if (mimetype.startsWith("audio")) {
            return "Sound";
        }
        return "Text";
    }

    public void setDCType(String type) throws AmetysRepositoryException {
        DublinCoreHelper.setDCType((ModifiableMetadataAwareAmetysObject)this, (String)type);
    }

    public String getDCFormat() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCFormat((MetadataAwareAmetysObject)this, (String)this.getMimeType());
    }

    public void setDCFormat(String format) throws AmetysRepositoryException {
        DublinCoreHelper.setDCFormat((ModifiableMetadataAwareAmetysObject)this, (String)format);
    }

    public String getDCIdentifier() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCIdentifier((MetadataAwareAmetysObject)this, (String)this.getId());
    }

    public void setDCIdentifier(String identifier) throws AmetysRepositoryException {
        DublinCoreHelper.setDCIdentifier((ModifiableMetadataAwareAmetysObject)this, (String)identifier);
    }

    public String getDCSource() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCSource((MetadataAwareAmetysObject)this);
    }

    public void setDCSource(String source) throws AmetysRepositoryException {
        DublinCoreHelper.setDCSource((ModifiableMetadataAwareAmetysObject)this, (String)source);
    }

    public String getDCLanguage() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCLanguage((MetadataAwareAmetysObject)this);
    }

    public void setDCLanguage(String language) throws AmetysRepositoryException {
        DublinCoreHelper.setDCLanguage((ModifiableMetadataAwareAmetysObject)this, (String)language);
    }

    public String getDCRelation() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCRelation((MetadataAwareAmetysObject)this);
    }

    public void setDCRelation(String relation) throws AmetysRepositoryException {
        DublinCoreHelper.setDCRelation((ModifiableMetadataAwareAmetysObject)this, (String)relation);
    }

    public String getDCCoverage() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCCoverage((MetadataAwareAmetysObject)this, (String)this.getDCLanguage());
    }

    public void setDCCoverage(String coverage) throws AmetysRepositoryException {
        DublinCoreHelper.setDCCoverage((ModifiableMetadataAwareAmetysObject)this, (String)coverage);
    }

    public String getDCRights() throws AmetysRepositoryException {
        return DublinCoreHelper.getDCRights((MetadataAwareAmetysObject)this);
    }

    public void setDCRights(String rights) throws AmetysRepositoryException {
        DublinCoreHelper.setDCRights((ModifiableMetadataAwareAmetysObject)this, (String)rights);
    }

    @Override
    public Date getCreationDate() throws AmetysRepositoryException {
        Node fileNode = this.getNode();
        try {
            if (!fileNode.hasProperty("ametys:creationDate")) {
                return null;
            }
            return fileNode.getProperty("ametys:creationDate").getDate().getTime();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get creation date for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setCreationDate(Date creationDate) {
        Node fileNode = this.getNode();
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(creationDate);
            fileNode.setProperty("ametys:creationDate", (Calendar)calendar);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set create date for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public UserIdentity getLastContributor() throws AmetysRepositoryException {
        try {
            Node authorNode = this.getNode().getNode("ametys:contributor");
            return new UserIdentity(authorNode.getProperty("ametys:login").getString(), authorNode.getProperty("ametys:population").getString());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get last contributor for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    @Override
    public void setLastContributor(UserIdentity lastContributor) {
        try {
            Node lastContributorNode = null;
            lastContributorNode = this.getNode().hasNode("ametys:contributor") ? this.getNode().getNode("ametys:contributor") : this.getNode().addNode("ametys:contributor", "ametys:user");
            lastContributorNode.setProperty("ametys:login", lastContributor.getLogin());
            lastContributorNode.setProperty("ametys:population", lastContributor.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set last contributor for resource " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public void tag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)tag);
    }

    public void untag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)tag);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this);
    }

    public TrashElement moveToTrash() {
        TrashElement trashElement = ((JCRResourceFactory)this._getFactory())._getTrashElementDAO().createTrashElement((TrashableAmetysObject)this, this.getName());
        Node storedNode = NodeHelper.cloneNode((Node)this.getNode(), (Node)trashElement.getNode());
        try {
            storedNode.setProperty("ametys-internal:path", this.getParentPath());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("failed to store the content path", (Throwable)e);
        }
        this.remove();
        return trashElement;
    }

    public JCRResource restoreFromTrash() throws UnknownParentException {
        try {
            JCRTraversableAmetysObject parent;
            Property property = this.getNode().getProperty("ametys-internal:path");
            String parentPath = property.getValue().getString();
            property.remove();
            try {
                parent = (JCRTraversableAmetysObject)((JCRResourceFactory)this._getFactory())._getResolver().resolveByPath(parentPath);
            }
            catch (UnknownAmetysObjectException e) {
                throw new UnknownParentException("No parent available at path " + parentPath, (Throwable)e);
            }
            String nodeName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parent, (String)this.getName(), (NameHelper.NameComputationMode)NameHelper.NameComputationMode.USER_FRIENDLY, (boolean)true);
            NodeHelper.cloneNode((Node)this.getNode(), (Node)parent.getNode(), (String)nodeName);
            this.remove();
            return (JCRResource)parent.getChild(nodeName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("failed to store the content path", (Throwable)e);
        }
    }
}

