/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.jcr;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollectionFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CopiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.trash.TrashElement;
import org.ametys.plugins.repository.trash.TrashableAmetysObject;
import org.ametys.plugins.repository.trash.UnknownParentException;

public class JCRResourcesCollection<F extends JCRResourcesCollectionFactory>
extends DefaultTraversableAmetysObject<F>
implements ModifiableResourceCollection,
CopiableAmetysObject,
ModifiableModelLessDataAwareAmetysObject,
TrashableAmetysObject {
    public static final String APPLICATION_ID = "Ametys.plugins.explorer.applications.resources.Resources";
    protected static final String DATA_DESCRIPTION = "description";

    public JCRResourcesCollection(Node node, String parentPath, F factory) {
        super(node, parentPath, factory);
    }

    @Override
    public String getIconCls() {
        return "ametysicon-folder249";
    }

    @Override
    public String getApplicationId() {
        return APPLICATION_ID;
    }

    @Override
    public String getCollectionType() {
        return "ametys:resources-collection";
    }

    @Override
    public String getResourceType() {
        return "ametys:resource";
    }

    @Override
    public String getResourcePath() throws AmetysRepositoryException {
        return this.getExplorerPath();
    }

    @Override
    public String getExplorerPath() {
        AmetysObject parent = this.getParent();
        if (parent instanceof ExplorerNode) {
            return ((ExplorerNode)parent).getExplorerPath() + "/" + this.getName();
        }
        return "";
    }

    @Override
    public boolean hasChildResources() throws AmetysRepositoryException {
        AmetysObjectIterable children = this.getChildren();
        for (AmetysObject child : children) {
            if (!(child instanceof Resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildExplorerNodes() throws AmetysRepositoryException {
        AmetysObjectIterable children = this.getChildren();
        for (AmetysObject child : children) {
            if (!(child instanceof ExplorerNode)) continue;
            return true;
        }
        return false;
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        try {
            String nodeTypeName = NodeTypeHelper.getNodeTypeName((Node)this.getNode());
            JCRResourcesCollection copiedCollection = (JCRResourcesCollection)parent.createChild(name, nodeTypeName);
            parent.saveChanges();
            for (AmetysObject object : this.getChildren()) {
                if (!(object instanceof CopiableAmetysObject)) continue;
                ((CopiableAmetysObject)object).copyTo((ModifiableTraversableAmetysObject)copiedCollection, object.getName());
            }
            return copiedCollection;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error copying the collection " + this.getId() + " into " + parent.getId(), (Throwable)e);
        }
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }

    @Override
    public String getDescription() {
        return (String)this.getValue(DATA_DESCRIPTION, null);
    }

    @Override
    public void setDescription(String description) {
        this.setValue(DATA_DESCRIPTION, description);
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder(((JCRResourcesCollectionFactory)this._getFactory()).getDataTypesExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }

    public TrashElement moveToTrash() {
        TrashElement trashElement = ((JCRResourcesCollectionFactory)this._getFactory())._getTrashElementDAO().createTrashElement((TrashableAmetysObject)this, this.getName());
        Node storedNode = NodeHelper.cloneNode((Node)this.getNode(), (Node)trashElement.getNode());
        try {
            storedNode.setProperty("ametys-internal:path", this.getParentPath());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("failed to store the content path", (Throwable)e);
        }
        this.remove();
        return trashElement;
    }

    public JCRResourcesCollection restoreFromTrash() throws UnknownParentException {
        try {
            JCRTraversableAmetysObject parent;
            Property property = this.getNode().getProperty("ametys-internal:path");
            String parentPath = property.getValue().getString();
            property.remove();
            try {
                parent = (JCRTraversableAmetysObject)((JCRResourcesCollectionFactory)this._getFactory())._getResolver().resolveByPath(parentPath);
            }
            catch (UnknownAmetysObjectException e) {
                throw new UnknownParentException("No parent available at path " + parentPath, (Throwable)e);
            }
            String nodeName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parent, (String)this.getName(), (NameHelper.NameComputationMode)NameHelper.NameComputationMode.USER_FRIENDLY, (boolean)true);
            NodeHelper.cloneNode((Node)this.getNode(), (Node)parent.getNode(), (String)nodeName);
            this.remove();
            return (JCRResourcesCollection)parent.getChild(nodeName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("failed to store the content path", (Throwable)e);
        }
    }
}

