/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.metadata.populate;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.metadata.populate.ResourceMetadataPopulator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;

public class DublinCorePopulator
extends AbstractLogEnabled
implements ResourceMetadataPopulator,
Configurable {
    private Set<String> _types;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] types;
        this._types = new HashSet<String>();
        for (Configuration type : types = configuration.getChild("types").getChildren("type")) {
            this._types.add(type.getValue());
        }
    }

    @Override
    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this._types);
    }

    @Override
    public void populate(ModifiableResource resource, Metadata metadata) {
        String creator = metadata.get(DublinCore.CREATOR);
        String contributor = metadata.get(DublinCore.CONTRIBUTOR);
        String coverage = metadata.get(DublinCore.COVERAGE);
        Date date = metadata.getDate(DublinCore.DATE);
        String description = metadata.get(DublinCore.DESCRIPTION);
        String format = metadata.get(DublinCore.FORMAT);
        String identifier = metadata.get(DublinCore.IDENTIFIER);
        String language = metadata.get(DublinCore.LANGUAGE);
        String publisher = metadata.get(DublinCore.PUBLISHER);
        String relation = metadata.get(DublinCore.RELATION);
        String rights = metadata.get(DublinCore.RIGHTS);
        String source = metadata.get(DublinCore.SOURCE);
        String[] subject = metadata.getValues(DublinCore.SUBJECT);
        String title = metadata.get(DublinCore.TITLE);
        String type = metadata.get(DublinCore.TYPE);
        this._setDCCreator(resource, creator);
        this._setDCContributor(resource, contributor);
        this._setDCCoverage(resource, coverage);
        this._setDCDate(resource, date);
        this._setDCDescription(resource, description);
        this._setDCFormat(resource, format);
        this._setDCIdentifier(resource, identifier);
        this._setDCLanguage(resource, language);
        this._setDCPublisher(resource, publisher);
        this._setDCRelation(resource, relation);
        this._setDCRights(resource, rights);
        this._setDCSource(resource, source);
        this._setDCSubject(resource, subject);
        this._setDCTitle(resource, title);
        this._setDCType(resource, type);
    }

    protected void _setDCCreator(ModifiableResource resource, String creator) {
        if (creator != null) {
            resource.setDCCreator(creator);
        }
    }

    protected void _setDCContributor(ModifiableResource resource, String contributor) {
        if (contributor != null) {
            resource.setDCContributor(contributor);
        }
    }

    protected void _setDCCoverage(ModifiableResource resource, String coverage) {
        if (coverage != null) {
            resource.setDCCoverage(coverage);
        }
    }

    protected void _setDCDate(ModifiableResource resource, Date date) {
        if (date != null) {
            resource.setDCDate(date);
        }
    }

    protected void _setDCDescription(ModifiableResource resource, String description) {
        if (description != null) {
            resource.setDCDescription(description);
        }
    }

    protected void _setDCFormat(ModifiableResource resource, String format) {
        if (format != null) {
            resource.setDCFormat(format);
        }
    }

    protected void _setDCIdentifier(ModifiableResource resource, String identifier) {
        if (identifier != null) {
            resource.setDCIdentifier(identifier);
        }
    }

    protected void _setDCLanguage(ModifiableResource resource, String language) {
        if (language != null) {
            resource.setDCLanguage(language);
        }
    }

    protected void _setDCPublisher(ModifiableResource resource, String publisher) {
        if (publisher != null) {
            resource.setDCPublisher(publisher);
        }
    }

    protected void _setDCRelation(ModifiableResource resource, String relation) {
        if (relation != null) {
            resource.setDCRelation(relation);
        }
    }

    protected void _setDCRights(ModifiableResource resource, String rights) {
        if (rights != null) {
            resource.setDCRights(rights);
        }
    }

    protected void _setDCSource(ModifiableResource resource, String source) {
        if (source != null) {
            resource.setDCSource(source);
        }
    }

    protected void _setDCSubject(ModifiableResource resource, String[] subject) {
        if (subject != null && subject.length > 0) {
            resource.setDCSubject(subject);
        }
    }

    protected void _setDCTitle(ModifiableResource resource, String title) {
        if (title != null) {
            resource.setDCTitle(title);
        }
    }

    protected void _setDCType(ModifiableResource resource, String type) {
        if (type != null) {
            resource.setDCType(type);
        }
    }
}

