/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.metadata.populate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.explorer.resources.metadata.populate.ResourceMetadataPopulator;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class ResourceMetadataPopulatorExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<ResourceMetadataPopulator> {
    public static final String ROLE = ResourceMetadataPopulatorExtensionPoint.class.getName();
    private Map<String, Set<ResourceMetadataPopulator>> _types;

    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        this.initializePopulatorMap();
    }

    protected void initializePopulatorMap() {
        this._types = new HashMap<String, Set<ResourceMetadataPopulator>>();
        for (String id : this.getExtensionsIds()) {
            ResourceMetadataPopulator populator = (ResourceMetadataPopulator)this.getExtension(id);
            if (populator.getTypes() == null || populator.getTypes().isEmpty()) {
                this.addPopulator("", populator);
                continue;
            }
            for (String type : populator.getTypes()) {
                this.addPopulator(type, populator);
            }
        }
    }

    protected void addPopulator(String type, ResourceMetadataPopulator populator) {
        Set<Object> types;
        if (this._types.containsKey(type)) {
            types = this._types.get(type);
        } else {
            types = new HashSet();
            this._types.put(type, types);
        }
        types.add(populator);
    }

    public Collection<ResourceMetadataPopulator> getPopulators(String type) {
        HashSet<ResourceMetadataPopulator> populators = new HashSet<ResourceMetadataPopulator>();
        if (this._types.containsKey("")) {
            populators.addAll((Collection)this._types.get(""));
        }
        if (this._types.containsKey(type)) {
            populators.addAll((Collection<ResourceMetadataPopulator>)this._types.get(type));
        }
        return populators;
    }
}

