/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.resources.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.cocoon.AbstractResourceReader;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class AmetysResourceReader
extends AbstractResourceReader
implements Serviceable,
CacheableProcessingComponent {
    protected AmetysObjectResolver _resolver;
    protected Resource _object;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager sManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)sManager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)sManager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)sManager.lookup(CurrentUserProvider.ROLE);
    }

    protected void doSetup(SourceResolver res, Map objModel, String src, Parameters par) throws ProcessingException, IOException {
        String id = par.getParameter("id", null);
        String path = par.getParameter("path", null);
        String version = par.getParameter("version", null);
        try {
            this._object = id != null ? (Resource)this._resolver.resolveById(id) : (Resource)this._resolver.resolveByPath(FilenameUtils.decode((String)path.substring(1)));
            this.checkUserAccess();
            if (!StringUtils.isEmpty((CharSequence)version) && this._object instanceof VersionableAmetysObject) {
                ((VersionableAmetysObject)this._object).switchToRevision(version);
            }
        }
        catch (UnknownAmetysObjectException e) {
            if (id != null) {
                throw new ResourceNotFoundException(String.format("The resource with id '%s' does not exist", id));
            }
            throw new ResourceNotFoundException(String.format("The resource at path '%s' does not exist", path));
        }
    }

    protected InputStream getInputStream() {
        return this._object.getInputStream();
    }

    protected String getFilename() {
        return this._object.getName();
    }

    protected String getEncodedFilename() {
        String name = this._object.getName();
        return FilenameUtils.encodeName((String)name);
    }

    protected long getLength() {
        return this._object.getLength();
    }

    protected void checkUserAccess() throws AuthorizationRequiredException, AccessDeniedException {
        UserIdentity user = this._currentUserProvider.getUser();
        if (user == null) {
            if (!this._rightManager.hasAnonymousReadAccess((Object)this._object.getParent())) {
                throw new AuthorizationRequiredException(null);
            }
        } else if (!this._rightManager.hasReadAccess(user, (Object)this._object.getParent())) {
            throw new AccessDeniedException("User " + String.valueOf(user) + " has no right to access the resource " + this._object.getId());
        }
    }

    public Serializable getKey() {
        return this._object.getId() + this.getKeySuffix();
    }

    public SourceValidity getValidity() {
        return new TimeStampValidity(this.getLastModified());
    }

    public long getLastModified() {
        return this._object.getLastModified().getTime();
    }

    public String getMimeType() {
        return this._object.getMimeType();
    }

    public void recycle() {
        super.recycle();
        this._object = null;
    }
}

