/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.rights;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ResourceAccessController
extends AbstractHierarchicalAccessController<AmetysObject> {
    public static final I18nizableText RESOURCE_CONTEXT_CATEGORY = new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RIGHT_ASSIGNMENT_CONTEXT_RESOURCES_LABEL");
    protected ExplorerResourcesDAO _resourcesDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resourcesDAO = (ExplorerResourcesDAO)((Object)manager.lookup(ExplorerResourcesDAO.ROLE));
    }

    public boolean supports(Object object) {
        if (object instanceof ExplorerNode) {
            ExplorerNode node = (ExplorerNode)object;
            return this._isPartOfResourceExplorer(node.getPath());
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return this._isPartOfResourceExplorer(resource.getPath());
        }
        return false;
    }

    private boolean _isPartOfResourceExplorer(String path) {
        for (Pattern pattern : this._resourcesDAO.getExplorerNodePathPatterns()) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    protected Set<AmetysObject> _getParents(AmetysObject object) {
        AmetysObject parent = object.getParent();
        if (parent instanceof ExplorerNode) {
            return Collections.singleton(parent);
        }
        return null;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        if (workspacesContexts.contains("/cms")) {
            HashSet<ExplorerNode> resourcesRootContexts = new HashSet<ExplorerNode>();
            resourcesRootContexts.addAll(this._resourcesDAO.getResourcesRootNodes());
            return resourcesRootContexts;
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        Map<String, I18nizableText> params = Map.of("name", this.getObjectLabel(object));
        if (object instanceof Resource) {
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_RESOURCE_CONTEXT_LABEL", params);
        }
        if (object instanceof ExplorerNode) {
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_EXPLORER_NODE_CONTEXT_LABEL", params);
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) throws RightsException {
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_PATH", Map.of("parent", this.getObjectLabel(resource.getParent()), "child", new I18nizableText(resource.getName())));
        }
        if (object instanceof ExplorerNode) {
            ExplorerNode node = (ExplorerNode)object;
            if (this._resourcesDAO.getResourcesRootNodes().contains(node)) {
                return this._resourcesDAO.getRootNodeLabel(node);
            }
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_PATH", Map.of("parent", this.getObjectLabel(node.getParent()), "child", new I18nizableText(node.getName())));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return RESOURCE_CONTEXT_CATEGORY;
    }
}

