/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.explorer.statistics;

import java.util.HashMap;
import java.util.List;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ExplorerStatisticsProvider
implements StatisticsProvider,
Serviceable,
PluginAware {
    private static String __FOLDER_COUNT = "FOLDERCOUNT";
    private static String __RESOURCE_COUNT = "RESOURCECOUNT";
    private static String __TOTAL_SIZE = "TOTALSIZE";
    private String _id;
    private ExplorerResourcesDAO _explorerResourcesDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._explorerResourcesDAO = (ExplorerResourcesDAO)((Object)manager.lookup(ExplorerResourcesDAO.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public Statistics getStatistics() {
        HashMap<String, Long> values = new HashMap<String, Long>();
        values.put(__FOLDER_COUNT, 0L);
        values.put(__RESOURCE_COUNT, 0L);
        values.put(__TOTAL_SIZE, 0L);
        for (ExplorerNode explorerNode : this._explorerResourcesDAO.getResourcesRootNodes()) {
            this._processResources((ResourceCollection)explorerNode, values);
        }
        return new StatisticsNode(this._id, new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_STATISTICS_LABEL"), "ametysicon-folder249", (Object)values.get(__TOTAL_SIZE), List.of(new StatisticsValue("folders", new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_STATISTICS_FOLDERS_LABEL"), "ametysicon-folder250", (Object)values.get(__FOLDER_COUNT)), new StatisticsValue("files", new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_STATISTICS_FILES_LABEL"), "ametysicon-document77", (Object)values.get(__RESOURCE_COUNT))), true);
    }

    private void _processResources(TraversableAmetysObject resourceContainer, HashMap<String, Long> values) {
        AmetysObjectIterable objects = resourceContainer.getChildren();
        for (AmetysObject object : objects) {
            if (object instanceof ResourceCollection) {
                values.put(__FOLDER_COUNT, values.get(__FOLDER_COUNT) + 1L);
                this._processResources((ResourceCollection)object, values);
                continue;
            }
            if (!(object instanceof Resource)) continue;
            Resource resource = (Resource)object;
            values.put(__RESOURCE_COUNT, values.get(__RESOURCE_COUNT) + 1L);
            values.put(__TOTAL_SIZE, values.get(__TOTAL_SIZE) + resource.getLength());
        }
    }
}

