/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of an explorer node.
 */
Ext.define('Ametys.explorer.ExplorerNode', {
	config: {
		/**
		 * @cfg {String} id The unique id of the explorer node
		 */
		/**
		 * @method getId Get the #cfg-id
		 * @return {String} The id
		 */
		/** @ignore */
		id: null,
		/**
		 * @cfg {String} rootId The id of the root explorer node of the element
		 */
		/**
		 * @method getRootId Get the #cfg-rootId
		 * @return {String} The root id
		 */
		/** @ignore */
		rootId: null,
		/**
		 * @cfg {String} rootOwnerType The type of root owner
		 */
		/**
		 * @method getRootOwnerType Get the #cfg-rootOwnerType
		 * @return {String} The type of root
		 */
		/** @ignore */
		rootOwnerType: null,
		/**
		 * @cfg {String} parentId The unique id of the parent
		 */
		/**
		 * @method getParentId Get the #cfg-parentId
		 * @return {String} The parent id
		 */
		/** @ignore */
		parentId: null,
		/**
		 * @cfg {String} name The name of the explorer node
		 */
		/**
		 * @method getName Get the #cfg-name
		 * @return {String} The name
		 */
		/** @ignore */
		name: null,
		/**
		 * @cfg {String} path The path in the resource explorer
		 */
		/**
		 * @method getPath Get the #cfg-path
		 * @return {String} The path
		 */
		/** @ignore */
		path: null,
		/**
		 * @cfg {boolean} isModifiable True if this explorer node can be modified. False if it read-only: this is not about rights. Can
		 *      be false for a virtual explorer node dynamically created by reading a CMIS server... but basically not stored in JCR
		 */
		/**
		 * @method getIsModifiable Get the #cfg-isModifiable
		 * @return {boolean} The isModifiable
		 */
		/** @ignore */
		isModifiable: false,
		/**
		 * @cfg {boolean} canCreateChild True if this explorer node is traversable.
		 */
		/**
		 * @method getCanCreateChild Get the #cfg-canCreateChild
		 * @return {boolean} The can create child status
		 */
		/** @ignore */
		canCreateChild: false,
		/**
		 * @cfg {String} applicationId The id of application the explorer node belongs to.
		 */
		/**
		 * @method getApplicationId Get the #cfg-applicationId
		 * @return {String} The application id
		 */
		/** @ignore */
		applicationId: null,
		/**
		 * @cfg {String[]} rights List of the id of the rights the current user have on this explorer node
		 */
		/**
		 * @method getRights Get the #cfg-rights
		 * @return {String[]} The rights
		 */
		/** @ignore */
		rights: []
	},
		
	/**
	 * Creates a explorer node instance
	 * @param {Object} config See configuration doc.
	 */
	constructor: function (config)
	{
		this.initConfig(config);
	},
	
	/**
	 * Get the explorer node's properties
	 * @return {Object} The explorer node's properties
	 */
	getProperties: function (initialProperty)
	{
		return Ext.apply ({
			id: this._id,
			applicationId: this._applicationId,
			rootId: this._rootId,
			rootOwnerType: this._rootOwnerType,
			parentId: this._parentId,
			name: this._name,
			path: this._path,
			isModifiable : this._isModifiable,
			canCreateChild : this._canCreateChild,
			rights: this._rights,
            pathPrefix: this.getPathPrefix()
		}, initialProperty);
	},
	
	/**
	 * Get the node path prefix
	 * @return {String} the path prefix
	 */
	getPathPrefix: function()
	{
		return '/resources';
	},
	
	/**
	 * Get the user friendly name of the node.
	 * Which is the name by default
	 * @return {String} The text of the node
	 */
    getText: function()
    {
        if (this._rootId == this._id)
        {
            return "{{i18n plugin.explorer:PLUGINS_EXPLORER_ROOT_NODE}}";
        }
        
        return this._name;
    }
});

