/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a resource of the explorer
 */
Ext.define("Ametys.explorer.Resource", {
	config: {
		/**
		 * @cfg {String} id The unique id of the resource
		 */
		/**
		 * @method getId Get the #cfg-id
		 * @return {String} The id
		 */
		/** @ignore */
		id: null,
		/**
		 * @cfg {String} rootId The id of the root explorer node of the element
		 */
		/**
		 * @method getRootId Get the #cfg-rootId
		 * @return {String} The root id
		 */
		/** @ignore */
		rootId: null,
		/**
		 * @cfg {String} rootOwnerType The type of root owner
		 */
		/**
		 * @method getRootOwnerType Get the #cfg-rootOwnerType
		 * @return {String} The type of root
		 */
		/** @ignore */
		rootOwnerType: null,
		/**
		 * @cfg {String} parentId The unique id of the parent
		 */
		/**
		 * @method getParentId Get the #cfg-parentId
		 * @return {String} The parent id
		 */
		/** @ignore */
		parentId: null,
		/**
		 * @cfg {String} name The name of the resource
		 */
		/**
		 * @method getName Get the #cfg-name
		 * @return {String} The name
		 */
		/** @ignore */
		name: null,
		/**
		 * @cfg {String} path The path in the resource explorer
		 */
		/**
		 * @method getPath Get the #cfg-path
		 * @return {String} The path
		 */
		/** @ignore */
		path: null,
		/**
		 * @cfg {boolean} isModifiable True if this resource can be modified. False if it read-only: this is not about rights. Can be false for a virtual resource dynamically created by reading a CMIS server... but basically not stored in JCR
		 */
		/**
		 * @method getIsModifiable Get the #cfg-isModifiable
		 * @return {boolean} The is modifiable status
		 */
		/** @ignore */
		isModifiable: false,
		/**
		 * @cfg {String[]} rights List of the id of the rights the current user have on this resource
		 */
		/**
		 * @method getRights Get the #cfg-rights
		 * @return {String[]} The rights
		 */
		/** @ignore */
		rights: []
	},
	
	/**
	 * Creates a resource instance
	 * @param {Object} config See configuration doc.
	 */
	constructor: function (config)
	{
		this.initConfig(config);
	},
	
	/**
	 * Get the resource's properties
	 * @return {Object} The resource's properties
	 */
	getProperties: function (initialProperty)
	{
		return Ext.apply ({
			id: this._id,
			parentId: this._parentId,
			rootId: this._rootId,
			rootOwnerType: this._rootOwnerType,
			name: this._name,
			path: this._path,
			isModifiable : this._isModifiable,
			rights: this._rights,
            pathPrefix: this.getPathPrefix()
		}, initialProperty);
	},
	
	/**
	 * Get the resource path prefix
	 * @return {String} the path prefix
	 */
	getPathPrefix: function()
	{
		return '/resources';
	}
});

