/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton to be used to retrieves the available application
 */
Ext.define('Ametys.explorer.applications.ExplorerApplicationProvider', {
	singleton: true,
	
	/**
	 * @private
	 * @property {Object} _applications The application map (id <-> application)
	 */
	_applications: {},
	
	/**
	 * @private
	 * @property {String[]} _targetsId the list of message target ids corresponding to the registered applications
	 */
	_targetsId: null,
	
	/**
	 * Register an application to the explorer
	 * @param {Ametys.explorer.applications.ExplorerApplication} application The application to register
	 */
	registerApplication: function(application)
	{
		// Register the application
		this._applications[application.getId()] = application;
	},
	
	/**
	 * Retrieves an application by its id
	 * @param {String} id the application id
	 * @return {Ametys.explorer.applications.ExplorerApplication} The retrieved application or null
	 */
	getApplication: function(id)
	{
		return this.getApplications()[id] || null;
	},
	
	/**
	 * Retrieves the application map
	 * @return {Object} The application map
	 */
	getApplications: function()
	{
		return this._applications;
	},
	
	/**
	 * Retrieves the list of the registered message target type
	 * @return {String[]} the list of the registered message target type
	 */
	getRegisteredMessageTargetTypes: function()
	{
		if (!this._targetsId)
		{
			// Initialize the types
			this._targetsId = [];
			
			
			// Register application message target types
			var type;
			
			Ext.Object.eachValue(this._applications, function(application) {
				targetId = application.getMessageTargetId();
				if (!Ext.Array.contains(this._targetsId, targetId))
				{
					this._targetsId.push(targetId);
				}
			}, this);
		}
		
		return this._targetsId;
	}
});
